/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractAll$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractBase;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractBase$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, regexp[, idx]) - Extract all strings in the `str` that match the `regexp`\n    expression and corresponding to the regex group index.\n  ", arguments="\n    Arguments:\n      * str - a string expression.\n      * regexp - a string representing a regular expression. The regex string should be a\n          Java regular expression.<br><br>\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser. For example, to match \"\\abc\", a regular expression for `regexp` can be\n          \"^\\\\abc$\".<br><br>\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n      * idx - an integer expression that representing the group index. The regex may contains\n          multiple groups. `idx` indicates which regex group to extract. The group index should\n          be non-negative. The minimum value of `idx` is 0, which means matching the entire\n          regular expression. If `idx` is not specified, the default group index value is 1. The\n          `idx` parameter is the Java regex Matcher group() method index.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('100-200, 300-400', '(\\\\d+)-(\\\\d+)', 1);\n       [\"100\",\"300\"]\n  ", since="3.1.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u0010!\u00016B\u0001b\u000f\u0001\u0003\u0016\u0004%\t\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0012)A\u0005{!A\u0011\t\u0001BK\u0002\u0013\u0005A\b\u0003\u0005C\u0001\tE\t\u0015!\u0003>\u0011!\u0019\u0005A!f\u0001\n\u0003a\u0004\u0002\u0003#\u0001\u0005#\u0005\u000b\u0011B\u001f\t\u000b\u0015\u0003A\u0011\u0001$\t\u000b\u0015\u0003A\u0011A&\t\u000bA\u0003A\u0011I)\t\u000be\u0003A\u0011\t.\t\u000b\u0005\u0004A\u0011\t2\t\u000b9\u0004A\u0011K8\t\u000bu\u0004A\u0011\u000b@\t\u0013\u0005-\u0001!!A\u0005\u0002\u00055\u0001\"CA\u000b\u0001E\u0005I\u0011AA\f\u0011%\ti\u0003AI\u0001\n\u0003\t9\u0002C\u0005\u00020\u0001\t\n\u0011\"\u0001\u0002\u0018!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00131\u0007\u0005\n\u0003\u0007\u0002\u0011\u0011!C\u0001\u0003\u000bB\u0011\"!\u0014\u0001\u0003\u0003%\t!a\u0014\t\u0013\u0005U\u0003!!A\u0005B\u0005]\u0003\"CA3\u0001\u0005\u0005I\u0011AA4\u0011%\t\t\bAA\u0001\n\u0003\n\u0019hB\u0005\u0002\u001e\u0002\n\t\u0011#\u0001\u0002 \u001aAq\u0004IA\u0001\u0012\u0003\t\t\u000b\u0003\u0004F3\u0011\u0005\u0011q\u0016\u0005\n\u0003cK\u0012\u0011!C#\u0003gC\u0011\"!.\u001a\u0003\u0003%\t)a.\t\u0013\u0005}\u0016$!A\u0005\u0002\u0006\u0005\u0007\"CAj3\u0005\u0005I\u0011BAk\u0005A\u0011VmZ#ya\u0016CHO]1di\u0006cGN\u0003\u0002\"E\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0019C%\u0001\u0005dCR\fG._:u\u0015\t)c%A\u0002tc2T!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0002\u0001'\u0011\u0001aF\r\u001d\u0011\u0005=\u0002T\"\u0001\u0011\n\u0005E\u0002#!\u0005*fO\u0016C\b/\u0012=ue\u0006\u001cGOQ1tKB\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t9\u0001K]8ek\u000e$\bCA\u001a:\u0013\tQDG\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0004tk\nTWm\u0019;\u0016\u0003u\u0002\"a\f \n\u0005}\u0002#AC#yaJ,7o]5p]\u0006A1/\u001e2kK\u000e$\b%\u0001\u0004sK\u001e,\u0007\u0010]\u0001\be\u0016<W\r\u001f9!\u0003\rIG\r_\u0001\u0005S\u0012D\b%\u0001\u0004=S:LGO\u0010\u000b\u0005\u000f\"K%\n\u0005\u00020\u0001!)1h\u0002a\u0001{!)\u0011i\u0002a\u0001{!)1i\u0002a\u0001{Q\u0019q\t\u0014(\t\u000b5C\u0001\u0019A\u001f\u0002\u0003MDQa\u0014\u0005A\u0002u\n\u0011A]\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0005%V3\u0006\f\u0005\u00024'&\u0011A\u000b\u000e\u0002\u0004\u0003:L\b\"B'\n\u0001\u0004\u0011\u0006\"B,\n\u0001\u0004\u0011\u0016!\u00019\t\u000b=K\u0001\u0019\u0001*\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u0017\t\u00039~k\u0011!\u0018\u0006\u0003=\u0012\nQ\u0001^=qKNL!\u0001Y/\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\u0002\u001d:fiRLh*Y7f+\u0005\u0019\u0007C\u00013l\u001d\t)\u0017\u000e\u0005\u0002gi5\tqM\u0003\u0002iY\u00051AH]8pizJ!A\u001b\u001b\u0002\rA\u0013X\rZ3g\u0013\taWN\u0001\u0004TiJLgn\u001a\u0006\u0003UR\n\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007A48\u0010\u0005\u0002ri6\t!O\u0003\u0002tA\u000591m\u001c3fO\u0016t\u0017BA;s\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"B<\r\u0001\u0004A\u0018aA2uqB\u0011\u0011/_\u0005\u0003uJ\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003}\u0019\u0001\u0007\u0001/\u0001\u0002fm\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0007\u000f~\f\u0019!a\u0002\t\r\u0005\u0005Q\u00021\u0001>\u0003!qWm\u001e$jeN$\bBBA\u0003\u001b\u0001\u0007Q(A\u0005oK^\u001cVmY8oI\"1\u0011\u0011B\u0007A\u0002u\n\u0001B\\3x)\"L'\u000fZ\u0001\u0005G>\u0004\u0018\u0010F\u0004H\u0003\u001f\t\t\"a\u0005\t\u000fmr\u0001\u0013!a\u0001{!9\u0011I\u0004I\u0001\u0002\u0004i\u0004bB\"\u000f!\u0003\u0005\r!P\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIBK\u0002>\u00037Y#!!\b\u0011\t\u0005}\u0011\u0011F\u0007\u0003\u0003CQA!a\t\u0002&\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003O!\u0014AC1o]>$\u0018\r^5p]&!\u00111FA\u0011\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u001b!\u0011\t9$!\u0011\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\tA\u0001\\1oO*\u0011\u0011qH\u0001\u0005U\u00064\u0018-C\u0002m\u0003s\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0012\u0011\u0007M\nI%C\u0002\u0002LQ\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2AUA)\u0011%\t\u0019\u0006FA\u0001\u0002\u0004\t9%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00033\u0002R!a\u0017\u0002bIk!!!\u0018\u000b\u0007\u0005}C'\u0001\u0006d_2dWm\u0019;j_:LA!a\u0019\u0002^\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tI'a\u001c\u0011\u0007M\nY'C\u0002\u0002nQ\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002TY\t\t\u00111\u0001S\u0003\u0019)\u0017/^1mgR!\u0011\u0011NA;\u0011!\t\u0019fFA\u0001\u0002\u0004\u0011\u0006f\u0006\u0001\u0002z\u0005}\u0014\u0011QAC\u0003\u000f\u000bY)!$\u0002\u0012\u0006M\u0015qSAM!\ry\u00131P\u0005\u0004\u0003{\u0002#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u0007\u000b\u0011\u0011\u0007\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f\u001e:-AI,w-\u001a=q72\u0002\u0013\u000e\u001a=^S\u0001j\u0003%\u0012=ue\u0006\u001cG\u000fI1mY\u0002\u001aHO]5oON\u0004\u0013N\u001c\u0011uQ\u0016\u0004\u0003m\u001d;sA\u0002\"\b.\u0019;![\u0006$8\r\u001b\u0011uQ\u0016\u0004\u0003M]3hKb\u0004\bM\u0003\u0011!A\u0001*\u0007\u0010\u001d:fgNLwN\u001c\u0011b]\u0012\u00043m\u001c:sKN\u0004xN\u001c3j]\u001e\u0004Co\u001c\u0011uQ\u0016\u0004#/Z4fq\u0002:'o\\;qA%tG-\u001a=/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\tI)\u0001Eb\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f\u001e:![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o])\u0001\u0003\u0005\t\u0011!A)\u0002#/Z4fqB\u0004S\u0006I1!gR\u0014\u0018N\\4!e\u0016\u0004(/Z:f]RLgn\u001a\u0011bAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018!)\",\u0007E]3hKb\u00043\u000f\u001e:j]\u001e\u00043\u000f[8vY\u0012\u0004#-\u001a\u0011b\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003ES1wC\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/y\t\u0014h\b\u00102s})\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I*j]\u000e,\u0007e\u00159be.\u0004#G\f\u0019-AM$(/\u001b8hA1LG/\u001a:bYN\u0004\u0003&\u001b8dYV$\u0017N\\4!e\u0016<W\r\u001f\u0011qCR$XM\u001d8tS\u0001\n'/\u001a\u0011v]\u0016\u001c8-\u00199fI\u0002Jg\u000eI8ve\u0002\u001a\u0016\u000b\u0014\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0018M]:fe:\u0002ci\u001c:!Kb\fW\u000e\u001d7fY\u0001\"x\u000eI7bi\u000eD\u0007E\t/bE\u000e\u0014C\u0006I1!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|g\u000e\t4pe\u0002\u0002'/Z4fqB\u0004\u0007eY1oA\t,'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!EycF,\u00192dI\trCH\u0019:?y\t\u0014hH\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AQCWM]3!SN\u0004\u0013\rI*R\u0019\u0002\u001awN\u001c4jO\u0002:3\u000f]1sW:\u001a\u0018\u000f\u001c\u0018qCJ\u001cXM\u001d\u0018fg\u000e\f\u0007/\u001a3TiJLgn\u001a'ji\u0016\u0014\u0018\r\\:(AQD\u0017\r\u001e\u0011dC:\u0004#-\u001a\u0011vg\u0016$\u0007\u0005^8\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002c-\u00197mE\u0006\u001c7\u000e\t;pAQDW\rI*qCJ\\\u0007%\r\u00187A\t,\u0007.\u0019<j_J\u0004#/Z4be\u0012Lgn\u001a\u0011tiJLgn\u001a\u0011mSR,'/\u00197!a\u0006\u00148/\u001b8h]\u00012uN\u001d\u0011fq\u0006l\u0007\u000f\\3-\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u001b4!i\",\u0007eY8oM&<\u0007%[:!K:\f'\r\\3eY\u0001\"\b.\u001a\u0011ae\u0016<W\r\u001f9aAQD\u0017\r\u001e\u0011dC:\u0004S.\u0019;dQ\u0002\u0012C,\u00192dE\u0001J7\u000f\t\u0012_9\u0006\u00147\r\n\u0012/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001JG\r\u001f\u0011.A\u0005t\u0007%\u001b8uK\u001e,'\u000fI3yaJ,7o]5p]\u0002\"\b.\u0019;!e\u0016\u0004(/Z:f]RLgn\u001a\u0011uQ\u0016\u0004sM]8va\u0002Jg\u000eZ3y]\u0001\"\u0006.\u001a\u0011sK\u001e,\u0007\u0010I7bs\u0002\u001awN\u001c;bS:\u001c(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![VdG/\u001b9mK\u0002:'o\\;qg:\u0002\u0003-\u001b3yA\u0002Jg\u000eZ5dCR,7\u000fI<iS\u000eD\u0007E]3hKb\u0004sM]8va\u0002\"x\u000eI3yiJ\f7\r\u001e\u0018!)\",\u0007e\u001a:pkB\u0004\u0013N\u001c3fq\u0002\u001a\bn\\;mI*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t2fA9|g.\f8fO\u0006$\u0018N^3/AQCW\rI7j]&lW/\u001c\u0011wC2,X\rI8gA\u0001LG\r\u001f1!SN\u0004\u0003\u0007\f\u0011xQ&\u001c\u0007\u000eI7fC:\u001c\b%\\1uG\"Lgn\u001a\u0011uQ\u0016\u0004SM\u001c;je\u0016T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>tg\u0006I%gA\u0001LG\r\u001f1!SN\u0004cn\u001c;!gB,7-\u001b4jK\u0012d\u0003\u0005\u001e5fA\u0011,g-Y;mi\u0002:'o\\;qA%tG-\u001a=!m\u0006dW/\u001a\u0011jg\u0002\nd\u0006\t+iK*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t1jIb\u0004\u0007\u0005]1sC6,G/\u001a:!SN\u0004C\u000f[3!\u0015\u00064\u0018\r\t:fO\u0016D\b%T1uG\",'\u000fI4s_V\u0004\b&\u000b\u0011nKRDw\u000e\u001a\u0011j]\u0012,\u0007P\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002\u0010\u0006)'\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00142aAj#\u0007\r\u0019-AM\u0002\u0004'\f\u001b1a\u001db\u0003e\n\u0015]9\u0012\\\u0013&\f\u0015]9\u0012\\\u0013f\n\u0017!c%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u00122aA\u0012CFI\u001a1a\tj&\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005U\u0015!B\u001a/c9\u0002\u0014!B4s_V\u0004\u0018EAAN\u00031\u0019HO]5oO~3WO\\2t\u0003A\u0011VmZ#ya\u0016CHO]1di\u0006cG\u000e\u0005\u000203M!\u0011$a)9!!\t)+a+>{u:UBAAT\u0015\r\tI\u000bN\u0001\beVtG/[7f\u0013\u0011\ti+a*\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0002 \u0006AAo\\*ue&tw\r\u0006\u0002\u00026\u0005)\u0011\r\u001d9msR9q)!/\u0002<\u0006u\u0006\"B\u001e\u001d\u0001\u0004i\u0004\"B!\u001d\u0001\u0004i\u0004\"B\"\u001d\u0001\u0004i\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u0007\fy\rE\u00034\u0003\u000b\fI-C\u0002\u0002HR\u0012aa\u00149uS>t\u0007CB\u001a\u0002LvjT(C\u0002\u0002NR\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CAi;\u0005\u0005\t\u0019A$\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAl!\u0011\t9$!7\n\t\u0005m\u0017\u0011\b\u0002\u0007\u001f\nTWm\u0019;")
public class RegExpExtractAll
extends RegExpExtractBase
implements scala.Serializable {
    private final Expression subject;
    private final Expression regexp;
    private final Expression idx;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(RegExpExtractAll regExpExtractAll) {
        return RegExpExtractAll$.MODULE$.unapply(regExpExtractAll);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, RegExpExtractAll> tupled() {
        return RegExpExtractAll$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, RegExpExtractAll>>> curried() {
        return RegExpExtractAll$.MODULE$.curried();
    }

    @Override
    public Expression subject() {
        return this.subject;
    }

    @Override
    public Expression regexp() {
        return this.regexp;
    }

    @Override
    public Expression idx() {
        return this.idx;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r) {
        Matcher m = this.getLastMatcher(s, p);
        ArrayBuffer matchResults = new ArrayBuffer();
        while (m.find()) {
            MatchResult mr = m.toMatchResult();
            int index = BoxesRunTime.unboxToInt((Object)r);
            RegExpExtractBase$.MODULE$.checkGroupIndex(mr.groupCount(), index);
            String group = mr.group(index);
            ArrayBuffer arrayBuffer = group == null ? matchResults.$plus$eq((Object)UTF8String.EMPTY_UTF8) : matchResults.$plus$eq((Object)UTF8String.fromString((String)group));
        }
        return new GenericArrayData((Object[])matchResults.toArray(ClassTag$.MODULE$.apply(UTF8String.class)));
    }

    @Override
    public DataType dataType() {
        return ArrayType$.MODULE$.apply(StringType$.MODULE$);
    }

    @Override
    public String prettyName() {
        return "regexp_extract_all";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String classNameRegExpExtractBase = RegExpExtractBase.class.getCanonicalName();
        String arrayClass = GenericArrayData.class.getName();
        String matcher = ctx.freshName("matcher");
        String matchResult = ctx.freshName("matchResult");
        String matchResults = ctx.freshName("matchResults");
        String setEvNotNull = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(subject, regexp, idx) -> new StringBuilder(499).append("\n         | ").append(this.initLastMatcherCode(ctx, (String)subject, (String)regexp, matcher)).append("\n         | java.util.ArrayList ").append(matchResults).append(" = new java.util.ArrayList<UTF8String>();\n         | while (").append(matcher).append(".find()) {\n         |   java.util.regex.MatchResult ").append(matchResult).append(" = ").append(matcher).append(".toMatchResult();\n         |   ").append(classNameRegExpExtractBase).append(".checkGroupIndex(").append(matchResult).append(".groupCount(), ").append((String)idx).append(");\n         |   if (").append(matchResult).append(".group(").append((String)idx).append(") == null) {\n         |     ").append(matchResults).append(".add(UTF8String.EMPTY_UTF8);\n         |   } else {\n         |     ").append(matchResults).append(".add(UTF8String.fromString(").append(matchResult).append(".group(").append((String)idx).append(")));\n         |   }\n         | }\n         | ").append(ev.value()).append(" =\n         |   new ").append(arrayClass).append("(").append(matchResults).append(".toArray(new UTF8String[").append(matchResults).append(".size()]));\n         | ").append(setEvNotNull).append("\n         ").toString());
    }

    @Override
    public RegExpExtractAll withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public RegExpExtractAll copy(Expression subject, Expression regexp, Expression idx) {
        return new RegExpExtractAll(subject, regexp, idx);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.idx();
    }

    @Override
    public String productPrefix() {
        return "RegExpExtractAll";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.subject();
                break;
            }
            case 1: {
                expression = this.regexp();
                break;
            }
            case 2: {
                expression = this.idx();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpExtractAll;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpExtractAll)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpExtractAll regExpExtractAll = (RegExpExtractAll)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpExtractAll.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpExtractAll.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.idx();
        Expression expression6 = regExpExtractAll.idx();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!regExpExtractAll.canEqual(this)) return false;
        return true;
    }

    public RegExpExtractAll(Expression subject, Expression regexp, Expression idx) {
        this.subject = subject;
        this.regexp = regexp;
        this.idx = idx;
    }

    public RegExpExtractAll(Expression s, Expression r) {
        this(s, r, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

