/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.CreateStoreFileWriterParams;
import org.apache.hadoop.hbase.regionserver.StoreContext;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
abstract class StoreFileTrackerBase
implements StoreFileTracker {
    private static final Logger LOG = LoggerFactory.getLogger(StoreFileTrackerBase.class);
    protected final Configuration conf;
    protected final boolean isPrimaryReplica;
    protected final StoreContext ctx;
    private volatile boolean cacheOnWriteLogged;

    protected StoreFileTrackerBase(Configuration conf, boolean isPrimaryReplica, StoreContext ctx) {
        this.conf = conf;
        this.isPrimaryReplica = isPrimaryReplica;
        this.ctx = ctx;
    }

    @Override
    public final void add(Collection<StoreFileInfo> newFiles) throws IOException {
        if (this.isPrimaryReplica) {
            this.doAddNewStoreFiles(newFiles);
        }
    }

    @Override
    public final void replace(Collection<StoreFileInfo> compactedFiles, Collection<StoreFileInfo> newFiles) throws IOException {
        if (this.isPrimaryReplica) {
            this.doAddCompactionResults(compactedFiles, newFiles);
        }
    }

    @Override
    public TableDescriptorBuilder updateWithTrackerConfigs(TableDescriptorBuilder builder) {
        builder.setValue("hbase.store.file-tracker.impl", this.getTrackerName());
        return builder;
    }

    protected final String getTrackerName() {
        return StoreFileTrackerFactory.getStoreFileTrackerName(this.getClass());
    }

    private HFileContext createFileContext(Compression.Algorithm compression, boolean includeMVCCReadpoint, boolean includesTag, Encryption.Context encryptionContext) {
        if (compression == null) {
            compression = HFile.DEFAULT_COMPRESSION_ALGORITHM;
        }
        ColumnFamilyDescriptor family = this.ctx.getFamily();
        HFileContext hFileContext = new HFileContextBuilder().withIncludesMvcc(includeMVCCReadpoint).withIncludesTags(includesTag).withCompression(compression).withCompressTags(family.isCompressTags()).withChecksumType(StoreUtils.getChecksumType(this.conf)).withBytesPerCheckSum(StoreUtils.getBytesPerChecksum(this.conf)).withBlockSize(family.getBlocksize()).withHBaseCheckSum(true).withDataBlockEncoding(family.getDataBlockEncoding()).withEncryptionContext(encryptionContext).withCreateTime(EnvironmentEdgeManager.currentTime()).withColumnFamily(family.getName()).withTableName(this.ctx.getTableName().getName()).withCellComparator(this.ctx.getComparator()).withIndexBlockEncoding(family.getIndexBlockEncoding()).build();
        return hFileContext;
    }

    @Override
    public final StoreFileWriter createWriter(CreateStoreFileWriterParams params) throws IOException {
        if (!this.isPrimaryReplica) {
            throw new IllegalStateException("Should not call create writer on secondary replicas");
        }
        CacheConfig cacheConf = this.ctx.getCacheConf();
        CacheConfig writerCacheConf = new CacheConfig(cacheConf);
        long totalCompactedFilesSize = params.totalCompactedFilesSize();
        if (params.isCompaction()) {
            boolean cacheCompactedBlocksOnWrite = cacheConf.shouldCacheCompactedBlocksOnWrite();
            if (cacheCompactedBlocksOnWrite && totalCompactedFilesSize <= cacheConf.getCacheCompactedBlocksOnWriteThreshold()) {
                writerCacheConf.enableCacheOnWrite();
                if (!this.cacheOnWriteLogged) {
                    LOG.info("For {} , cacheCompactedBlocksOnWrite is true, hence enabled cacheOnWrite for Data blocks, Index blocks and Bloom filter blocks", (Object)this);
                    this.cacheOnWriteLogged = true;
                }
            } else {
                writerCacheConf.setCacheDataOnWrite(false);
                if (totalCompactedFilesSize > cacheConf.getCacheCompactedBlocksOnWriteThreshold()) {
                    LOG.debug("For {}, setting cacheCompactedBlocksOnWrite as false as total size of compacted files - {}, is greater than cacheCompactedBlocksOnWriteThreshold - {}", new Object[]{this, totalCompactedFilesSize, cacheConf.getCacheCompactedBlocksOnWriteThreshold()});
                }
            }
        } else {
            boolean shouldCacheDataOnWrite = cacheConf.shouldCacheDataOnWrite();
            if (shouldCacheDataOnWrite) {
                writerCacheConf.enableCacheOnWrite();
                if (!this.cacheOnWriteLogged) {
                    LOG.info("For {} , cacheDataOnWrite is true, hence enabled cacheOnWrite for Index blocks and Bloom filter blocks", (Object)this);
                    this.cacheOnWriteLogged = true;
                }
            }
        }
        Encryption.Context encryptionContext = this.ctx.getEncryptionContext();
        HFileContext hFileContext = this.createFileContext(params.compression(), params.includeMVCCReadpoint(), params.includesTag(), encryptionContext);
        Path outputDir = this.requireWritingToTmpDirFirst() ? new Path(this.ctx.getRegionFileSystem().getTempDir(), this.ctx.getFamily().getNameAsString()) : this.ctx.getFamilyStoreDirectoryPath();
        StoreFileWriter.Builder builder = new StoreFileWriter.Builder(this.conf, writerCacheConf, this.ctx.getRegionFileSystem().getFileSystem()).withOutputDir(outputDir).withBloomType(this.ctx.getBloomFilterType()).withMaxKeyCount(params.maxKeyCount()).withFavoredNodes(this.ctx.getFavoredNodes()).withFileContext(hFileContext).withShouldDropCacheBehind(params.shouldDropBehind()).withCompactedFilesSupplier(this.ctx.getCompactedFilesSupplier()).withFileStoragePolicy(params.fileStoragePolicy()).withWriterCreationTracker(params.writerCreationTracker());
        return builder.build();
    }

    protected abstract void doAddNewStoreFiles(Collection<StoreFileInfo> var1) throws IOException;

    protected abstract void doAddCompactionResults(Collection<StoreFileInfo> var1, Collection<StoreFileInfo> var2) throws IOException;
}

