/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.util.json.JsonCodec;

interface GravitinoHandle<T> {
    public static final String HANDLE_STRING = "handleString";

    public String getHandleString();

    public T getInternalHandle();

    public static <T> T unWrap(T handle) {
        return ((GravitinoHandle)handle).getInternalHandle();
    }

    public static <T> List<T> unWrap(List<T> handles) {
        return handles.stream().map(handle -> ((GravitinoHandle)handle).getInternalHandle()).collect(Collectors.toList());
    }

    public static <T> Map<String, T> unWrap(Map<String, T> handleMap) {
        return handleMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((GravitinoHandle)e.getValue()).getInternalHandle()));
    }

    public static class HandleWrapper<T> {
        private final T handle;
        private String valueString;
        private final Class<T> clazz;

        public HandleWrapper(Class<T> clazz) {
            this.handle = null;
            this.clazz = clazz;
        }

        public HandleWrapper(T handle) {
            this.handle = Objects.requireNonNull(handle, "handle is not null");
            this.clazz = handle.getClass();
        }

        public HandleWrapper<T> fromJson(String valueString) {
            try {
                Object newHandle = JsonCodec.getMapper(this.clazz.getClassLoader()).readerFor(this.clazz).readValue(valueString);
                return new HandleWrapper<Object>(newHandle);
            }
            catch (Exception e) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_ILLEGAL_ARGUMENT, "Can not deserialize from json", (Throwable)e);
            }
        }

        public String toJson() {
            if (this.valueString == null) {
                try {
                    this.valueString = JsonCodec.getMapper(this.clazz.getClassLoader()).writerFor(this.clazz).writeValueAsString(this.handle);
                }
                catch (Exception e) {
                    throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_ILLEGAL_ARGUMENT, "Can not serialize to json", (Throwable)e);
                }
            }
            return this.valueString;
        }

        public T getHandle() {
            return this.handle;
        }
    }
}

