/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.trace.StatusCode;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.SpanStatusBuilder;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpStatusCodeConverter;
import javax.annotation.Nullable;

public final class HttpSpanStatusExtractor<REQUEST, RESPONSE>
implements SpanStatusExtractor<REQUEST, RESPONSE> {
    private final HttpCommonAttributesGetter<? super REQUEST, ? super RESPONSE> getter;
    private final HttpStatusCodeConverter statusCodeConverter;

    public static <REQUEST, RESPONSE> SpanStatusExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<? super REQUEST, ? super RESPONSE> getter) {
        return new HttpSpanStatusExtractor<REQUEST, RESPONSE>(getter, HttpStatusCodeConverter.CLIENT);
    }

    public static <REQUEST, RESPONSE> SpanStatusExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<? super REQUEST, ? super RESPONSE> getter) {
        return new HttpSpanStatusExtractor<REQUEST, RESPONSE>(getter, HttpStatusCodeConverter.SERVER);
    }

    private HttpSpanStatusExtractor(HttpCommonAttributesGetter<? super REQUEST, ? super RESPONSE> getter, HttpStatusCodeConverter statusCodeConverter) {
        this.getter = getter;
        this.statusCodeConverter = statusCodeConverter;
    }

    @Override
    public void extract(SpanStatusBuilder spanStatusBuilder, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        Integer statusCode;
        if (response != null && (statusCode = this.getter.getHttpResponseStatusCode(request, response, error)) != null && this.statusCodeConverter.isError(statusCode)) {
            spanStatusBuilder.setStatus(StatusCode.ERROR);
            return;
        }
        SpanStatusExtractor.getDefault().extract(spanStatusBuilder, request, response, error);
    }
}

