/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.event.job;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.listener.api.event.OperationType;
import org.apache.gravitino.listener.api.event.job.JobPreEvent;
import org.apache.gravitino.utils.NameIdentifierUtil;

@DeveloperApi
public class RunJobPreEvent
extends JobPreEvent {
    private final String jobTemplateName;
    private final Map<String, String> jobConf;

    public RunJobPreEvent(String user, String metalake, String jobTemplateName, Map<String, String> jobConf) {
        super(user, NameIdentifierUtil.ofJobTemplate(metalake, jobTemplateName));
        this.jobTemplateName = jobTemplateName;
        this.jobConf = ImmutableMap.copyOf(jobConf);
    }

    public String jobTemplateName() {
        return this.jobTemplateName;
    }

    public Map<String, String> jobConf() {
        return this.jobConf;
    }

    @Override
    public OperationType operationType() {
        return OperationType.RUN_JOB;
    }
}

