/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type;

import com.googlecode.aviator.Options;
import com.googlecode.aviator.exception.CompareNotSupportedException;
import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.type.AviatorType;
import com.googlecode.aviator.utils.Env;
import com.googlecode.aviator.utils.Reflector;
import com.googlecode.aviator.utils.TypeUtils;
import com.googlecode.aviator.utils.Utils;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AviatorObject
implements Serializable {
    protected Map<Object, Object> metadata = Collections.emptyMap();
    private static final long serialVersionUID = -6006961429175160001L;

    public Map<Object, Object> getMetadata() {
        return this.metadata;
    }

    public AviatorObject withMeta(Object key, Object value) {
        if (this.metadata.isEmpty()) {
            this.metadata = new HashMap<Object, Object>();
        }
        this.metadata.put(key, value);
        return this;
    }

    public Object meta(Object key) {
        return this.metadata.get(key);
    }

    public AviatorObject withoutMeta(Object key) {
        this.metadata.remove(key);
        return this;
    }

    public int compare(AviatorObject other, Map<String, Object> env) {
        return this.compare(other, env, false);
    }

    public int compareEq(AviatorObject other, Map<String, Object> env) {
        return this.compare(other, env, true);
    }

    private int compare(AviatorObject other, Map<String, Object> env, boolean isEq) {
        if (this == other) {
            return 0;
        }
        try {
            return this.innerCompare(other, env);
        }
        catch (CompareNotSupportedException t) {
            if (isEq) {
                if (RuntimeUtils.getInstance(env).getOptionValue((Options)Options.TRACE_EVAL).bool) {
                    t.printStackTrace();
                }
                return 1;
            }
            throw Reflector.sneakyThrow(t);
        }
        catch (Throwable t) {
            throw Reflector.sneakyThrow(t);
        }
    }

    public abstract int innerCompare(AviatorObject var1, Map<String, Object> var2);

    public abstract AviatorType getAviatorType();

    public String toString() {
        return this.desc(Env.EMPTY_ENV);
    }

    public boolean isNull(Map<String, Object> env) {
        return this.getValue(env) == null;
    }

    public AviatorObject match(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException(this.desc(env) + " doesn't support match operation '=~'");
    }

    public AviatorObject neg(Map<String, Object> env) {
        throw new ExpressionRuntimeException(this.desc(env) + " doesn't support negative operation '-'");
    }

    public AviatorObject setValue(AviatorObject value, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Can't assign value " + value.desc(env) + " to " + this.desc(env));
    }

    public AviatorObject defineValue(AviatorObject value, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Can't assign value " + value.desc(env) + " to " + this.desc(env));
    }

    public AviatorObject not(Map<String, Object> env) {
        throw new ExpressionRuntimeException(this.desc(env) + " doesn't support not operation '!'");
    }

    public String desc(Map<String, Object> env) {
        Object val = this.getValue(env);
        if (val != this) {
            return "<" + this.getAviatorType() + ", " + val + ">";
        }
        return "<" + this.getAviatorType() + ", this>";
    }

    public abstract Object getValue(Map<String, Object> var1);

    public AviatorObject add(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not add " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject bitAnd(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not bitAnd " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject bitOr(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not bitOr " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject bitXor(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not bitXor " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject shiftRight(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not shiftRight " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject shiftLeft(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not shiftLeft " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject unsignedShiftRight(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not unsignedShiftRight " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject bitNot(Map<String, Object> env) {
        throw new ExpressionRuntimeException(this.desc(env) + " doesn't support not operation '^'");
    }

    public AviatorObject sub(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not sub " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject mod(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not mod " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject div(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not div " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject mult(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not mult " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject exponent(AviatorObject other, Map<String, Object> env) {
        Object base = this.getValue(env);
        Object exp = other.getValue(env);
        if (!(base instanceof Number) || !(exp instanceof Number)) {
            throw new ExpressionRuntimeException("Could not exponent " + this.desc(env) + " with " + other.desc(env));
        }
        return Utils.exponent((Number)base, (Number)exp, env);
    }

    public Number numberValue(Map<String, Object> env) {
        if (!(this.getValue(env) instanceof Number)) {
            throw new ExpressionRuntimeException(this.desc(env) + " is not a number value");
        }
        return (Number)this.getValue(env);
    }

    public String stringValue(Map<String, Object> env) {
        Object value = this.getValue(env);
        if (!TypeUtils.isString(value)) {
            throw new ExpressionRuntimeException(this.desc(env) + " is not a string value");
        }
        return String.valueOf(value);
    }

    public boolean booleanValue(Map<String, Object> env) {
        Object val = this.getValue(env);
        if (!(val instanceof Boolean)) {
            throw new ExpressionRuntimeException(this.desc(env) + " is not a boolean value");
        }
        return (Boolean)val;
    }

    public AviatorObject deref(Map<String, Object> env) {
        return this;
    }

    public AviatorObject getElement(Map<String, Object> env, AviatorObject indexObject) {
        throw new ExpressionRuntimeException(this.desc(env) + " is not a array");
    }
}

