/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.s3.credential;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.credential.CredentialContext;
import org.apache.gravitino.credential.CredentialGenerator;
import org.apache.gravitino.credential.PathBasedCredentialContext;
import org.apache.gravitino.credential.S3TokenCredential;
import org.apache.gravitino.credential.config.S3CredentialConfig;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.policybuilder.iam.IamConditionOperator;
import software.amazon.awssdk.policybuilder.iam.IamEffect;
import software.amazon.awssdk.policybuilder.iam.IamPolicy;
import software.amazon.awssdk.policybuilder.iam.IamResource;
import software.amazon.awssdk.policybuilder.iam.IamStatement;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.services.sts.model.Credentials;

public class S3TokenGenerator
implements CredentialGenerator<S3TokenCredential> {
    private StsClient stsClient;
    private String roleArn;
    private String externalID;
    private int tokenExpireSecs;

    public void initialize(Map<String, String> properties) {
        S3CredentialConfig s3CredentialConfig = new S3CredentialConfig(properties);
        this.roleArn = s3CredentialConfig.s3RoleArn();
        this.externalID = s3CredentialConfig.externalID();
        this.tokenExpireSecs = s3CredentialConfig.tokenExpireInSecs();
        this.stsClient = this.createStsClient(s3CredentialConfig);
    }

    public S3TokenCredential generate(CredentialContext context) {
        if (!(context instanceof PathBasedCredentialContext)) {
            return null;
        }
        PathBasedCredentialContext pathContext = (PathBasedCredentialContext)context;
        Credentials s3Token = this.createS3Token(pathContext.getReadPaths(), pathContext.getWritePaths(), pathContext.getUserName());
        return new S3TokenCredential(s3Token.accessKeyId(), s3Token.secretAccessKey(), s3Token.sessionToken(), s3Token.expiration().toEpochMilli());
    }

    private StsClient createStsClient(S3CredentialConfig s3CredentialConfig) {
        StaticCredentialsProvider credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)s3CredentialConfig.accessKeyID(), (String)s3CredentialConfig.secretAccessKey()));
        StsClientBuilder builder = (StsClientBuilder)StsClient.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider);
        if (StringUtils.isNotBlank((CharSequence)s3CredentialConfig.region())) {
            builder.region(Region.of((String)s3CredentialConfig.region()));
        }
        if (StringUtils.isNotBlank((CharSequence)s3CredentialConfig.stsEndpoint())) {
            builder.endpointOverride(URI.create(s3CredentialConfig.stsEndpoint()));
        }
        return (StsClient)builder.build();
    }

    private Credentials createS3Token(Set<String> readLocations, Set<String> writeLocations, String userName) {
        IamPolicy policy = this.createPolicy(this.roleArn, readLocations, writeLocations);
        AssumeRoleRequest.Builder builder = AssumeRoleRequest.builder().roleArn(this.roleArn).roleSessionName("gravitino_" + userName).durationSeconds(Integer.valueOf(this.tokenExpireSecs)).policy(policy.toJson());
        if (StringUtils.isNotBlank((CharSequence)this.externalID)) {
            builder.externalId(this.externalID);
        }
        AssumeRoleResponse response = this.stsClient.assumeRole((AssumeRoleRequest)builder.build());
        return response.credentials();
    }

    private IamPolicy createPolicy(String roleArn, Set<String> readLocations, Set<String> writeLocations) {
        IamPolicy.Builder policyBuilder = IamPolicy.builder();
        IamStatement.Builder allowGetObjectStatementBuilder = IamStatement.builder().effect(IamEffect.ALLOW).addAction("s3:GetObject").addAction("s3:GetObjectVersion");
        HashMap bucketListStatementBuilder = new HashMap();
        HashMap bucketGetLocationStatementBuilder = new HashMap();
        String arnPrefix = this.getArnPrefix(roleArn);
        Stream.concat(readLocations.stream(), writeLocations.stream()).distinct().forEach(location -> {
            URI uri = URI.create(location);
            allowGetObjectStatementBuilder.addResource(IamResource.create((String)this.getS3UriWithArn(arnPrefix, uri)));
            String bucketArn = arnPrefix + S3TokenGenerator.getBucketName(uri);
            String rawPath = S3TokenGenerator.trimLeadingSlash(uri.getPath());
            bucketListStatementBuilder.computeIfAbsent(bucketArn, key -> IamStatement.builder().effect(IamEffect.ALLOW).addAction("s3:ListBucket").addResource(key)).addConditions(IamConditionOperator.STRING_LIKE, "s3:prefix", Arrays.asList(rawPath, S3TokenGenerator.addWildcardToPath(rawPath)));
            bucketGetLocationStatementBuilder.computeIfAbsent(bucketArn, key -> IamStatement.builder().effect(IamEffect.ALLOW).addAction("s3:GetBucketLocation").addResource(key));
        });
        if (!writeLocations.isEmpty()) {
            IamStatement.Builder allowPutObjectStatementBuilder = IamStatement.builder().effect(IamEffect.ALLOW).addAction("s3:PutObject").addAction("s3:DeleteObject");
            writeLocations.forEach(location -> {
                URI uri = URI.create(location);
                allowPutObjectStatementBuilder.addResource(IamResource.create((String)this.getS3UriWithArn(arnPrefix, uri)));
            });
            policyBuilder.addStatement((IamStatement)allowPutObjectStatementBuilder.build());
        }
        bucketListStatementBuilder.values().forEach(builder -> policyBuilder.addStatement((IamStatement)builder.build()));
        bucketGetLocationStatementBuilder.values().forEach(builder -> policyBuilder.addStatement((IamStatement)builder.build()));
        policyBuilder.addStatement((IamStatement)allowGetObjectStatementBuilder.build());
        return (IamPolicy)policyBuilder.build();
    }

    private String getS3UriWithArn(String arnPrefix, URI uri) {
        return arnPrefix + S3TokenGenerator.addWildcardToPath(S3TokenGenerator.removeSchemaFromS3Uri(uri));
    }

    private String getArnPrefix(String roleArn) {
        if (roleArn.contains("aws-cn")) {
            return "arn:aws-cn:s3:::";
        }
        if (roleArn.contains("aws-us-gov")) {
            return "arn:aws-us-gov:s3:::";
        }
        return "arn:aws:s3:::";
    }

    private static String addWildcardToPath(String path) {
        return path.endsWith("/") ? path + "*" : path + "/*";
    }

    private static String removeSchemaFromS3Uri(URI uri) {
        String bucket = uri.getHost();
        String path = S3TokenGenerator.trimLeadingSlash(uri.getPath());
        return String.join((CharSequence)"/", (CharSequence[])Stream.of(bucket, path).filter(Objects::nonNull).toArray(String[]::new));
    }

    private static String trimLeadingSlash(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    private static String getBucketName(URI uri) {
        return uri.getHost();
    }

    public void close() throws IOException {
        if (this.stsClient != null) {
            this.stsClient.close();
        }
    }
}

