/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Entity;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.iceberg.service.IcebergExceptionMapper;
import org.apache.gravitino.iceberg.service.IcebergObjectMapper;
import org.apache.gravitino.iceberg.service.IcebergRESTUtils;
import org.apache.gravitino.iceberg.service.authorization.IcebergRESTServerContext;
import org.apache.gravitino.iceberg.service.dispatcher.IcebergTableOperationDispatcher;
import org.apache.gravitino.iceberg.service.metrics.IcebergMetricsManager;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.gravitino.server.authorization.MetadataAuthzHelper;
import org.apache.gravitino.server.authorization.annotations.AuthorizationExpression;
import org.apache.gravitino.server.authorization.annotations.AuthorizationMetadata;
import org.apache.gravitino.server.authorization.annotations.IcebergAuthorizationMetadata;
import org.apache.gravitino.server.web.Utils;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.PlanTableScanRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadCredentialsResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.PlanTableScanResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/{prefix:([^/]*/)?}namespaces/{namespace}/tables")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IcebergTableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergTableOperations.class);
    @VisibleForTesting
    public static final String X_ICEBERG_ACCESS_DELEGATION = "X-Iceberg-Access-Delegation";
    private IcebergMetricsManager icebergMetricsManager;
    private ObjectMapper icebergObjectMapper;
    private IcebergTableOperationDispatcher tableOperationDispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public IcebergTableOperations(IcebergMetricsManager icebergMetricsManager, IcebergTableOperationDispatcher tableOperationDispatcher) {
        this.icebergMetricsManager = icebergMetricsManager;
        this.tableOperationDispatcher = tableOperationDispatcher;
        this.icebergObjectMapper = IcebergObjectMapper.getInstance();
    }

    @GET
    @Produces(value={"application/json"})
    @Timed(name="list-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-table", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\nANY_USE_CATALOG && (SCHEMA::OWNER || ANY_USE_SCHEMA)\n", accessMetadataType=MetadataObject.Type.SCHEMA)
    public Response listTable(@AuthorizationMetadata(type=Entity.EntityType.CATALOG) @PathParam(value="prefix") String prefix, @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) @Encoded @PathParam(value="namespace") String namespace) {
        String catalogName = IcebergRESTUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("List Iceberg tables, catalog: {}, namespace: {}", (Object)catalogName, (Object)icebergNS);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                ListTablesResponse listTablesResponse = this.tableOperationDispatcher.listTable(context, icebergNS);
                IcebergRESTServerContext authContext = IcebergRESTServerContext.getInstance();
                if (authContext.isAuthorizationEnabled()) {
                    listTablesResponse = this.filterListTablesResponse(listTablesResponse, authContext.metalakeName(), catalogName);
                }
                return IcebergRESTUtils.ok(listTablesResponse);
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Timed(name="create-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-table", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG || ANY_USE_CATALOG && ANY_USE_SCHEMA && ANY_CREATE_TABLE", accessMetadataType=MetadataObject.Type.SCHEMA)
    public Response createTable(@AuthorizationMetadata(type=Entity.EntityType.CATALOG) @PathParam(value="prefix") String prefix, @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) @Encoded @PathParam(value="namespace") String namespace, CreateTableRequest createTableRequest, @HeaderParam(value="X-Iceberg-Access-Delegation") String accessDelegation) {
        boolean isCredentialVending = this.isCredentialVending(accessDelegation);
        String catalogName = IcebergRESTUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Create Iceberg table, catalog: {}, namespace: {}, create table request: {}, accessDelegation: {}, isCredentialVending: {}", new Object[]{catalogName, icebergNS, createTableRequest, accessDelegation, isCredentialVending});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName, isCredentialVending);
                LoadTableResponse loadTableResponse = this.tableOperationDispatcher.createTable(context, icebergNS, createTableRequest);
                return IcebergRESTUtils.ok(loadTableResponse);
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @POST
    @Path(value="{table}")
    @Produces(value={"application/json"})
    @Timed(name="update-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="update-table", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG || ANY_USE_CATALOG && ANY_USE_SCHEMA  && (TABLE::OWNER || ANY_MODIFY_TABLE)", accessMetadataType=MetadataObject.Type.TABLE)
    public Response updateTable(@AuthorizationMetadata(type=Entity.EntityType.CATALOG) @PathParam(value="prefix") String prefix, @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) @Encoded @PathParam(value="namespace") String namespace, @AuthorizationMetadata(type=Entity.EntityType.TABLE) @PathParam(value="table") String table, UpdateTableRequest updateTableRequest) {
        String catalogName = IcebergRESTUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        if (LOG.isInfoEnabled()) {
            LOG.info("Update Iceberg table, catalog: {}, namespace: {}, table: {}, updateTableRequest: {}", new Object[]{catalogName, icebergNS, table, this.SerializeUpdateTableRequest(updateTableRequest)});
        }
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)icebergNS, (String)table);
                LoadTableResponse loadTableResponse = this.tableOperationDispatcher.updateTable(context, tableIdentifier, updateTableRequest);
                return IcebergRESTUtils.ok(loadTableResponse);
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @DELETE
    @Path(value="{table}")
    @Produces(value={"application/json"})
    @Timed(name="drop-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-table", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG || ANY_USE_CATALOG && ANY_USE_SCHEMA  && TABLE::OWNER ", accessMetadataType=MetadataObject.Type.TABLE)
    public Response dropTable(@AuthorizationMetadata(type=Entity.EntityType.CATALOG) @PathParam(value="prefix") String prefix, @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) @Encoded @PathParam(value="namespace") String namespace, @AuthorizationMetadata(type=Entity.EntityType.TABLE) @PathParam(value="table") String table, @DefaultValue(value="false") @QueryParam(value="purgeRequested") boolean purgeRequested) {
        String catalogName = IcebergRESTUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Drop Iceberg table, catalog: {}, namespace: {}, table: {}, purgeRequested: {}", new Object[]{catalogName, icebergNS, table, purgeRequested});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)icebergNS, (String)table);
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                this.tableOperationDispatcher.dropTable(context, tableIdentifier, purgeRequested);
                return IcebergRESTUtils.noContent();
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @GET
    @Path(value="{table}")
    @Produces(value={"application/json"})
    @Timed(name="load-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="load-table", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG || ANY_USE_CATALOG && ANY_USE_SCHEMA  && (TABLE::OWNER || ANY_SELECT_TABLE|| ANY_MODIFY_TABLE || ANY_CREATE_TABLE)", accessMetadataType=MetadataObject.Type.TABLE)
    public Response loadTable(@AuthorizationMetadata(type=Entity.EntityType.CATALOG) @PathParam(value="prefix") String prefix, @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) @Encoded @PathParam(value="namespace") String namespace, @IcebergAuthorizationMetadata(type=IcebergAuthorizationMetadata.RequestType.LOAD_TABLE) @PathParam(value="table") String table, @DefaultValue(value="all") @QueryParam(value="snapshots") String snapshots, @HeaderParam(value="X-Iceberg-Access-Delegation") String accessDelegation) {
        String catalogName = IcebergRESTUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        boolean isCredentialVending = this.isCredentialVending(accessDelegation);
        LOG.info("Load Iceberg table, catalog: {}, namespace: {}, table: {}, access delegation: {}, credential vending: {}", new Object[]{catalogName, icebergNS, table, accessDelegation, isCredentialVending});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)icebergNS, (String)table);
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName, isCredentialVending);
                LoadTableResponse loadTableResponse = this.tableOperationDispatcher.loadTable(context, tableIdentifier);
                return IcebergRESTUtils.ok(loadTableResponse);
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @HEAD
    @Path(value="{table}")
    @Produces(value={"application/json"})
    @Timed(name="table-exists.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="table-exists", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG || ANY_USE_CATALOG && ANY_USE_SCHEMA  && (TABLE::OWNER || ANY_SELECT_TABLE || ANY_MODIFY_TABLE || ANY_CREATE_TABLE)", accessMetadataType=MetadataObject.Type.TABLE)
    public Response tableExists(@AuthorizationMetadata(type=Entity.EntityType.CATALOG) @PathParam(value="prefix") String prefix, @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) @Encoded @PathParam(value="namespace") String namespace, @AuthorizationMetadata(type=Entity.EntityType.TABLE) @PathParam(value="table") String table) {
        String catalogName = IcebergRESTUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Check Iceberg table exists, catalog: {}, namespace: {}, table: {}", new Object[]{catalogName, icebergNS, table});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                TableIdentifier tableIdentifier;
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                boolean exists = this.tableOperationDispatcher.tableExists(context, tableIdentifier = TableIdentifier.of((Namespace)icebergNS, (String)table));
                if (exists) {
                    return IcebergRESTUtils.noContent();
                }
                return IcebergRESTUtils.notExists();
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @POST
    @Path(value="{table}/metrics")
    @Produces(value={"application/json"})
    @Timed(name="report-table-metrics.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="report-table-metrics", absolute=true)
    public Response reportTableMetrics(@PathParam(value="prefix") String prefix, @Encoded @PathParam(value="namespace") String namespace, @PathParam(value="table") String table, ReportMetricsRequest request) {
        String catalogName = IcebergRESTUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Report Iceberg table metrics, catalog: {}, namespace: {}, table: {}", new Object[]{catalogName, icebergNS, table});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                boolean accepted = this.icebergMetricsManager.recordMetric(catalogName, icebergNS, request.report());
                if (accepted) {
                    return IcebergRESTUtils.noContent();
                }
                return IcebergRESTUtils.errorResponse(new RuntimeException("Metrics service unavailable: queue full or service closed"), Response.Status.SERVICE_UNAVAILABLE.getStatusCode());
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @VisibleForTesting
    HttpServletRequest httpServletRequest() {
        return this.httpRequest;
    }

    private String SerializeUpdateTableRequest(UpdateTableRequest updateTableRequest) {
        try {
            return this.icebergObjectMapper.writeValueAsString((Object)updateTableRequest);
        }
        catch (JsonProcessingException e) {
            LOG.warn("Serialize update table request failed", (Throwable)e);
            return updateTableRequest.toString();
        }
    }

    @GET
    @Path(value="{table}/credentials")
    @Produces(value={"application/json"})
    @Timed(name="get-table-credentials.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-table-credentials", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG || ANY_USE_CATALOG && ANY_USE_SCHEMA  && (TABLE::OWNER || ANY_SELECT_TABLE || ANY_MODIFY_TABLE)", accessMetadataType=MetadataObject.Type.TABLE)
    public Response getTableCredentials(@AuthorizationMetadata(type=Entity.EntityType.CATALOG) @PathParam(value="prefix") String prefix, @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) @Encoded @PathParam(value="namespace") String namespace, @AuthorizationMetadata(type=Entity.EntityType.TABLE) @PathParam(value="table") String table) {
        String catalogName = IcebergRESTUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Get Iceberg table credentials, catalog: {}, namespace: {}, table: {}", new Object[]{catalogName, icebergNS, table});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)icebergNS, (String)table);
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                LoadCredentialsResponse credentialsResponse = this.tableOperationDispatcher.getTableCredentials(context, tableIdentifier);
                return IcebergRESTUtils.ok(credentialsResponse);
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @POST
    @Path(value="{table}/scan")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Timed(name="plan-table-scan.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="plan-table-scan", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG || ANY_USE_CATALOG && ANY_USE_SCHEMA  && (TABLE::OWNER || ANY_SELECT_TABLE|| ANY_MODIFY_TABLE)", accessMetadataType=MetadataObject.Type.TABLE)
    public Response planTableScan(@PathParam(value="prefix") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String prefix, @Encoded @PathParam(value="namespace") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String namespace, @PathParam(value="table") @AuthorizationMetadata(type=Entity.EntityType.TABLE) String table, PlanTableScanRequest scanRequest) {
        String catalogName = IcebergRESTUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Plan table scan, catalog: {}, namespace: {}, table: {}", new Object[]{catalogName, icebergNS, table});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)icebergNS, (String)table);
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                PlanTableScanResponse scanResponse = this.tableOperationDispatcher.planTableScan(context, tableIdentifier, scanRequest);
                return IcebergRESTUtils.ok(scanResponse);
            });
        }
        catch (Exception e) {
            LOG.error("Failed to plan table scan: {}", (Object)e.getMessage(), (Object)e);
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    private boolean isCredentialVending(String accessDelegation) {
        if (StringUtils.isBlank((CharSequence)accessDelegation)) {
            return false;
        }
        if ("vended-credentials".equalsIgnoreCase(accessDelegation)) {
            return true;
        }
        if ("remote-signing".equalsIgnoreCase(accessDelegation)) {
            throw new UnsupportedOperationException("Gravitino IcebergRESTServer doesn't support remote signing");
        }
        throw new IllegalArgumentException("X-Iceberg-Access-Delegation: " + accessDelegation + " is illegal, Iceberg REST spec supports: [vended-credentials,remote-signing], Gravitino Iceberg REST server supports: vended-credentials");
    }

    private NameIdentifier[] toNameIdentifiers(ListTablesResponse listTablesResponse, String metalake, String catalogName) {
        List identifiers = listTablesResponse.identifiers();
        NameIdentifier[] nameIdentifiers = new NameIdentifier[identifiers.size()];
        for (int i = 0; i < identifiers.size(); ++i) {
            TableIdentifier identifier = (TableIdentifier)identifiers.get(i);
            nameIdentifiers[i] = NameIdentifier.of((String[])new String[]{metalake, catalogName, identifier.namespace().level(0), identifier.name()});
        }
        return nameIdentifiers;
    }

    private ListTablesResponse filterListTablesResponse(ListTablesResponse listTablesResponse, String metalake, String catalogName) {
        NameIdentifier[] idents = MetadataAuthzHelper.filterByExpression((String)metalake, (String)"ANY(OWNER, METALAKE, CATALOG, SCHEMA, TABLE) ||\nANY_SELECT_TABLE ||\nANY_MODIFY_TABLE\n", (Entity.EntityType)Entity.EntityType.TABLE, (NameIdentifier[])this.toNameIdentifiers(listTablesResponse, metalake, catalogName));
        ArrayList<TableIdentifier> filteredIdentifiers = new ArrayList<TableIdentifier>();
        for (NameIdentifier ident : idents) {
            filteredIdentifiers.add(TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{ident.namespace().level(0)}), (String)ident.name()));
        }
        return ListTablesResponse.builder().addAll(filteredIdentifiers).nextPageToken(listTablesResponse.nextPageToken()).build();
    }
}

