/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.dispatcher;

import java.io.IOException;
import java.time.Instant;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.catalog.TableDispatcher;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.iceberg.common.utils.IcebergIdentifierUtils;
import org.apache.gravitino.iceberg.service.authorization.IcebergRESTServerContext;
import org.apache.gravitino.iceberg.service.dispatcher.IcebergOwnershipUtils;
import org.apache.gravitino.iceberg.service.dispatcher.IcebergTableOperationDispatcher;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.TableEntity;
import org.apache.gravitino.utils.PrincipalUtils;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.PlanTableScanRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadCredentialsResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.PlanTableScanResponse;

public class IcebergTableHookDispatcher
implements IcebergTableOperationDispatcher {
    private final IcebergTableOperationDispatcher dispatcher;
    private String metalake;

    public IcebergTableHookDispatcher(IcebergTableOperationDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.metalake = IcebergRESTServerContext.getInstance().metalakeName();
    }

    @Override
    public LoadTableResponse createTable(IcebergRequestContext context, Namespace namespace, CreateTableRequest createTableRequest) {
        LoadTableResponse response = this.dispatcher.createTable(context, namespace, createTableRequest);
        this.importTable(context.catalogName(), namespace, createTableRequest.name());
        IcebergOwnershipUtils.setTableOwner(this.metalake, context.catalogName(), namespace, createTableRequest.name(), context.userName(), GravitinoEnv.getInstance().ownerDispatcher());
        return response;
    }

    @Override
    public LoadTableResponse updateTable(IcebergRequestContext context, TableIdentifier tableIdentifier, UpdateTableRequest updateTableRequest) {
        return this.dispatcher.updateTable(context, tableIdentifier, updateTableRequest);
    }

    @Override
    public void dropTable(IcebergRequestContext context, TableIdentifier tableIdentifier, boolean purgeRequested) {
        this.dispatcher.dropTable(context, tableIdentifier, purgeRequested);
        EntityStore store = GravitinoEnv.getInstance().entityStore();
        try {
            if (store != null) {
                store.delete(IcebergIdentifierUtils.toGravitinoTableIdentifier((String)this.metalake, (String)context.catalogName(), (TableIdentifier)tableIdentifier), Entity.EntityType.TABLE);
            }
        }
        catch (NoSuchEntityException noSuchEntityException) {
        }
        catch (IOException ioe) {
            throw new RuntimeException("io exception when deleting table entity", ioe);
        }
    }

    @Override
    public LoadTableResponse loadTable(IcebergRequestContext context, TableIdentifier tableIdentifier) {
        return this.dispatcher.loadTable(context, tableIdentifier);
    }

    @Override
    public ListTablesResponse listTable(IcebergRequestContext context, Namespace namespace) {
        return this.dispatcher.listTable(context, namespace);
    }

    @Override
    public boolean tableExists(IcebergRequestContext context, TableIdentifier tableIdentifier) {
        return this.dispatcher.tableExists(context, tableIdentifier);
    }

    @Override
    public void renameTable(IcebergRequestContext context, RenameTableRequest renameTableRequest) {
        this.dispatcher.renameTable(context, renameTableRequest);
        NameIdentifier tableSource = IcebergIdentifierUtils.toGravitinoTableIdentifier((String)this.metalake, (String)context.catalogName(), (TableIdentifier)renameTableRequest.source());
        NameIdentifier tableDest = IcebergIdentifierUtils.toGravitinoTableIdentifier((String)this.metalake, (String)context.catalogName(), (TableIdentifier)renameTableRequest.destination());
        EntityStore store = GravitinoEnv.getInstance().entityStore();
        try {
            if (store != null) {
                store.update(tableSource, TableEntity.class, Entity.EntityType.TABLE, tableEntity -> TableEntity.builder().withId(tableEntity.id()).withName(tableDest.name()).withNamespace(tableDest.namespace()).withColumns(tableEntity.columns()).withAuditInfo(AuditInfo.builder().withCreator(tableEntity.auditInfo().creator()).withCreateTime(tableEntity.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build()).build());
            }
        }
        catch (NoSuchEntityException noSuchEntityException) {
        }
        catch (IOException ioe) {
            throw new RuntimeException("io exception when renaming table entity", ioe);
        }
    }

    @Override
    public LoadCredentialsResponse getTableCredentials(IcebergRequestContext context, TableIdentifier tableIdentifier) {
        return this.dispatcher.getTableCredentials(context, tableIdentifier);
    }

    @Override
    public PlanTableScanResponse planTableScan(IcebergRequestContext context, TableIdentifier tableIdentifier, PlanTableScanRequest scanRequest) {
        return this.dispatcher.planTableScan(context, tableIdentifier, scanRequest);
    }

    private void importTable(String catalogName, Namespace namespace, String tableName) {
        TableDispatcher tableDispatcher = GravitinoEnv.getInstance().tableDispatcher();
        if (tableDispatcher != null) {
            tableDispatcher.loadTable(IcebergIdentifierUtils.toGravitinoTableIdentifier((String)this.metalake, (String)catalogName, (TableIdentifier)TableIdentifier.of((Namespace)namespace, (String)tableName)));
        }
    }
}

