/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.iceberg.service.IcebergObjectMapper;
import org.apache.gravitino.iceberg.service.authorization.IcebergRESTServerContext;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.responses.ErrorResponse;

public class IcebergRESTUtils {
    private IcebergRESTUtils() {
    }

    public static <T> Response ok(T t) {
        return Response.status((Response.Status)Response.Status.OK).entity(t).type("application/json").build();
    }

    public static Response okWithoutContent() {
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    public static Response noContent() {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public static Response notExists() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    public static Response errorResponse(Throwable ex, int httpStatus) {
        ErrorResponse errorResponse = ErrorResponse.builder().responseCode(Integer.valueOf(httpStatus)).withType(ex.getClass().getSimpleName()).withMessage(ex.getMessage()).withStackTrace(ex).build();
        return Response.status((int)httpStatus).entity((Object)errorResponse).type("application/json").build();
    }

    public static Instant calculateNewTimestamp(Instant currentTimestamp, int hours) {
        LocalDateTime currentDateTime = LocalDateTime.ofInstant(currentTimestamp, ZoneId.systemDefault());
        LocalDateTime nextHourDateTime = hours > 0 ? currentDateTime.plusHours(hours) : currentDateTime.minusHours(-hours);
        return nextHourDateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    public static NameIdentifier getGravitinoNameIdentifier(String metalakeName, String catalogName, TableIdentifier icebergIdentifier) {
        Stream<String> catalogNS = Stream.concat(Stream.of(metalakeName, catalogName), Arrays.stream(icebergIdentifier.namespace().levels()));
        String[] catalogNSTable = (String[])Stream.concat(catalogNS, Stream.of(icebergIdentifier.name())).toArray(String[]::new);
        return NameIdentifier.of((String[])catalogNSTable);
    }

    public static String getCatalogName(String rawPrefix) {
        String catalogName = IcebergRESTUtils.normalizePrefix(rawPrefix);
        if (StringUtils.isBlank((CharSequence)catalogName)) {
            return IcebergRESTServerContext.getInstance().defaultCatalogName();
        }
        return catalogName;
    }

    public static <T> T cloneIcebergRESTObject(Object message, Class<T> className) {
        ObjectMapper icebergObjectMapper = IcebergObjectMapper.getInstance();
        try {
            byte[] values = icebergObjectMapper.writeValueAsBytes(message);
            return (T)icebergObjectMapper.readValue(values, className);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static NameIdentifier getGravitinoNameIdentifier(String metalakeName, String catalogName, Namespace namespace) {
        Stream<String> catalogNS = Stream.concat(Stream.of(metalakeName, catalogName), Arrays.stream(namespace.levels()));
        return NameIdentifier.of((String[])((String[])catalogNS.toArray(String[]::new)));
    }

    public static Map<String, String> getHttpHeaders(HttpServletRequest httpServletRequest) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = httpServletRequest.getHeader(headerName);
            if (headerValue == null) continue;
            headers.put(headerName, headerValue);
        }
        return headers;
    }

    private static String normalizePrefix(String rawPrefix) {
        if (StringUtils.isBlank((CharSequence)rawPrefix)) {
            return rawPrefix;
        }
        Preconditions.checkArgument((boolean)rawPrefix.endsWith("/"), (Object)String.format("rawPrefix %s format is illegal", rawPrefix));
        return rawPrefix.substring(0, rawPrefix.length() - 1);
    }
}

