/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.credential.CatalogCredentialManager;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.CredentialContext;
import org.apache.gravitino.credential.CredentialPrivilege;
import org.apache.gravitino.credential.CredentialPropertyUtils;
import org.apache.gravitino.credential.PathBasedCredentialContext;
import org.apache.gravitino.iceberg.common.IcebergConfig;
import org.apache.gravitino.iceberg.common.ops.IcebergCatalogWrapper;
import org.apache.gravitino.utils.MapUtils;
import org.apache.gravitino.utils.PrincipalUtils;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.IncrementalAppendScan;
import org.apache.iceberg.Scan;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.ServiceUnavailableException;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.PlanTableScanRequest;
import org.apache.iceberg.rest.responses.ImmutableLoadCredentialsResponse;
import org.apache.iceberg.rest.responses.LoadCredentialsResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.PlanTableScanResponse;

public class CatalogWrapperForREST
extends IcebergCatalogWrapper {
    private final CatalogCredentialManager catalogCredentialManager;
    private final Map<String, String> catalogConfigToClients;
    private static final Set<String> catalogPropertiesToClientKeys = ImmutableSet.of((Object)"io-impl", (Object)"client.region", (Object)"s3.endpoint", (Object)"oss.endpoint", (Object)"s3.path-style-access");
    private static Map<String, String> deprecatedProperties = ImmutableMap.of((Object)"credential-provider-type", (Object)"credential-providers", (Object)"gcs-credential-file-path", (Object)"gcs-service-account-file");

    public CatalogWrapperForREST(String catalogName, IcebergConfig config) {
        super(config);
        this.catalogConfigToClients = MapUtils.getFilteredMap((Map)config.getIcebergCatalogProperties(), key -> catalogPropertiesToClientKeys.contains(key));
        Map<String, String> catalogProperties = CatalogWrapperForREST.checkForCompatibility(config.getAllConfig(), deprecatedProperties);
        this.catalogCredentialManager = new CatalogCredentialManager(catalogName, catalogProperties);
    }

    public LoadTableResponse createTable(Namespace namespace, CreateTableRequest request, boolean requestCredential) {
        LoadTableResponse loadTableResponse = super.createTable(namespace, request);
        if (requestCredential) {
            return this.injectCredentialConfig(TableIdentifier.of((Namespace)namespace, (String)request.name()), loadTableResponse, CredentialPrivilege.WRITE);
        }
        return loadTableResponse;
    }

    public LoadTableResponse loadTable(TableIdentifier identifier, boolean requestCredential, CredentialPrivilege privilege) {
        LoadTableResponse loadTableResponse = super.loadTable(identifier);
        if (requestCredential) {
            return this.injectCredentialConfig(identifier, loadTableResponse, privilege);
        }
        return loadTableResponse;
    }

    public LoadCredentialsResponse getTableCredentials(TableIdentifier identifier, CredentialPrivilege privilege) {
        try {
            LoadTableResponse loadTableResponse = super.loadTable(identifier);
            final Credential credential = this.getCredential(loadTableResponse, privilege);
            org.apache.iceberg.rest.credentials.Credential icebergCredential = new org.apache.iceberg.rest.credentials.Credential(){

                public String prefix() {
                    return "";
                }

                public Map<String, String> config() {
                    return CredentialPropertyUtils.toIcebergProperties((Credential)credential);
                }

                public void validate() {
                }
            };
            return ImmutableLoadCredentialsResponse.builder().addCredentials(icebergCredential).build();
        }
        catch (ServiceUnavailableException e) {
            LOG.warn("Service unavailable when loading table credentials for table: {}", (Object)identifier, (Object)e);
            return ImmutableLoadCredentialsResponse.builder().build();
        }
    }

    public void close() throws Exception {
        try {
            if (this.catalogCredentialManager != null) {
                this.catalogCredentialManager.close();
            }
        }
        finally {
            super.close();
        }
    }

    public Map<String, String> getCatalogConfigToClient() {
        return this.catalogConfigToClients;
    }

    protected boolean useDifferentClassLoader() {
        return false;
    }

    private LoadTableResponse injectCredentialConfig(TableIdentifier tableIdentifier, LoadTableResponse loadTableResponse, CredentialPrivilege privilege) {
        Credential credential = this.getCredential(loadTableResponse, privilege);
        LOG.info("Generate credential: {} for Iceberg table: {}", (Object)credential.credentialType(), (Object)tableIdentifier);
        Map credentialConfig = CredentialPropertyUtils.toIcebergProperties((Credential)credential);
        return LoadTableResponse.builder().withTableMetadata(loadTableResponse.tableMetadata()).addAllConfig(loadTableResponse.config()).addAllConfig(this.getCatalogConfigToClient()).addAllConfig(credentialConfig).build();
    }

    private Credential getCredential(LoadTableResponse loadTableResponse, CredentialPrivilege privilege) {
        TableMetadata tableMetadata = loadTableResponse.tableMetadata();
        Object[] path = (String[])Stream.of(tableMetadata.location(), tableMetadata.property("write.data.path", ""), tableMetadata.property("write.metadata.path", "")).filter(StringUtils::isNotBlank).toArray(String[]::new);
        PathBasedCredentialContext context = privilege == CredentialPrivilege.WRITE ? new PathBasedCredentialContext(PrincipalUtils.getCurrentUserName(), (Set)ImmutableSet.copyOf((Object[])path), Collections.emptySet()) : new PathBasedCredentialContext(PrincipalUtils.getCurrentUserName(), Collections.emptySet(), (Set)ImmutableSet.copyOf((Object[])path));
        Credential credential = this.catalogCredentialManager.getCredential((CredentialContext)context);
        if (credential == null) {
            throw new ServiceUnavailableException("Couldn't generate credential, %s", new Object[]{context});
        }
        return credential;
    }

    /*
     * Exception decompiling
     */
    public PlanTableScanResponse planTableScan(TableIdentifier tableIdentifier, PlanTableScanRequest scanRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CloseableIterable<FileScanTask> createFilePlanScanTasks(Table table, TableIdentifier tableIdentifier, PlanTableScanRequest scanRequest) {
        Long startSnapshotId = scanRequest.startSnapshotId();
        Long endSnapshotId = scanRequest.endSnapshotId();
        if (startSnapshotId != null && endSnapshotId != null) {
            LOG.debug("Using IncrementalAppendScan for table: {}, from snapshot: {} to snapshot: {}", new Object[]{tableIdentifier, startSnapshotId, endSnapshotId});
            IncrementalAppendScan incrementalScan = (IncrementalAppendScan)((IncrementalAppendScan)table.newIncrementalAppendScan().fromSnapshotInclusive(startSnapshotId.longValue())).toSnapshot(endSnapshotId.longValue());
            incrementalScan = this.applyScanRequest(incrementalScan, scanRequest);
            return incrementalScan.planFiles();
        }
        TableScan tableScan = table.newScan();
        if (scanRequest.snapshotId() != null) {
            tableScan = tableScan.useSnapshot(scanRequest.snapshotId().longValue());
            LOG.debug("Applied snapshot filter: snapshot-id={}", (Object)scanRequest.snapshotId());
        }
        tableScan = this.applyScanRequest(tableScan, scanRequest);
        return tableScan.planFiles();
    }

    private <T extends Scan> T applyScanRequest(T scan, PlanTableScanRequest scanRequest) {
        scan = (Scan)scan.caseSensitive(scanRequest.caseSensitive());
        LOG.debug("Applied case-sensitive: {}", (Object)scanRequest.caseSensitive());
        scan = this.applyScanFilter(scan, scanRequest);
        scan = this.applyScanSelect(scan, scanRequest);
        scan = this.applyScanStatsFields(scan, scanRequest);
        return scan;
    }

    private <T extends Scan> T applyScanFilter(T scan, PlanTableScanRequest scanRequest) {
        if (scanRequest.filter() != null) {
            try {
                scan = (Scan)scan.filter(scanRequest.filter());
                LOG.debug("Applied filter expression: {}", (Object)scanRequest.filter());
            }
            catch (Exception e) {
                LOG.error("Failed to apply filter expression: {}", (Object)e.getMessage(), (Object)e);
                throw new IllegalArgumentException("Invalid filter expression: " + e.getMessage(), e);
            }
        }
        return scan;
    }

    private <T extends Scan> T applyScanSelect(T scan, PlanTableScanRequest scanRequest) {
        if (scanRequest.select() != null && !scanRequest.select().isEmpty()) {
            try {
                scan = (Scan)scan.select((Collection)scanRequest.select());
                LOG.debug("Applied column projection: {}", (Object)scanRequest.select());
            }
            catch (Exception e) {
                LOG.error("Failed to apply column projection: {}", (Object)e.getMessage(), (Object)e);
                throw new IllegalArgumentException("Invalid column selection: " + e.getMessage(), e);
            }
        }
        return scan;
    }

    private <T extends Scan> T applyScanStatsFields(T scan, PlanTableScanRequest scanRequest) {
        if (scanRequest.statsFields() != null && !scanRequest.statsFields().isEmpty()) {
            try {
                scan = (Scan)scan.includeColumnStats((Collection)scanRequest.statsFields());
                LOG.debug("Applied statistics fields: {}", (Object)scanRequest.statsFields());
            }
            catch (Exception e) {
                LOG.error("Failed to apply statistics fields: {}", (Object)e.getMessage(), (Object)e);
                throw new IllegalArgumentException("Invalid statistics fields: " + e.getMessage(), e);
            }
        }
        return scan;
    }

    @VisibleForTesting
    static Map<String, String> checkForCompatibility(Map<String, String> properties, Map<String, String> deprecatedProperties) {
        HashMap<String, String> newProperties = new HashMap<String, String>(properties);
        deprecatedProperties.forEach((deprecatedProperty, newProperty) -> CatalogWrapperForREST.replaceDeprecatedProperties(newProperties, deprecatedProperty, newProperty));
        return newProperties;
    }

    private static void replaceDeprecatedProperties(Map<String, String> properties, String deprecatedProperty, String newProperty) {
        String deprecatedValue = properties.get(deprecatedProperty);
        String newValue = properties.get(newProperty);
        if (StringUtils.isNotBlank((CharSequence)deprecatedValue) && StringUtils.isNotBlank((CharSequence)newValue)) {
            throw new IllegalArgumentException(String.format("Should not set both %s and %s", deprecatedProperty, newProperty));
        }
        if (StringUtils.isNotBlank((CharSequence)deprecatedValue)) {
            LOG.warn("{} is deprecated, please use {} instead.", (Object)deprecatedProperty, (Object)newProperty);
            properties.remove(deprecatedProperty);
            properties.put(newProperty, deprecatedValue);
        }
    }
}

