/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.MetadataObject;

public class MetadataObjects {
    public static final String METADATA_OBJECT_RESERVED_NAME = "*";
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.');
    private static final Joiner DOT_JOINER = Joiner.on((char)'.');
    private static final Set<MetadataObject.Type> VALID_SINGLE_LEVEL_NAME_TYPES = Sets.newHashSet((Object[])new MetadataObject.Type[]{MetadataObject.Type.CATALOG, MetadataObject.Type.METALAKE, MetadataObject.Type.ROLE, MetadataObject.Type.TAG, MetadataObject.Type.JOB, MetadataObject.Type.JOB_TEMPLATE, MetadataObject.Type.POLICY});
    private static final Set<MetadataObject.Type> VALID_TWO_LEVEL_NAME_TYPES = Sets.newHashSet((Object[])new MetadataObject.Type[]{MetadataObject.Type.SCHEMA});
    private static final Set<MetadataObject.Type> VALID_THREE_LEVEL_NAME_TYPES = Sets.newHashSet((Object[])new MetadataObject.Type[]{MetadataObject.Type.FILESET, MetadataObject.Type.TABLE, MetadataObject.Type.TOPIC, MetadataObject.Type.MODEL});
    private static final Set<MetadataObject.Type> VALID_FOUR_LEVEL_NAME_TYPES = Sets.newHashSet((Object[])new MetadataObject.Type[]{MetadataObject.Type.COLUMN});
    private static final Map<Set<MetadataObject.Type>, Integer> TYPE_TO_EXPECT_LENGTH = ImmutableMap.of(VALID_SINGLE_LEVEL_NAME_TYPES, (Object)1, VALID_TWO_LEVEL_NAME_TYPES, (Object)2, VALID_THREE_LEVEL_NAME_TYPES, (Object)3, VALID_FOUR_LEVEL_NAME_TYPES, (Object)4);

    private MetadataObjects() {
    }

    public static MetadataObject of(String parent, String name, MetadataObject.Type type) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Cannot create a metadata object with null name");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Cannot create a metadata object with no type");
        if (VALID_SINGLE_LEVEL_NAME_TYPES.contains((Object)type)) {
            Preconditions.checkArgument((parent == null ? 1 : 0) != 0, (Object)("If the type is " + String.valueOf((Object)type) + ", parent must be null"));
        }
        String fullName = parent == null ? name : DOT_JOINER.join((Object)parent, (Object)name, new Object[0]);
        return MetadataObjects.parse(fullName, type);
    }

    public static MetadataObject of(List<String> names, MetadataObject.Type type) {
        Preconditions.checkArgument((names != null ? 1 : 0) != 0, (Object)"Cannot create a metadata object with null names");
        Preconditions.checkArgument((!names.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create a metadata object with no names");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Cannot create a metadata object with no type");
        Integer expectedLength = TYPE_TO_EXPECT_LENGTH.entrySet().stream().filter(entry -> ((Set)entry.getKey()).contains((Object)type)).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsupported metadata object type: " + String.valueOf((Object)type)));
        Preconditions.checkArgument((names.size() == expectedLength.intValue() ? 1 : 0) != 0, (Object)("If the type is " + String.valueOf((Object)type) + ", the length of names must be " + expectedLength));
        for (String name : names) {
            MetadataObjects.checkName(name);
        }
        return new MetadataObjectImpl(MetadataObjects.getParentFullName(names), MetadataObjects.getLastName(names), type);
    }

    @Nullable
    public static MetadataObject parent(MetadataObject object) {
        if (object == null) {
            return null;
        }
        if (VALID_SINGLE_LEVEL_NAME_TYPES.contains((Object)object.type())) {
            return null;
        }
        return MetadataObjects.parse(object.parent(), switch (object.type()) {
            case MetadataObject.Type.COLUMN -> MetadataObject.Type.TABLE;
            case MetadataObject.Type.TABLE, MetadataObject.Type.FILESET, MetadataObject.Type.TOPIC, MetadataObject.Type.MODEL -> MetadataObject.Type.SCHEMA;
            case MetadataObject.Type.SCHEMA -> MetadataObject.Type.CATALOG;
            default -> throw new IllegalArgumentException("Unexpected to reach here for metadata object type: " + String.valueOf((Object)object.type()));
        });
    }

    public static MetadataObject parse(String fullName, MetadataObject.Type type) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)fullName), (Object)"Metadata object full name cannot be blank");
        List parts = DOT_SPLITTER.splitToList((CharSequence)fullName);
        if (VALID_SINGLE_LEVEL_NAME_TYPES.contains((Object)type)) {
            return MetadataObjects.of(Collections.singletonList(fullName), type);
        }
        return MetadataObjects.of(parts, type);
    }

    private static String getParentFullName(List<String> names) {
        if (names.size() <= 1) {
            return null;
        }
        return DOT_JOINER.join(names.subList(0, names.size() - 1));
    }

    private static String getLastName(List<String> names) {
        return names.get(names.size() - 1);
    }

    private static void checkName(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Cannot create a metadata object with null name");
        Preconditions.checkArgument((!METADATA_OBJECT_RESERVED_NAME.equals(name) ? 1 : 0) != 0, (Object)"Cannot create a metadata object with `*` name.");
    }

    public static class MetadataObjectImpl
    implements MetadataObject {
        private final String name;
        private final String parent;
        private final MetadataObject.Type type;

        public MetadataObjectImpl(String parent, String name, MetadataObject.Type type) {
            this.parent = parent;
            this.name = name;
            this.type = type;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String parent() {
            return this.parent;
        }

        @Override
        public MetadataObject.Type type() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MetadataObjectImpl)) {
                return false;
            }
            MetadataObjectImpl that = (MetadataObjectImpl)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.parent, that.parent) && this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.parent, this.type});
        }

        public String toString() {
            return "MetadataObject: [fullName=" + this.fullName() + "], [type=" + String.valueOf((Object)this.type) + "]";
        }
    }
}

