/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.util.function.Consumer;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.BadRequestException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.iceberg.exceptions.RESTException;
import org.apache.iceberg.exceptions.ServiceFailureException;
import org.apache.iceberg.exceptions.ServiceUnavailableException;
import org.apache.iceberg.rest.ErrorHandler;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.ErrorResponseParser;
import org.apache.iceberg.rest.responses.OAuthErrorResponseParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandlers {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorHandlers.class);

    private ErrorHandlers() {
    }

    public static Consumer<ErrorResponse> namespaceErrorHandler() {
        return NamespaceErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> dropNamespaceErrorHandler() {
        return DropNamespaceErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> tableErrorHandler() {
        return TableErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> viewErrorHandler() {
        return ViewErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> viewCommitHandler() {
        return ViewCommitErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> tableCommitHandler() {
        return CommitErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> defaultErrorHandler() {
        return DefaultErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> oauthErrorHandler() {
        return OAuthErrorHandler.INSTANCE;
    }

    private static class NamespaceErrorHandler
    extends DefaultErrorHandler {
        private static final ErrorHandler INSTANCE = new NamespaceErrorHandler();

        private NamespaceErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse error) {
            switch (error.code()) {
                case 400: {
                    if (NamespaceNotEmptyException.class.getSimpleName().equals(error.type())) {
                        throw new NamespaceNotEmptyException("%s", new Object[]{error.message()});
                    }
                    throw new BadRequestException("Malformed request: %s", new Object[]{error.message()});
                }
                case 404: {
                    throw new NoSuchNamespaceException("%s", new Object[]{error.message()});
                }
                case 409: {
                    throw new AlreadyExistsException("%s", new Object[]{error.message()});
                }
                case 422: {
                    throw new RESTException("Unable to process: %s", new Object[]{error.message()});
                }
            }
            super.accept(error);
        }
    }

    private static class DropNamespaceErrorHandler
    extends NamespaceErrorHandler {
        private static final ErrorHandler INSTANCE = new DropNamespaceErrorHandler();

        private DropNamespaceErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse error) {
            if (error.code() == 409) {
                throw new NamespaceNotEmptyException("%s", new Object[]{error.message()});
            }
            super.accept(error);
        }
    }

    private static class TableErrorHandler
    extends DefaultErrorHandler {
        private static final ErrorHandler INSTANCE = new TableErrorHandler();

        private TableErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse error) {
            switch (error.code()) {
                case 404: {
                    if (NoSuchNamespaceException.class.getSimpleName().equals(error.type())) {
                        throw new NoSuchNamespaceException("%s", new Object[]{error.message()});
                    }
                    throw new NoSuchTableException("%s", new Object[]{error.message()});
                }
                case 409: {
                    throw new AlreadyExistsException("%s", new Object[]{error.message()});
                }
            }
            super.accept(error);
        }
    }

    private static class ViewErrorHandler
    extends DefaultErrorHandler {
        private static final ErrorHandler INSTANCE = new ViewErrorHandler();

        private ViewErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse error) {
            switch (error.code()) {
                case 404: {
                    if (NoSuchNamespaceException.class.getSimpleName().equals(error.type())) {
                        throw new NoSuchNamespaceException("%s", new Object[]{error.message()});
                    }
                    throw new NoSuchViewException("%s", new Object[]{error.message()});
                }
                case 409: {
                    throw new AlreadyExistsException("%s", new Object[]{error.message()});
                }
            }
            super.accept(error);
        }
    }

    private static class ViewCommitErrorHandler
    extends DefaultErrorHandler {
        private static final ErrorHandler INSTANCE = new ViewCommitErrorHandler();

        private ViewCommitErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse error) {
            switch (error.code()) {
                case 404: {
                    throw new NoSuchViewException("%s", new Object[]{error.message()});
                }
                case 409: {
                    throw new CommitFailedException("Commit failed: %s", new Object[]{error.message()});
                }
                case 500: 
                case 502: 
                case 503: 
                case 504: {
                    throw new CommitStateUnknownException((Throwable)new ServiceFailureException("Service failed: %s: %s", new Object[]{error.code(), error.message()}));
                }
            }
            super.accept(error);
        }
    }

    private static class CommitErrorHandler
    extends DefaultErrorHandler {
        private static final ErrorHandler INSTANCE = new CommitErrorHandler();

        private CommitErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse error) {
            switch (error.code()) {
                case 404: {
                    throw new NoSuchTableException("%s", new Object[]{error.message()});
                }
                case 409: {
                    throw new CommitFailedException("Commit failed: %s", new Object[]{error.message()});
                }
                case 500: 
                case 502: 
                case 503: 
                case 504: {
                    throw new CommitStateUnknownException((Throwable)new ServiceFailureException("Service failed: %s: %s", new Object[]{error.code(), error.message()}));
                }
            }
            super.accept(error);
        }
    }

    private static class DefaultErrorHandler
    extends ErrorHandler {
        private static final ErrorHandler INSTANCE = new DefaultErrorHandler();

        private DefaultErrorHandler() {
        }

        @Override
        public ErrorResponse parseResponse(int code, String json) {
            try {
                return ErrorResponseParser.fromJson(json);
            }
            catch (Exception x) {
                LOG.warn("Unable to parse error response", (Throwable)x);
                return ErrorResponse.builder().responseCode(code).withMessage(json).build();
            }
        }

        @Override
        public void accept(ErrorResponse error) {
            switch (error.code()) {
                case 400: {
                    if (IllegalArgumentException.class.getSimpleName().equals(error.type())) {
                        throw new IllegalArgumentException(error.message());
                    }
                    throw new BadRequestException("Malformed request: %s", new Object[]{error.message()});
                }
                case 401: {
                    throw new NotAuthorizedException("Not authorized: %s", new Object[]{error.message()});
                }
                case 403: {
                    throw new ForbiddenException("Forbidden: %s", new Object[]{error.message()});
                }
                case 405: 
                case 406: {
                    break;
                }
                case 500: {
                    throw new ServiceFailureException("Server error: %s: %s", new Object[]{error.type(), error.message()});
                }
                case 501: {
                    throw new UnsupportedOperationException(error.message());
                }
                case 503: {
                    throw new ServiceUnavailableException("Service unavailable: %s", new Object[]{error.message()});
                }
            }
            throw new RESTException("Unable to process: %s", new Object[]{error.message()});
        }
    }

    private static class OAuthErrorHandler
    extends ErrorHandler {
        private static final ErrorHandler INSTANCE = new OAuthErrorHandler();

        private OAuthErrorHandler() {
        }

        @Override
        public ErrorResponse parseResponse(int code, String json) {
            try {
                return OAuthErrorResponseParser.fromJson(code, json);
            }
            catch (Exception x) {
                LOG.warn("Unable to parse error response", (Throwable)x);
                return ErrorResponse.builder().responseCode(code).withMessage(json).build();
            }
        }

        @Override
        public void accept(ErrorResponse error) {
            if (error.type() != null) {
                switch (error.type()) {
                    case "invalid_client": {
                        throw new NotAuthorizedException("Not authorized: %s: %s", new Object[]{error.type(), error.message()});
                    }
                    case "invalid_request": 
                    case "invalid_grant": 
                    case "unauthorized_client": 
                    case "unsupported_grant_type": 
                    case "invalid_scope": {
                        throw new BadRequestException("Malformed request: %s: %s", new Object[]{error.type(), error.message()});
                    }
                }
            }
            throw new RESTException("Unable to process: %s", new Object[]{error.message()});
        }
    }
}

