/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Properties;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.admin.SSLConfig;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;

public class ContextAwareSSLRMIClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    private static final long serialVersionUID = 8159615071011918570L;
    @Immutable
    private static final SslRMIClientSocketFactory defaultFactory = new SslRMIClientSocketFactory();

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        try {
            SocketCreator socketCreator = SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.JMX);
            return socketCreator.connectForClient(host, port, 0);
        }
        catch (Exception exception) {
            try {
                Properties gfProperties = new Properties();
                gfProperties.load(new StringReader(System.getProperty("org.apache.geode.internal.net.ssl.config")));
                SSLConfig sslConfig = SSLConfigurationFactory.getSSLConfigForComponent(gfProperties, SecurableCommunicationChannel.JMX);
                SocketCreator socketCreator = new SocketCreator(sslConfig);
                return socketCreator.connectForClient(host, port, 0);
            }
            catch (Exception finalException) {
                return defaultFactory.createSocket(host, port);
            }
        }
    }
}

