/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.statistics.meters.LegacyStatCounter;

public class GatewayReceiverStats
extends CacheServerStats {
    private static final String typeName = "GatewayReceiverStatistics";
    private static final String DUPLICATE_BATCHES_RECEIVED = "duplicateBatchesReceived";
    private static final String OUT_OF_ORDER_BATCHES_RECEIVED = "outoforderBatchesReceived";
    private static final String EARLY_ACKS = "earlyAcks";
    private static final String EVENTS_RECEIVED = "eventsReceived";
    private static final String CREAT_REQUESTS = "createRequests";
    private static final String UPDATE_REQUESTS = "updateRequest";
    private static final String DESTROY_REQUESTS = "destroyRequest";
    private static final String UNKNOWN_OPERATIONS_RECEIVED = "unknowsOperationsReceived";
    private static final String EXCEPTIONS_OCCURRED = "exceptionsOccurred";
    private static final String EVENTS_RETRIED = "eventsRetried";
    private final MeterRegistry meterRegistry;
    private int duplicateBatchesReceivedId;
    private int outoforderBatchesReceivedId;
    private int earlyAcksId;
    private int eventsReceivedId;
    private final Counter eventsReceivedCounter;
    private static final String EVENTS_RECEIVED_COUNTER_NAME = "geode.gateway.receiver.events";
    private static final String EVENTS_RECEIVED_COUNTER_DESCRIPTION = "total number events across the batched received by this GatewayReceiver";
    private static final String EVENTS_RECEIVED_COUNTER_UNITS = "operations";
    private int createRequestId;
    private int updateRequestId;
    private int destroyRequestId;
    private int unknowsOperationsReceivedId;
    private int exceptionsOccurredId;
    private int eventsRetriedId;

    public static GatewayReceiverStats createGatewayReceiverStats(StatisticsFactory f, String ownerName, MeterRegistry meterRegistry) {
        StatisticDescriptor[] descriptors = new StatisticDescriptor[]{f.createIntCounter(DUPLICATE_BATCHES_RECEIVED, "number of batches which have already been seen by this GatewayReceiver", "nanoseconds"), f.createIntCounter(OUT_OF_ORDER_BATCHES_RECEIVED, "number of batches which are out of order on this GatewayReceiver", EVENTS_RECEIVED_COUNTER_UNITS), f.createIntCounter(EARLY_ACKS, "number of early acknowledgements sent to gatewaySenders", EVENTS_RECEIVED_COUNTER_UNITS), f.createLongCounter(EVENTS_RECEIVED, EVENTS_RECEIVED_COUNTER_DESCRIPTION, EVENTS_RECEIVED_COUNTER_UNITS), f.createIntCounter(CREAT_REQUESTS, "total number of create operations received by this GatewayReceiver", EVENTS_RECEIVED_COUNTER_UNITS), f.createIntCounter(UPDATE_REQUESTS, "total number of update operations received by this GatewayReceiver", EVENTS_RECEIVED_COUNTER_UNITS), f.createIntCounter(DESTROY_REQUESTS, "total number of destroy operations received by this GatewayReceiver", EVENTS_RECEIVED_COUNTER_UNITS), f.createIntCounter(UNKNOWN_OPERATIONS_RECEIVED, "total number of unknown operations received by this GatewayReceiver", EVENTS_RECEIVED_COUNTER_UNITS), f.createIntCounter(EXCEPTIONS_OCCURRED, "number of exceptions occurred while porcessing the batches", EVENTS_RECEIVED_COUNTER_UNITS), f.createIntCounter(EVENTS_RETRIED, "total number events retried by this GatewayReceiver due to exceptions", EVENTS_RECEIVED_COUNTER_UNITS)};
        return new GatewayReceiverStats(f, ownerName, typeName, descriptors, meterRegistry);
    }

    public GatewayReceiverStats(StatisticsFactory f, String ownerName, String typeName, StatisticDescriptor[] descriptiors, MeterRegistry meterRegistry) {
        super(f, ownerName, typeName, descriptiors);
        this.duplicateBatchesReceivedId = this.statType.nameToId(DUPLICATE_BATCHES_RECEIVED);
        this.outoforderBatchesReceivedId = this.statType.nameToId(OUT_OF_ORDER_BATCHES_RECEIVED);
        this.earlyAcksId = this.statType.nameToId(EARLY_ACKS);
        this.eventsReceivedId = this.statType.nameToId(EVENTS_RECEIVED);
        this.createRequestId = this.statType.nameToId(CREAT_REQUESTS);
        this.updateRequestId = this.statType.nameToId(UPDATE_REQUESTS);
        this.destroyRequestId = this.statType.nameToId(DESTROY_REQUESTS);
        this.unknowsOperationsReceivedId = this.statType.nameToId(UNKNOWN_OPERATIONS_RECEIVED);
        this.exceptionsOccurredId = this.statType.nameToId(EXCEPTIONS_OCCURRED);
        this.eventsRetriedId = this.statType.nameToId(EVENTS_RETRIED);
        this.meterRegistry = meterRegistry;
        this.eventsReceivedCounter = LegacyStatCounter.builder(EVENTS_RECEIVED_COUNTER_NAME).longStatistic(this.stats, this.eventsReceivedId).description(EVENTS_RECEIVED_COUNTER_DESCRIPTION).baseUnit(EVENTS_RECEIVED_COUNTER_UNITS).register(meterRegistry);
    }

    public void incDuplicateBatchesReceived() {
        this.stats.incInt(this.duplicateBatchesReceivedId, 1);
    }

    public int getDuplicateBatchesReceived() {
        return this.stats.getInt(this.duplicateBatchesReceivedId);
    }

    public void incOutoforderBatchesReceived() {
        this.stats.incInt(this.outoforderBatchesReceivedId, 1);
    }

    public int getOutoforderBatchesReceived() {
        return this.stats.getInt(this.outoforderBatchesReceivedId);
    }

    public void incEarlyAcks() {
        this.stats.incInt(this.earlyAcksId, 1);
    }

    public int getEarlyAcks() {
        return this.stats.getInt(this.earlyAcksId);
    }

    public void incEventsReceived(int delta) {
        this.eventsReceivedCounter.increment((double)delta);
    }

    public int getEventsReceived() {
        return (int)this.eventsReceivedCounter.count();
    }

    public void incCreateRequest() {
        this.stats.incInt(this.createRequestId, 1);
    }

    public int getCreateRequest() {
        return this.stats.getInt(this.createRequestId);
    }

    public void incUpdateRequest() {
        this.stats.incInt(this.updateRequestId, 1);
    }

    public int getUpdateRequest() {
        return this.stats.getInt(this.updateRequestId);
    }

    public void incDestroyRequest() {
        this.stats.incInt(this.destroyRequestId, 1);
    }

    public int getDestroyRequest() {
        return this.stats.getInt(this.destroyRequestId);
    }

    public void incUnknowsOperationsReceived() {
        this.stats.incInt(this.unknowsOperationsReceivedId, 1);
    }

    public int getUnknowsOperationsReceived() {
        return this.stats.getInt(this.unknowsOperationsReceivedId);
    }

    public void incExceptionsOccurred() {
        this.stats.incInt(this.exceptionsOccurredId, 1);
    }

    public int getExceptionsOccurred() {
        return this.stats.getInt(this.exceptionsOccurredId);
    }

    public void incEventsRetried() {
        this.stats.incInt(this.eventsRetriedId, 1);
    }

    public int getEventsRetried() {
        return this.stats.getInt(this.eventsRetriedId);
    }

    public long startTime() {
        return DistributionStats.getStatTime();
    }

    @Override
    public void close() {
        this.meterRegistry.remove((Meter)this.eventsReceivedCounter);
        super.close();
    }
}

