/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.membership.api.MembershipInformation;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.admin.SSLConfig;
import org.apache.geode.internal.admin.TransportConfig;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;

public class RemoteTransportConfig
implements TransportConfig {
    private final boolean mcastEnabled;
    private final boolean tcpDisabled;
    private final boolean disableAutoReconnect;
    private final DistributionLocatorId mcastId;
    private final Set ids;
    private final String bindAddress;
    private final SSLConfig sslConfig;
    private final String membershipPortRange;
    private int tcpPort;
    private boolean isReconnectingDS;
    private MembershipInformation oldDSMembershipInfo;
    private int vmKind = -1;

    public RemoteTransportConfig(DistributionConfig config, int vmKind) {
        this.bindAddress = config.getBindAddress() == null ? "" : config.getBindAddress();
        this.vmKind = vmKind;
        this.tcpPort = config.getTcpPort();
        this.membershipPortRange = RemoteTransportConfig.getMembershipPortRangeString(config.getMembershipPortRange());
        this.sslConfig = new SSLConfig.Builder().build();
        String initialHosts = config.getLocators();
        if (initialHosts == null) {
            initialHosts = "";
        }
        initialHosts = initialHosts.trim();
        if (config.getMcastPort() > 0) {
            this.mcastId = new DistributionLocatorId(config.getMcastAddress(), config.getMcastPort(), config.getBindAddress(), this.sslConfig);
            this.mcastEnabled = true;
        } else {
            this.mcastEnabled = false;
            this.mcastId = null;
        }
        this.tcpDisabled = config.getDisableTcp();
        this.disableAutoReconnect = config.getDisableAutoReconnect();
        if (initialHosts.length() == 0) {
            this.ids = Collections.EMPTY_SET;
            return;
        }
        HashSet<DistributionLocatorId> locators = new HashSet<DistributionLocatorId>();
        StringTokenizer stringTokenizer = new StringTokenizer(initialHosts, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String locator = stringTokenizer.nextToken();
            if (!StringUtils.isNotEmpty((CharSequence)locator)) continue;
            locators.add(new DistributionLocatorId(locator));
        }
        if (this.mcastEnabled) {
            locators.add(this.mcastId);
        }
        this.ids = Collections.unmodifiableSet(locators);
        if (this.mcastEnabled) {
            Assert.assertTrue(this.mcastId != null);
        }
    }

    public RemoteTransportConfig(boolean isMcastEnabled, boolean isTcpDisabled, boolean isAutoReconnectDisabled, String bindAddress, SSLConfig sslConfig, Collection ids, String membershipPortRange, int tcpPort, int vmKind) {
        DistributionLocatorId mid = null;
        this.bindAddress = bindAddress == null ? "" : bindAddress;
        this.sslConfig = sslConfig;
        this.mcastEnabled = isMcastEnabled;
        this.tcpDisabled = isTcpDisabled;
        this.disableAutoReconnect = isAutoReconnectDisabled;
        if (isMcastEnabled) {
            if (ids.size() < 1) {
                throw new IllegalArgumentException("expected at least one host/port id");
            }
            Iterator it = ids.iterator();
            while (it.hasNext() && mid == null) {
                DistributionLocatorId id = (DistributionLocatorId)it.next();
                if (!id.isMcastId()) continue;
                mid = id;
            }
        }
        this.ids = Collections.unmodifiableSet(new HashSet(ids));
        this.mcastId = mid;
        if (this.mcastEnabled) {
            Assert.assertTrue(this.mcastId != null);
        }
        this.membershipPortRange = membershipPortRange;
        this.tcpPort = tcpPort;
        this.vmKind = vmKind;
    }

    private static String getMembershipPortRangeString(int[] membershipPortRange) {
        String membershipPortRangeString = "";
        if (membershipPortRange != null && membershipPortRange.length == 2) {
            membershipPortRangeString = membershipPortRange[0] + "-" + membershipPortRange[1];
        }
        return membershipPortRangeString;
    }

    public Set getIds() {
        return this.ids;
    }

    public boolean isMcastEnabled() {
        return this.mcastEnabled;
    }

    public DistributionLocatorId getMcastId() {
        return this.mcastId;
    }

    public int getVmKind() {
        return this.vmKind;
    }

    public boolean isTcpDisabled() {
        return this.tcpDisabled;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public SSLConfig getSSLConfig() {
        return this.sslConfig;
    }

    public String getMembershipPortRange() {
        return this.membershipPortRange;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public boolean getIsReconnectingDS() {
        return this.isReconnectingDS;
    }

    public void setIsReconnectingDS(boolean isReconnectingDS) {
        this.isReconnectingDS = isReconnectingDS;
    }

    public MembershipInformation getOldDSMembershipInfo() {
        return this.oldDSMembershipInfo;
    }

    public void setOldDSMembershipInfo(MembershipInformation oldDSMembershipInfo) {
        this.oldDSMembershipInfo = oldDSMembershipInfo;
    }

    Properties toDSProperties() {
        Properties props = new Properties();
        props.setProperty("bind-address", this.bindAddress);
        if (this.membershipPortRange != null) {
            props.setProperty("membership-port-range", this.membershipPortRange);
        }
        if (this.tcpPort != 0) {
            props.setProperty("tcp-port", String.valueOf(this.tcpPort));
        }
        if (this.mcastEnabled) {
            props.setProperty("mcast-address", this.mcastId.getHostName());
            props.setProperty("mcast-port", String.valueOf(this.mcastId.getPort()));
        } else {
            props.setProperty("mcast-port", String.valueOf(0));
        }
        StringBuffer locators = new StringBuffer();
        Iterator iter = this.ids.iterator();
        while (iter.hasNext()) {
            DistributionLocatorId locator = (DistributionLocatorId)iter.next();
            if (locator.isMcastId()) continue;
            String baddr = locator.getBindAddress();
            if (baddr != null && baddr.trim().length() > 0) {
                locators.append(baddr);
            } else {
                locators.append(locator.getHostName());
            }
            locators.append("[");
            locators.append(locator.getPort());
            locators.append("]");
            if (!iter.hasNext()) continue;
            locators.append(",");
        }
        String tempLocatorString = locators.toString();
        if (tempLocatorString.endsWith(",")) {
            tempLocatorString = tempLocatorString.substring(0, tempLocatorString.length() - 1);
        }
        props.setProperty("locators", tempLocatorString);
        this.sslConfig.toDSProperties(props);
        props.setProperty("disable-tcp", this.tcpDisabled ? "true" : "false");
        props.setProperty("disable-auto-reconnect", this.disableAutoReconnect ? "true" : "false");
        return props;
    }

    private String toString(boolean noMcast) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (DistributionLocatorId dli : this.ids) {
            if (noMcast && dli.isMcastId()) continue;
            if (!first) {
                result.append(',');
            } else {
                first = false;
            }
            result.append(dli.toString());
        }
        return result.toString();
    }

    public String locatorsString() {
        return this.toString(true);
    }

    public String toString() {
        return this.toString(false);
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof RemoteTransportConfig) {
            RemoteTransportConfig other = (RemoteTransportConfig)o;
            return this.mcastEnabled == other.mcastEnabled && this.ids.equals(other.ids);
        }
        return false;
    }

    public int hashCode() {
        return this.ids.hashCode();
    }
}

