/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.statistics.StatisticsClock;

public class StatisticsClockFactory {
    @Immutable
    public static final String ENABLE_CLOCK_STATS_PROPERTY = "enableClockStats";
    @Immutable
    public static final boolean enableClockStats = Boolean.getBoolean("enableClockStats");

    @Deprecated
    public static long getTimeIfEnabled() {
        return enableClockStats ? StatisticsClockFactory.getTime() : 0L;
    }

    public static long getTime() {
        return System.nanoTime();
    }

    public static StatisticsClock clock() {
        return StatisticsClockFactory.clock(Boolean.getBoolean(ENABLE_CLOCK_STATS_PROPERTY));
    }

    public static StatisticsClock clock(boolean enabled) {
        if (enabled) {
            return StatisticsClockFactory.enabledClock(StatisticsClockFactory::getTime);
        }
        return StatisticsClockFactory.disabledClock();
    }

    public static StatisticsClock enabledClock() {
        return StatisticsClockFactory.clock(StatisticsClockFactory::getTime, () -> true);
    }

    public static StatisticsClock enabledClock(LongSupplier time) {
        return StatisticsClockFactory.clock(time::getAsLong, () -> true);
    }

    public static StatisticsClock disabledClock() {
        return StatisticsClockFactory.clock(() -> 0L, () -> false);
    }

    public static StatisticsClock clock(final LongSupplier time, final BooleanSupplier isEnabled) {
        return new StatisticsClock(){

            @Override
            public long getTime() {
                return time.getAsLong();
            }

            @Override
            public boolean isEnabled() {
                return isEnabled.getAsBoolean();
            }
        };
    }
}

