/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net.filewatch;

import java.io.FileInputStream;
import java.net.Socket;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.net.filewatch.PollingFileWatcher;
import org.apache.geode.internal.util.PasswordUtil;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public final class FileWatchingX509ExtendedTrustManager
extends X509ExtendedTrustManager {
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic
    private static final ConcurrentHashMap<Path, FileWatchingX509ExtendedTrustManager> instances = new ConcurrentHashMap();
    private final AtomicReference<X509ExtendedTrustManager> trustManager = new AtomicReference();
    private final Path trustStorePath;
    private final String trustStoreType;
    private final String trustStorePassword;
    private final PollingFileWatcher fileWatcher;

    private FileWatchingX509ExtendedTrustManager(Path trustStorePath, String trustStoreType, String trustStorePassword) {
        this.trustStorePath = trustStorePath;
        this.trustStoreType = trustStoreType;
        this.trustStorePassword = trustStorePassword;
        this.loadTrustManager();
        this.fileWatcher = new PollingFileWatcher(this.trustStorePath, this::loadTrustManager, this::stopWatching);
    }

    public static FileWatchingX509ExtendedTrustManager newFileWatchingTrustManager(SSLConfig config) {
        return FileWatchingX509ExtendedTrustManager.newFileWatchingTrustManager(Paths.get(config.getTruststore(), new String[0]), config.getTruststoreType(), config.getTruststorePassword());
    }

    public static FileWatchingX509ExtendedTrustManager newFileWatchingTrustManager(Path trustStorePath, String type, String password) {
        return instances.computeIfAbsent(trustStorePath, p -> new FileWatchingX509ExtendedTrustManager(trustStorePath, type, password));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
        this.trustManager.get().checkClientTrusted(x509Certificates, s, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
        this.trustManager.get().checkClientTrusted(x509Certificates, s, sslEngine);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        this.trustManager.get().checkClientTrusted(x509Certificates, s);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
        this.trustManager.get().checkServerTrusted(x509Certificates, s, sslEngine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
        this.trustManager.get().checkServerTrusted(x509Certificates, s, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        this.trustManager.get().checkServerTrusted(x509Certificates, s);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.get().getAcceptedIssuers();
    }

    @VisibleForTesting
    void stopWatching() {
        this.fileWatcher.stop();
        instances.remove(this.trustStorePath, this);
    }

    @VisibleForTesting
    boolean isWatching() {
        return instances.get(this.trustStorePath) == this;
    }

    private void loadTrustManager() {
        TrustManager[] trustManagers;
        try {
            KeyStore trustStore = StringUtils.isEmpty((CharSequence)this.trustStoreType) ? KeyStore.getInstance(KeyStore.getDefaultType()) : KeyStore.getInstance(this.trustStoreType);
            char[] password = null;
            try (FileInputStream fis = new FileInputStream(this.trustStorePath.toString());){
                String passwordString = this.trustStorePassword;
                if (passwordString != null) {
                    if (passwordString.trim().equals("")) {
                        if (!StringUtils.isEmpty((CharSequence)passwordString)) {
                            String toDecrypt = "encrypted(" + passwordString + ")";
                            passwordString = PasswordUtil.decrypt(toDecrypt);
                            password = passwordString.toCharArray();
                        }
                    } else {
                        password = passwordString.toCharArray();
                    }
                }
                trustStore.load(fis, password);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            trustManagers = tmf.getTrustManagers();
            if (password != null) {
                Arrays.fill(password, ' ');
            }
        }
        catch (Exception e) {
            throw new InternalGemFireException("Unable to load TrustManager", e);
        }
        for (TrustManager tm : trustManagers) {
            if (!(tm instanceof X509ExtendedTrustManager)) continue;
            if (this.trustManager.getAndSet((X509ExtendedTrustManager)tm) == null) {
                logger.info("Initialized TrustManager for {}", (Object)this.trustStorePath);
            } else {
                logger.info("Updated TrustManager for {}", (Object)this.trustStorePath);
            }
            return;
        }
        throw new IllegalStateException("No X509ExtendedTrustManager available");
    }
}

