/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.geode.admin.AdminXmlException;
import org.apache.geode.admin.CacheServerConfig;
import org.apache.geode.admin.DistributedSystemConfig;
import org.apache.geode.admin.DistributionLocatorConfig;
import org.apache.geode.admin.ManagedEntityConfig;
import org.apache.geode.admin.internal.ManagedEntityConfigXml;
import org.apache.geode.internal.Assert;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@Deprecated
public class ManagedEntityConfigXmlParser
extends ManagedEntityConfigXml
implements ContentHandler {
    private DistributedSystemConfig config;
    private final Stack stack = new Stack();

    public static void parse(InputStream is, DistributedSystemConfig config) {
        ManagedEntityConfigXmlParser handler = new ManagedEntityConfigXmlParser();
        handler.config = config;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            SAXParser parser = factory.newSAXParser();
            parser.parse(is, (DefaultHandler)new DefaultHandlerDelegate(handler));
        }
        catch (Exception ex) {
            SAXException sax;
            Exception cause;
            if (ex instanceof AdminXmlException) {
                throw (AdminXmlException)ex;
            }
            if (ex.getCause() instanceof AdminXmlException) {
                throw (AdminXmlException)ex.getCause();
            }
            if (ex instanceof SAXException && (cause = (sax = (SAXException)ex).getException()) instanceof AdminXmlException) {
                throw (AdminXmlException)cause;
            }
            throw new AdminXmlException("While parsing XML", ex);
        }
    }

    private static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            throw new AdminXmlException(String.format("Malformed integer %s", s), ex);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("distributed-system")) {
            this.startDistributedSystem(atts);
        } else if (qName.equals("remote-command")) {
            this.startRemoteCommand(atts);
        } else if (qName.equals("locators")) {
            this.startLocators(atts);
        } else if (qName.equals("multicast")) {
            this.startMulticast(atts);
        } else if (qName.equals("locator")) {
            this.startLocator(atts);
        } else if (qName.equals("host")) {
            this.startHost(atts);
        } else if (qName.equals("working-directory")) {
            this.startWorkingDirectory(atts);
        } else if (qName.equals("product-directory")) {
            this.startProductDirectory(atts);
        } else if (qName.equals("ssl")) {
            this.startSSL(atts);
        } else if (qName.equals("protocols")) {
            this.startProtocols(atts);
        } else if (qName.equals("ciphers")) {
            this.startCiphers(atts);
        } else if (qName.equals("property")) {
            this.startProperty(atts);
        } else if (qName.equals("key")) {
            this.startKey(atts);
        } else if (qName.equals("value")) {
            this.startValue(atts);
        } else if (qName.equals("cache-server")) {
            this.startCacheServer(atts);
        } else if (qName.equals("classpath")) {
            this.startClassPath(atts);
        } else {
            throw new AdminXmlException(String.format("Unknown XML element %s", qName));
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals("distributed-system")) {
            this.endDistributedSystem();
        } else if (qName.equals("remote-command")) {
            this.endRemoteCommand();
        } else if (qName.equals("locators")) {
            this.endLocators();
        } else if (qName.equals("multicast")) {
            this.endMulticast();
        } else if (qName.equals("locator")) {
            this.endLocator();
        } else if (qName.equals("host")) {
            this.endHost();
        } else if (qName.equals("working-directory")) {
            this.endWorkingDirectory();
        } else if (qName.equals("product-directory")) {
            this.endProductDirectory();
        } else if (qName.equals("ssl")) {
            this.endSSL();
        } else if (qName.equals("protocols")) {
            this.endProtocols();
        } else if (qName.equals("ciphers")) {
            this.endCiphers();
        } else if (qName.equals("property")) {
            this.endProperty();
        } else if (qName.equals("key")) {
            this.endKey();
        } else if (qName.equals("value")) {
            this.endValue();
        } else if (qName.equals("cache-server")) {
            this.endCacheServer();
        } else if (qName.equals("classpath")) {
            this.endClassPath();
        } else {
            throw new AdminXmlException(String.format("Unknown XML element %s", qName));
        }
    }

    private void startDistributedSystem(Attributes atts) {
        String disable_tcp;
        Assert.assertTrue(this.stack.isEmpty());
        String id = atts.getValue("id");
        if (id != null) {
            this.config.setSystemId(id);
        }
        if ((disable_tcp = atts.getValue("disable-tcp")) != null) {
            this.config.setDisableTcp("disable-tcp".equalsIgnoreCase("true"));
        }
        this.stack.push(this.config);
    }

    private void endDistributedSystem() {
    }

    private void startMulticast(Attributes atts) {
        DistributedSystemConfig config = (DistributedSystemConfig)this.stack.peek();
        String port = atts.getValue("port");
        config.setMcastPort(ManagedEntityConfigXmlParser.parseInt(port));
        String address = atts.getValue("address");
        if (address != null) {
            config.setMcastAddress(address);
        }
    }

    private void endMulticast() {
    }

    private void startRemoteCommand(Attributes atts) {
    }

    private void endRemoteCommand() {
        String remoteCommand = this.popString();
        Object top = this.stack.peek();
        Assert.assertTrue(top != null);
        if (top instanceof DistributedSystemConfig) {
            ((DistributedSystemConfig)top).setRemoteCommand(remoteCommand);
        } else if (top instanceof ManagedEntityConfig) {
            ((ManagedEntityConfig)top).setRemoteCommand(remoteCommand);
        } else {
            String s = "Did not expect a " + top.getClass().getName() + " on top of the stack";
            Assert.assertTrue(false, s);
        }
    }

    private void startLocators(Attributes atts) {
    }

    private void endLocators() {
    }

    private void startLocator(Attributes atts) {
        String port = atts.getValue("port");
        DistributedSystemConfig system = (DistributedSystemConfig)this.stack.peek();
        system.setMcastPort(0);
        DistributionLocatorConfig config = system.createDistributionLocatorConfig();
        config.setPort(ManagedEntityConfigXmlParser.parseInt(port));
        this.stack.push(config);
    }

    private void endLocator() {
        Object o = this.stack.pop();
        Assert.assertTrue(o instanceof DistributionLocatorConfig);
    }

    private void startHost(Attributes atts) {
    }

    private void endHost() {
        String host = this.popString();
        ManagedEntityConfig config = (ManagedEntityConfig)this.stack.peek();
        config.setHost(host);
    }

    private void startWorkingDirectory(Attributes atts) {
    }

    private void endWorkingDirectory() {
        String workingDirectory = this.popString();
        ManagedEntityConfig config = (ManagedEntityConfig)this.stack.peek();
        config.setWorkingDirectory(workingDirectory);
    }

    private void startProductDirectory(Attributes atts) {
    }

    private void endProductDirectory() {
        String productDirectory = this.popString();
        ManagedEntityConfig config = (ManagedEntityConfig)this.stack.peek();
        config.setProductDirectory(productDirectory);
    }

    private void startSSL(Attributes atts) {
        DistributedSystemConfig config = (DistributedSystemConfig)this.stack.peek();
        config.setSSLEnabled(true);
        String authenticationRequired = atts.getValue("authentication-required");
        config.setSSLAuthenticationRequired(Boolean.parseBoolean(authenticationRequired));
    }

    private void endSSL() {
    }

    private void startProtocols(Attributes atts) {
    }

    private void endProtocols() {
        String protocols = this.popString();
        DistributedSystemConfig config = (DistributedSystemConfig)this.stack.peek();
        config.setSSLProtocols(protocols);
    }

    private void startCiphers(Attributes atts) {
    }

    private void endCiphers() {
        String ciphers = this.popString();
        DistributedSystemConfig config = (DistributedSystemConfig)this.stack.peek();
        config.setSSLCiphers(ciphers);
    }

    private void startProperty(Attributes atts) {
    }

    private void endProperty() {
        String value = this.popString();
        String key = this.popString();
        DistributedSystemConfig config = (DistributedSystemConfig)this.stack.peek();
        config.addSSLProperty(key, value);
    }

    private void startKey(Attributes atts) {
    }

    private void endKey() {
        String key = this.popString();
        this.stack.push(key);
    }

    private void startValue(Attributes atts) {
    }

    private void endValue() {
        String value = this.popString();
        this.stack.push(value);
    }

    private void startCacheServer(Attributes atts) {
        DistributedSystemConfig config = (DistributedSystemConfig)this.stack.peek();
        CacheServerConfig server = config.createCacheServerConfig();
        this.stack.push(server);
    }

    private void endCacheServer() {
        this.stack.pop();
    }

    private void startClassPath(Attributes atts) {
    }

    private void endClassPath() {
        String classpath = this.popString();
        CacheServerConfig server = (CacheServerConfig)this.stack.peek();
        server.setClassPath(classpath);
    }

    private String popString() {
        Object o = this.stack.pop();
        if (o instanceof StringBuilder) {
            StringBuilder sb = (StringBuilder)o;
            return sb.toString();
        }
        return (String)o;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuilder sb;
        Object top = this.stack.peek();
        if (top instanceof StringBuilder) {
            sb = (StringBuilder)top;
        } else {
            sb = new StringBuilder();
            this.stack.push(sb);
        }
        sb.append(ch, start, length);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    static class DefaultHandlerDelegate
    extends DefaultHandler {
        private final ManagedEntityConfigXmlParser handler;

        public DefaultHandlerDelegate(ManagedEntityConfigXmlParser handler) {
            this.handler = handler;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return this.handler.resolveEntity(publicId, systemId);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.handler.setDocumentLocator(locator);
        }

        @Override
        public void startDocument() throws SAXException {
            this.handler.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.handler.endDocument();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.handler.startPrefixMapping(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.handler.endPrefixMapping(prefix);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.handler.startElement(uri, localName, qName, attributes);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.handler.endElement(uri, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.handler.characters(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.handler.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.handler.processingInstruction(target, data);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.handler.skippedEntity(name);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.handler.warning(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.handler.error(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.handler.fatalError(e);
        }
    }
}

