/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import twitter4j.Twitter;
import twitter4j.auth.AccessToken;
import twitter4j.auth.Authorization;
import twitter4j.auth.AuthorizationFactory;
import twitter4j.auth.OAuthAuthorization;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;

public class TwitterFactory
implements Serializable {
    private static final Constructor<Twitter> TWITTER_CONSTRUCTOR;
    static final Authorization DEFAULT_AUTHORIZATION;
    private static final Twitter SINGLETON;
    private static final long serialVersionUID = -563983536986910054L;
    private final Configuration conf;

    public TwitterFactory() {
        this(ConfigurationContext.getInstance());
    }

    public TwitterFactory(Configuration conf) {
        if (conf == null) {
            throw new NullPointerException("configuration cannot be null");
        }
        this.conf = conf;
    }

    public TwitterFactory(String configTreePath) {
        this(ConfigurationContext.getInstance(configTreePath));
    }

    public Twitter getInstance() {
        return this.getInstance(AuthorizationFactory.getInstance(this.conf));
    }

    public Twitter getInstance(AccessToken accessToken) {
        String consumerKey = this.conf.getOAuthConsumerKey();
        String consumerSecret = this.conf.getOAuthConsumerSecret();
        if (null == consumerKey && null == consumerSecret) {
            throw new IllegalStateException("Consumer key and Consumer secret not supplied.");
        }
        OAuthAuthorization oauth = new OAuthAuthorization(this.conf);
        oauth.setOAuthAccessToken(accessToken);
        return this.getInstance(oauth);
    }

    public Twitter getInstance(Authorization auth) {
        try {
            return TWITTER_CONSTRUCTOR.newInstance(this.conf, auth);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Twitter getSingleton() {
        return SINGLETON;
    }

    static {
        Constructor<?> constructor;
        boolean gaeDetected;
        DEFAULT_AUTHORIZATION = AuthorizationFactory.getInstance(ConfigurationContext.getInstance());
        try {
            Class.forName("com.google.appengine.api.urlfetch.URLFetchService");
            gaeDetected = true;
        }
        catch (ClassNotFoundException cnfe) {
            gaeDetected = false;
        }
        String className = null;
        if (gaeDetected) {
            String APP_ENGINE_TWITTER_IMPL = "twitter4j.AppEngineTwitterImpl";
            try {
                Class.forName("twitter4j.AppEngineTwitterImpl");
                className = "twitter4j.AppEngineTwitterImpl";
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (className == null) {
            className = "twitter4j.TwitterImpl";
        }
        try {
            Class<?> clazz = Class.forName(className);
            constructor = clazz.getDeclaredConstructor(Configuration.class, Authorization.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        TWITTER_CONSTRUCTOR = constructor;
        try {
            SINGLETON = TWITTER_CONSTRUCTOR.newInstance(ConfigurationContext.getInstance(), DEFAULT_AUTHORIZATION);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }
}

