/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.distance;

import org.apache.flink.ml.common.distance.DistanceMeasure;
import org.apache.flink.ml.linalg.BLAS;
import org.apache.flink.ml.linalg.VectorWithNorm;
import org.apache.flink.util.Preconditions;

public class CosineDistanceMeasure
implements DistanceMeasure {
    private static final CosineDistanceMeasure instance = new CosineDistanceMeasure();
    public static final String NAME = "cosine";

    private CosineDistanceMeasure() {
    }

    public static CosineDistanceMeasure getInstance() {
        return instance;
    }

    @Override
    public double distance(VectorWithNorm v1, VectorWithNorm v2) {
        Preconditions.checkArgument((v1.l2Norm > 0.0 && v2.l2Norm > 0.0 ? 1 : 0) != 0, (Object)"Consine distance is not defined for zero-length vectors.");
        return 1.0 - BLAS.dot(v1.vector, v2.vector) / v1.l2Norm / v2.l2Norm;
    }
}

