/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.classification.knn;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.ml.linalg.DenseMatrix;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Matrix;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.typeinfo.DenseMatrixSerializer;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorSerializer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;

public class KnnModelData {
    public DenseMatrix packedFeatures;
    public DenseVector featureNormSquares;
    public DenseVector labels;

    public KnnModelData() {
    }

    public KnnModelData(DenseMatrix packedFeatures, DenseVector featureNormSquares, DenseVector labels) {
        this.packedFeatures = packedFeatures;
        this.featureNormSquares = featureNormSquares;
        this.labels = labels;
    }

    public static DataStream<KnnModelData> getModelDataStream(Table modelDataTable) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelDataTable).getTableEnvironment();
        return tEnv.toDataStream(modelDataTable).map((MapFunction & Serializable)x -> new KnnModelData(((Matrix)x.getField(0)).toDense(), ((Vector)x.getField(1)).toDense(), ((Vector)x.getField(2)).toDense()));
    }

    public static class ModelDataDecoder
    extends SimpleStreamFormat<KnnModelData> {
        public StreamFormat.Reader<KnnModelData> createReader(Configuration config, final FSDataInputStream stream) {
            return new StreamFormat.Reader<KnnModelData>(){
                private final DataInputView source;
                private final DenseVectorSerializer serializer;
                {
                    this.source = new DataInputViewStreamWrapper((InputStream)stream);
                    this.serializer = new DenseVectorSerializer();
                }

                public KnnModelData read() throws IOException {
                    try {
                        DenseMatrix matrix = DenseMatrixSerializer.INSTANCE.deserialize(this.source);
                        DenseVector normSquares = this.serializer.deserialize(this.source);
                        DenseVector labels = this.serializer.deserialize(this.source);
                        return new KnnModelData(matrix, normSquares, labels);
                    }
                    catch (EOFException e) {
                        return null;
                    }
                }

                public void close() throws IOException {
                    stream.close();
                }
            };
        }

        public TypeInformation<KnnModelData> getProducedType() {
            return TypeInformation.of(KnnModelData.class);
        }
    }

    public static class ModelDataEncoder
    implements Encoder<KnnModelData> {
        private final DenseVectorSerializer serializer = new DenseVectorSerializer();

        public void encode(KnnModelData modelData, OutputStream outputStream) throws IOException {
            DataOutputViewStreamWrapper dataOutputView = new DataOutputViewStreamWrapper(outputStream);
            DenseMatrixSerializer.INSTANCE.serialize(modelData.packedFeatures, (DataOutputView)dataOutputView);
            this.serializer.serialize(modelData.featureNormSquares, (DataOutputView)dataOutputView);
            this.serializer.serialize(modelData.labels, (DataOutputView)dataOutputView);
        }
    }
}

