/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.ml.api.AlgoOperator;
import org.apache.flink.ml.api.Estimator;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.builder.Graph;
import org.apache.flink.ml.builder.GraphModel;
import org.apache.flink.ml.builder.GraphNode;
import org.apache.flink.ml.builder.TableId;

@PublicEvolving
public final class GraphBuilder {
    private int maxOutputLength = 20;
    private int nextTableId = 0;
    private int nextNodeId = 0;
    private final List<GraphNode> nodes = new ArrayList<GraphNode>();
    private final Map<Stage<?>, GraphNode> existingNodes = new HashMap();

    public GraphBuilder setMaxOutputTableNum(int maxOutputLength) {
        this.maxOutputLength = maxOutputLength;
        return this;
    }

    public TableId createTableId() {
        return new TableId(this.nextTableId++);
    }

    public TableId[] addAlgoOperator(AlgoOperator<?> algoOp, TableId ... inputs) {
        return this.addStage(algoOp, GraphNode.StageType.ALGO_OPERATOR, null, inputs);
    }

    public TableId[] addEstimator(Estimator<?, ?> estimator, TableId ... inputs) {
        return this.addEstimator(estimator, inputs, inputs);
    }

    public TableId[] addEstimator(Estimator<?, ?> estimator, TableId[] estimatorInputs, TableId[] modelInputs) {
        return this.addStage(estimator, GraphNode.StageType.ESTIMATOR, estimatorInputs, modelInputs);
    }

    public void setModelDataOnEstimator(Estimator<?, ?> estimator, TableId ... inputs) {
        GraphNode node = this.existingNodes.get(estimator);
        if (node == null) {
            throw new RuntimeException("the Estimator has not been added to the graph");
        }
        if (node.stageType != GraphNode.StageType.ESTIMATOR) {
            throw new RuntimeException("the Estimator was previously added as an AlgoOperator");
        }
        if (node.inputModelDataIds != null) {
            throw new RuntimeException("the model data of this Estimator has already been set");
        }
        node.inputModelDataIds = inputs;
    }

    public void setModelDataOnModel(Model<?> model, TableId ... inputs) {
        GraphNode node = this.existingNodes.get(model);
        if (node == null) {
            throw new RuntimeException("the Model has not been added to the graph");
        }
        if (node.stageType != GraphNode.StageType.ALGO_OPERATOR) {
            throw new RuntimeException("the Model was previously added as an Estimator");
        }
        if (node.inputModelDataIds != null) {
            throw new RuntimeException("the model data of this Model has already been set");
        }
        node.inputModelDataIds = inputs;
    }

    public TableId[] getModelDataFromEstimator(Estimator<?, ?> estimator) {
        GraphNode node = this.existingNodes.get(estimator);
        if (node == null) {
            throw new RuntimeException("the Estimator has not been added to the graph");
        }
        if (node.stageType != GraphNode.StageType.ESTIMATOR) {
            throw new RuntimeException("the Estimator was previously added as an AlgoOperator");
        }
        if (node.outputModelDataIds != null) {
            throw new RuntimeException("the model data of this Estimator has already been fetched");
        }
        node.outputModelDataIds = this.createTableIds(this.maxOutputLength);
        return node.outputModelDataIds;
    }

    public TableId[] getModelDataFromModel(Model<?> model) {
        GraphNode node = this.existingNodes.get(model);
        if (node == null) {
            throw new RuntimeException("the Model has not been added to the graph");
        }
        if (node.stageType != GraphNode.StageType.ALGO_OPERATOR) {
            throw new RuntimeException("the Model was previously added as an Estimator");
        }
        if (node.outputModelDataIds != null) {
            throw new RuntimeException("the model data of this Model has already been fetched");
        }
        node.outputModelDataIds = this.createTableIds(this.maxOutputLength);
        return node.outputModelDataIds;
    }

    public Estimator<?, ?> buildEstimator(TableId[] inputs, TableId[] outputs) {
        return this.buildEstimator(inputs, inputs, outputs, null, null);
    }

    public Estimator<?, ?> buildEstimator(TableId[] inputs, TableId[] outputs, TableId[] inputModelData, TableId[] outputModelData) {
        return this.buildEstimator(inputs, inputs, outputs, inputModelData, outputModelData);
    }

    public Estimator<?, ?> buildEstimator(TableId[] estimatorInputs, TableId[] modelInputs, TableId[] outputs, TableId[] inputModelData, TableId[] outputModelData) {
        return new Graph(this.nodes, estimatorInputs, modelInputs, outputs, inputModelData, outputModelData);
    }

    public AlgoOperator<?> buildAlgoOperator(TableId[] inputs, TableId[] outputs) {
        return this.buildModel(inputs, outputs, null, null);
    }

    public Model<?> buildModel(TableId[] inputs, TableId[] outputs) {
        return this.buildModel(inputs, outputs, null, null);
    }

    public Model<?> buildModel(TableId[] inputs, TableId[] outputs, TableId[] inputModelData, TableId[] outputModelData) {
        return new GraphModel(this.nodes, inputs, outputs, inputModelData, outputModelData);
    }

    private TableId[] createTableIds(int count) {
        TableId[] result = new TableId[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.createTableId();
        }
        return result;
    }

    private TableId[] addStage(Stage<?> stage, GraphNode.StageType stageType, TableId[] estimatorInputs, TableId[] modelInputs) {
        TableId[] outputs = this.createTableIds(this.maxOutputLength);
        if (this.existingNodes.containsKey(stage)) {
            throw new RuntimeException("The stage " + stage + " has already been added.");
        }
        GraphNode node = new GraphNode(this.nextNodeId++, stage, stageType, estimatorInputs, modelInputs, outputs, null, null);
        this.nodes.add(node);
        this.existingNodes.put(stage, node);
        return outputs;
    }
}

