/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.httpfn;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.statefun.flink.core.httpfn.TargetFunctions;
import org.apache.flink.statefun.flink.core.httpfn.TransportClientConstants;
import org.apache.flink.statefun.flink.core.httpfn.TransportClientSpec;
import org.apache.flink.statefun.flink.core.httpfn.UrlPathTemplate;
import org.apache.flink.statefun.flink.core.httpfn.jsonutils.TargetFunctionsJsonDeserializer;
import org.apache.flink.statefun.flink.core.httpfn.jsonutils.UrlPathTemplateJsonDeserializer;
import org.apache.flink.statefun.sdk.TypeName;

@JsonDeserialize(builder=Builder.class)
public final class HttpFunctionEndpointSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Integer DEFAULT_MAX_NUM_BATCH_REQUESTS = 1000;
    private static final TransportClientSpec DEFAULT_TRANSPORT_CLIENT_SPEC = new TransportClientSpec(TransportClientConstants.ASYNC_CLIENT_FACTORY_TYPE, new ObjectMapper().createObjectNode());
    private final TargetFunctions targetFunctions;
    private final UrlPathTemplate urlPathTemplate;
    private final int maxNumBatchRequests;
    private final TypeName transportClientFactoryType;
    private final ObjectNode transportClientProps;

    public static Builder builder(TargetFunctions targetFunctions, UrlPathTemplate urlPathTemplate) {
        return new Builder(targetFunctions, urlPathTemplate);
    }

    private HttpFunctionEndpointSpec(TargetFunctions targetFunctions, UrlPathTemplate urlPathTemplate, int maxNumBatchRequests, TypeName transportClientFactoryType, ObjectNode transportClientProps) {
        this.targetFunctions = targetFunctions;
        this.urlPathTemplate = urlPathTemplate;
        this.maxNumBatchRequests = maxNumBatchRequests;
        this.transportClientFactoryType = transportClientFactoryType;
        this.transportClientProps = transportClientProps;
    }

    public TargetFunctions targetFunctions() {
        return this.targetFunctions;
    }

    public UrlPathTemplate urlPathTemplate() {
        return this.urlPathTemplate;
    }

    public int maxNumBatchRequests() {
        return this.maxNumBatchRequests;
    }

    public TypeName transportClientFactoryType() {
        return this.transportClientFactoryType;
    }

    public ObjectNode transportClientProperties() {
        return this.transportClientProps;
    }

    static /* synthetic */ Integer access$100() {
        return DEFAULT_MAX_NUM_BATCH_REQUESTS;
    }

    static /* synthetic */ TransportClientSpec access$200() {
        return DEFAULT_TRANSPORT_CLIENT_SPEC;
    }

    @JsonPOJOBuilder
    public static final class Builder {
        private final TargetFunctions targetFunctions;
        private final UrlPathTemplate urlPathTemplate;
        private int maxNumBatchRequests = HttpFunctionEndpointSpec.access$100();
        private TransportClientSpec transportClientSpec = HttpFunctionEndpointSpec.access$200();

        @JsonCreator
        private Builder(@JsonProperty(value="functions") @JsonDeserialize(using=TargetFunctionsJsonDeserializer.class) TargetFunctions targetFunctions, @JsonProperty(value="urlPathTemplate") @JsonDeserialize(using=UrlPathTemplateJsonDeserializer.class) UrlPathTemplate urlPathTemplate) {
            this.targetFunctions = Objects.requireNonNull(targetFunctions);
            this.urlPathTemplate = Objects.requireNonNull(urlPathTemplate);
        }

        @JsonProperty(value="maxNumBatchRequests")
        public Builder withMaxNumBatchRequests(int maxNumBatchRequests) {
            this.maxNumBatchRequests = maxNumBatchRequests;
            return this;
        }

        @JsonProperty(value="transport")
        public Builder withTransport(ObjectNode transportNode) {
            this.withTransport(TransportClientSpec.fromJsonNode(transportNode));
            return this;
        }

        public Builder withTransport(TransportClientSpec transportNode) {
            this.transportClientSpec = Objects.requireNonNull(transportNode);
            return this;
        }

        public HttpFunctionEndpointSpec build() {
            return new HttpFunctionEndpointSpec(this.targetFunctions, this.urlPathTemplate, this.maxNumBatchRequests, this.transportClientSpec.factoryKind(), this.transportClientSpec.specNode());
        }
    }
}

