/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.regression.linearregression;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorSerializer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;

public class LinearRegressionModelData {
    public DenseVector coefficient;

    public LinearRegressionModelData(DenseVector coefficient) {
        this.coefficient = coefficient;
    }

    public LinearRegressionModelData() {
    }

    public static DataStream<LinearRegressionModelData> getModelDataStream(Table modelData) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelData).getTableEnvironment();
        return tEnv.toDataStream(modelData).map((MapFunction & Serializable)x -> new LinearRegressionModelData((DenseVector)x.getField(0)));
    }

    public static class ModelDataDecoder
    extends SimpleStreamFormat<LinearRegressionModelData> {
        public StreamFormat.Reader<LinearRegressionModelData> createReader(Configuration configuration, final FSDataInputStream inputStream) {
            return new StreamFormat.Reader<LinearRegressionModelData>(){
                private final DenseVectorSerializer serializer = new DenseVectorSerializer();

                public LinearRegressionModelData read() throws IOException {
                    try {
                        DenseVector coefficient = this.serializer.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)inputStream));
                        return new LinearRegressionModelData(coefficient);
                    }
                    catch (EOFException e) {
                        return null;
                    }
                }

                public void close() throws IOException {
                    inputStream.close();
                }
            };
        }

        public TypeInformation<LinearRegressionModelData> getProducedType() {
            return TypeInformation.of(LinearRegressionModelData.class);
        }
    }

    public static class ModelDataEncoder
    implements Encoder<LinearRegressionModelData> {
        private final DenseVectorSerializer serializer = new DenseVectorSerializer();

        public void encode(LinearRegressionModelData modelData, OutputStream outputStream) throws IOException {
            this.serializer.serialize(modelData.coefficient, (DataOutputView)new DataOutputViewStreamWrapper(outputStream));
        }
    }
}

