/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator.allround;

import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.operator.allround.AbstractAllRoundWrapperOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.FlinkRuntimeException;

public class OneInputAllRoundWrapperOperator<IN, OUT>
extends AbstractAllRoundWrapperOperator<OUT, OneInputStreamOperator<IN, OUT>>
implements OneInputStreamOperator<IterationRecord<IN>, IterationRecord<OUT>>,
BoundedOneInput {
    private final StreamRecord<IN> reusedInput = new StreamRecord(null, 0L);

    public OneInputAllRoundWrapperOperator(StreamOperatorParameters<IterationRecord<OUT>> parameters, StreamOperatorFactory<OUT> operatorFactory) {
        super(parameters, operatorFactory);
    }

    public void processElement(StreamRecord<IterationRecord<IN>> element) throws Exception {
        switch (((IterationRecord)element.getValue()).getType()) {
            case RECORD: {
                this.reusedInput.replace(((IterationRecord)element.getValue()).getValue(), element.getTimestamp());
                this.setIterationContextRound(((IterationRecord)element.getValue()).getEpoch());
                ((OneInputStreamOperator)this.wrappedOperator).processElement(this.reusedInput);
                this.clearIterationContextRound();
                break;
            }
            case EPOCH_WATERMARK: {
                this.onEpochWatermarkEvent(0, (IterationRecord)element.getValue());
                break;
            }
            default: {
                throw new FlinkRuntimeException("Not supported iteration record type: " + element);
            }
        }
    }

    public void processWatermark(Watermark mark) throws Exception {
        ((OneInputStreamOperator)this.wrappedOperator).processWatermark(mark);
    }

    public void processWatermarkStatus(WatermarkStatus watermarkStatus) throws Exception {
        ((OneInputStreamOperator)this.wrappedOperator).processWatermarkStatus(watermarkStatus);
    }

    public void processLatencyMarker(LatencyMarker latencyMarker) throws Exception {
        ((OneInputStreamOperator)this.wrappedOperator).processLatencyMarker(latencyMarker);
    }

    public void setKeyContextElement(StreamRecord<IterationRecord<IN>> record) throws Exception {
        if (((IterationRecord)record.getValue()).getType() == IterationRecord.Type.RECORD) {
            this.reusedInput.replace(((IterationRecord)record.getValue()).getValue(), record.getTimestamp());
            ((OneInputStreamOperator)this.wrappedOperator).setKeyContextElement(this.reusedInput);
        }
    }

    public void endInput() throws Exception {
        if (this.wrappedOperator instanceof BoundedOneInput) {
            ((BoundedOneInput)this.wrappedOperator).endInput();
        }
    }
}

