/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.translation;

import java.util.Map;
import java.util.Objects;
import org.apache.flink.statefun.flink.core.StatefulFunctionsUniverse;
import org.apache.flink.statefun.flink.core.common.Maps;
import org.apache.flink.statefun.flink.core.translation.DecoratedSink;
import org.apache.flink.statefun.flink.io.spi.SinkProvider;
import org.apache.flink.statefun.sdk.io.EgressIdentifier;
import org.apache.flink.statefun.sdk.io.EgressSpec;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;

final class EgressToSinkTranslator {
    private final StatefulFunctionsUniverse universe;

    EgressToSinkTranslator(StatefulFunctionsUniverse universe) {
        this.universe = Objects.requireNonNull(universe);
    }

    Map<EgressIdentifier<?>, DecoratedSink> translate() {
        return Maps.transformValues(this.universe.egress(), this::sinkFromSpec);
    }

    private DecoratedSink sinkFromSpec(EgressIdentifier<?> key, EgressSpec<?> spec) {
        SinkProvider provider = this.universe.sinks().get(spec.type());
        if (provider == null) {
            throw new IllegalStateException("Unable to find a sink translation for egress of type " + spec.type() + ", which is bound for key " + key);
        }
        SinkFunction sink = provider.forSpec(spec);
        if (sink == null) {
            throw new NullPointerException("A sink provider for type " + spec.type() + ", has produced a NULL sink.");
        }
        return DecoratedSink.of(spec, sink);
    }
}

