/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.state;

import java.util.Objects;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.statefun.flink.core.common.KeyBy;
import org.apache.flink.statefun.flink.core.di.Inject;
import org.apache.flink.statefun.flink.core.di.Label;
import org.apache.flink.statefun.flink.core.state.ExpirationUtil;
import org.apache.flink.statefun.flink.core.state.FlinkAppendingBufferAccessor;
import org.apache.flink.statefun.flink.core.state.FlinkTableAccessor;
import org.apache.flink.statefun.flink.core.state.FlinkValueAccessor;
import org.apache.flink.statefun.flink.core.state.State;
import org.apache.flink.statefun.flink.core.types.DynamicallyRegisteredTypes;
import org.apache.flink.statefun.flink.core.types.remote.RemoteValueTypeInfo;
import org.apache.flink.statefun.sdk.Address;
import org.apache.flink.statefun.sdk.FunctionType;
import org.apache.flink.statefun.sdk.state.Accessor;
import org.apache.flink.statefun.sdk.state.AppendingBufferAccessor;
import org.apache.flink.statefun.sdk.state.PersistedAppendingBuffer;
import org.apache.flink.statefun.sdk.state.PersistedTable;
import org.apache.flink.statefun.sdk.state.PersistedValue;
import org.apache.flink.statefun.sdk.state.RemotePersistedValue;
import org.apache.flink.statefun.sdk.state.TableAccessor;

public final class FlinkState
implements State {
    private final RuntimeContext runtimeContext;
    private final KeyedStateBackend<Object> keyedStateBackend;
    private final DynamicallyRegisteredTypes types;

    @Inject
    public FlinkState(@Label(value="runtime-context") RuntimeContext runtimeContext, @Label(value="keyed-state-backend") KeyedStateBackend<Object> keyedStateBackend, DynamicallyRegisteredTypes types) {
        this.runtimeContext = Objects.requireNonNull(runtimeContext);
        this.keyedStateBackend = Objects.requireNonNull(keyedStateBackend);
        this.types = Objects.requireNonNull(types);
    }

    @Override
    public <T> Accessor<T> createFlinkStateAccessor(FunctionType functionType, PersistedValue<T> persistedValue) {
        TypeInformation typeInfo = this.types.registerType(persistedValue.type());
        String stateName = FlinkState.flinkStateName(functionType, persistedValue.name());
        ValueStateDescriptor descriptor = new ValueStateDescriptor(stateName, typeInfo);
        ExpirationUtil.configureStateTtl(descriptor, persistedValue.expiration());
        ValueState handle = this.runtimeContext.getState(descriptor);
        return new FlinkValueAccessor(handle);
    }

    @Override
    public <K, V> TableAccessor<K, V> createFlinkStateTableAccessor(FunctionType functionType, PersistedTable<K, V> persistedTable) {
        MapStateDescriptor descriptor = new MapStateDescriptor(FlinkState.flinkStateName(functionType, persistedTable.name()), this.types.registerType(persistedTable.keyType()), this.types.registerType(persistedTable.valueType()));
        ExpirationUtil.configureStateTtl(descriptor, persistedTable.expiration());
        MapState handle = this.runtimeContext.getMapState(descriptor);
        return new FlinkTableAccessor(handle);
    }

    @Override
    public <E> AppendingBufferAccessor<E> createFlinkStateAppendingBufferAccessor(FunctionType functionType, PersistedAppendingBuffer<E> persistedAppendingBuffer) {
        ListStateDescriptor descriptor = new ListStateDescriptor(FlinkState.flinkStateName(functionType, persistedAppendingBuffer.name()), this.types.registerType(persistedAppendingBuffer.elementType()));
        ExpirationUtil.configureStateTtl(descriptor, persistedAppendingBuffer.expiration());
        ListState handle = this.runtimeContext.getListState(descriptor);
        return new FlinkAppendingBufferAccessor(handle);
    }

    @Override
    public Accessor<byte[]> createFlinkRemoteStateAccessor(FunctionType functionType, RemotePersistedValue remotePersistedValue) {
        RemoteValueTypeInfo typeInfo = new RemoteValueTypeInfo(remotePersistedValue.type());
        String stateName = FlinkState.flinkStateName(functionType, remotePersistedValue.name());
        ValueStateDescriptor descriptor = new ValueStateDescriptor(stateName, (TypeInformation)typeInfo);
        ExpirationUtil.configureStateTtl(descriptor, remotePersistedValue.expiration());
        ValueState handle = this.runtimeContext.getState(descriptor);
        return new FlinkValueAccessor<byte[]>(handle);
    }

    @Override
    public void setCurrentKey(Address address) {
        this.keyedStateBackend.setCurrentKey((Object)KeyBy.apply(address));
    }

    public static String flinkStateName(FunctionType functionType, String name) {
        return String.format("%s.%s.%s", functionType.namespace(), functionType.name(), name);
    }
}

