/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.bundle;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.runtime.context.ExecutionContextImpl;
import org.apache.flink.table.runtime.operators.bundle.MapBundleFunction;
import org.apache.flink.table.runtime.operators.bundle.trigger.BundleTrigger;
import org.apache.flink.table.runtime.operators.bundle.trigger.BundleTriggerCallback;
import org.apache.flink.table.runtime.util.StreamRecordCollector;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public abstract class AbstractMapBundleOperator<K, V, IN, OUT>
extends AbstractStreamOperator<OUT>
implements OneInputStreamOperator<IN, OUT>,
BundleTriggerCallback {
    private static final long serialVersionUID = 5081841938324118594L;
    private transient Map<K, V> bundle;
    private final BundleTrigger<IN> bundleTrigger;
    private final MapBundleFunction<K, V, IN, OUT> function;
    private transient Collector<OUT> collector;
    private transient int numOfElements = 0;

    AbstractMapBundleOperator(MapBundleFunction<K, V, IN, OUT> function, BundleTrigger<IN> bundleTrigger) {
        this.chainingStrategy = ChainingStrategy.ALWAYS;
        this.function = (MapBundleFunction)Preconditions.checkNotNull(function, (String)"function is null");
        this.bundleTrigger = (BundleTrigger)Preconditions.checkNotNull(bundleTrigger, (String)"bundleTrigger is null");
    }

    public void open() throws Exception {
        super.open();
        this.function.open(new ExecutionContextImpl(this, (RuntimeContext)this.getRuntimeContext()));
        this.numOfElements = 0;
        this.collector = new StreamRecordCollector<OUT>(this.output);
        this.bundle = new HashMap();
        this.bundleTrigger.registerCallback(this);
        this.bundleTrigger.reset();
        LOG.info("BundleOperator's trigger info: " + this.bundleTrigger.explain());
        this.getRuntimeContext().getMetricGroup().gauge("bundleSize", () -> this.numOfElements);
        this.getRuntimeContext().getMetricGroup().gauge("bundleRatio", () -> {
            int numOfKeys = this.bundle.size();
            if (numOfKeys == 0) {
                return 0.0;
            }
            return 1.0 * (double)this.numOfElements / (double)numOfKeys;
        });
    }

    public void processElement(StreamRecord<IN> element) throws Exception {
        Object input = element.getValue();
        K bundleKey = this.getKey(input);
        V bundleValue = this.bundle.get(bundleKey);
        V newBundleValue = this.function.addInput(bundleValue, input);
        this.bundle.put(bundleKey, newBundleValue);
        ++this.numOfElements;
        this.bundleTrigger.onElement(input);
    }

    protected abstract K getKey(IN var1) throws Exception;

    @Override
    public void finishBundle() throws Exception {
        if (this.bundle != null && !this.bundle.isEmpty()) {
            this.numOfElements = 0;
            this.function.finishBundle(this.bundle, this.collector);
            this.bundle.clear();
        }
        this.bundleTrigger.reset();
    }

    public void processWatermark(Watermark mark) throws Exception {
        this.finishBundle();
        super.processWatermark(mark);
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        this.finishBundle();
    }

    public void finish() throws Exception {
        this.finishBundle();
        super.finish();
    }

    public void close() throws Exception {
        Exception exception = null;
        try {
            super.close();
            if (this.function != null) {
                FunctionUtils.closeFunction(this.function);
            }
        }
        catch (InterruptedException interrupted) {
            exception = interrupted;
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception != null) {
            LOG.warn("Errors occurred while closing the BundleOperator.", (Throwable)exception);
        }
    }
}

