/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.mxml;

import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.flex.compiler.internal.resourcebundles.ResourceBundleUtils;
import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLCompilerDirectiveNodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLFileNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.flex.compiler.mxml.IMXMLTagData;
import org.apache.flex.compiler.problems.CompilerProblem;
import org.apache.flex.compiler.problems.ResourceBundleNoBundleParameterProblem;
import org.apache.flex.compiler.problems.ResourceBundleNoKeyParameterProblem;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IFileNodeAccumulator;
import org.apache.flex.compiler.tree.mxml.IMXMLResourceNode;

class MXMLResourceNode
extends MXMLCompilerDirectiveNodeBase
implements IMXMLResourceNode {
    private String bundleName;
    private String key;
    private ITypeDefinition type;

    MXMLResourceNode(NodeBase parent, ITypeDefinition type) {
        super(parent);
        this.type = type;
    }

    @Override
    public String getBundleName() {
        return this.bundleName;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public ITypeDefinition getType() {
        return this.type;
    }

    @Override
    public void initializeFromText(MXMLTreeBuilder builder, String text, ISourceLocation location) {
        MXMLFileNode fileNode;
        this.parseTextAndSetAttributes(builder, text, location, "Resource");
        this.setSourceLocation(location);
        for (IMetaTagAttribute attr : this.attributes) {
            if ("bundle".equals(attr.getKey())) {
                this.bundleName = attr.getValue();
                continue;
            }
            if (!"key".equals(attr.getKey())) continue;
            this.key = attr.getValue();
        }
        if (this.key != null && this.bundleName == null) {
            this.bundleName = ResourceBundleUtils.convertBundleNameToColonSyntax(this.getClassDefinitionNode().getQualifiedName());
        }
        if (this.bundleName != null && (fileNode = builder.getFileNode()) instanceof IFileNodeAccumulator) {
            ((IFileNodeAccumulator)fileNode).addRequiredResourceBundle(this.bundleName);
        }
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLResourceID;
    }

    @Override
    public String getName() {
        return "Resource";
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        CompilerProblem problem;
        super.initializationComplete(builder, tag, info);
        if (this.key == null) {
            problem = new ResourceBundleNoKeyParameterProblem(this);
            builder.addProblem(problem);
        }
        if (this.bundleName == null) {
            problem = new ResourceBundleNoBundleParameterProblem(this);
            builder.addProblem(problem);
        }
    }
}

