/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package adobe.abc;

import adobe.abc.GlobalOptimizer.Metadata;

public interface OptimizerConstants 
{
	static final Expr[] noexprs = new Expr[] {};
	static final Edge[] noedges = new Edge[] {};
	static final Handler[] nohandlers = new Handler[] {};
	static Type[] notypes = new Type[] {};
	static Typeref[] notyperefs = new Typeref[] {};
	static final Metadata[] nometadata = new Metadata[0];
	
	static final Object UNDEFINED = new Object() { public String toString() { return "undefined"; }};
	static final Object BOTTOM = new Object() { public String toString() { return "?"; }};
	static final Double NAN = Double.NaN;

	int OP_arg = 0x00; // argument provided by the vm in a pre-assigned local var.
    int OP_phi = 0x0a; // compiler only
    int OP_xarg = 0x0b; // represents the exception object passed to catch
    int OP_hasnext2_i = 0x33; // hasnext2 index
    int OP_hasnext2_o = 0x34; // hasnext2 object
    
    final static int CTYPE_VOID			= 0;
	final static int CTYPE_ATOM			= 1;
	final static int CTYPE_BOOLEAN		= 2;
	final static int CTYPE_INT			= 3;
	final static int CTYPE_UINT			= 4;
	final static int CTYPE_DOUBLE		= 5;
	final static int CTYPE_STRING		= 6;
	final static int CTYPE_NAMESPACE	= 7;
	final static int CTYPE_OBJECT		= 8;

	public static final int OPER=1;
	public static final int EFFECT=2; // has data side effects. 
	public static final int COERCE=4; // coerce or one of its shorthands
	public static final int PX=8; // potential exception
	public static final int SYNTH=0x10; //synthetic opcode, not to appear in a real abc 
	public static final int SCPVAL=0x20; // produces value on scope stack
	public static final int STKVAL=0x40; // produces value on stack
	public static final int LOCVAL=0x80; // produces result in a local variable
	
	static int[] flagTable = new int[] {
		LOCVAL|SYNTH,//"arg",
	    EFFECT,//"bkpt",
	    0,//"nop",
	    PX,//"throw",
	    STKVAL|EFFECT|PX,//"getsuper",
	    EFFECT|PX,//"setsuper",
	    EFFECT|PX,//"dxns",
	    EFFECT|PX,//"dxnslate",
	    LOCVAL|EFFECT,//"kill",
	    EFFECT,//"label",
	    SYNTH,//"phi",
	    STKVAL|SYNTH,//"xarg",
	    EFFECT|PX,//"ifnlt",
	    EFFECT|PX,//"ifnle",
	    EFFECT|PX,//"ifngt",
	    EFFECT|PX,//"ifnge",
	    EFFECT,//"jump",
	    EFFECT,//"iftrue",
	    EFFECT,//"iffalse",
	    EFFECT|PX,//"ifeq",
	    EFFECT|PX,//"ifne",
	    EFFECT|PX,//"iflt",
	    EFFECT|PX,//"ifle",
	    EFFECT|PX,//"ifgt",
	    EFFECT|PX,//"ifge",
	    EFFECT,//"ifstricteq",
	    EFFECT,//"ifstrictne",
	    EFFECT|PX,//"lookupswitch",
	    PX|SCPVAL|EFFECT,//"pushwith",
	    EFFECT,//"popscope",
	    STKVAL|PX,//"nextname",
	    STKVAL|PX,//"hasnext",
	    STKVAL,//"pushnull",
	    STKVAL,//"pushundefined",
	    0,//"OP_0x22",
	    STKVAL|PX,//"nextvalue",
	    STKVAL,//"pushbyte",
	    STKVAL,//"pushshort",
	    STKVAL,//"pushtrue",
	    STKVAL,//"pushfalse",
	    STKVAL,//"pushnan",
	    EFFECT,//"pop",
	    STKVAL|EFFECT,//"dup",
	    EFFECT,//"swap",
	    STKVAL,//"pushstring",
	    STKVAL,//"pushint",
	    STKVAL,//"pushuint",
	    STKVAL,//"pushdouble",
	    PX|SCPVAL|EFFECT,//"pushscope",
	    STKVAL,//"pushnamespace",
	    STKVAL|PX,//"hasnext2",
	    LOCVAL|SYNTH,//"hasnext2_i",
	    LOCVAL|SYNTH,//"hasnext2_o",
	    0,//"OP_0x35",
	    0,//"OP_0x36",
	    0,//"OP_0x37",
	    0,//"OP_0x38",
	    0,//"OP_0x39",
	    0,//"OP_0x3A",
	    0,//"OP_0x3B",
	    0,//"OP_0x3C",
	    0,//"OP_0x3D",
	    0,//"OP_0x3E",
	    0,//"OP_0x3F",
	    STKVAL,//"newfunction",
	    STKVAL|EFFECT|PX,//"call",
	    STKVAL|EFFECT|PX,//"construct",
	    STKVAL|EFFECT|PX,//"callmethod",
	    STKVAL|EFFECT|PX,//"callstatic",
	    STKVAL|EFFECT|PX,//"callsuper",
	    STKVAL|EFFECT|PX,//"callproperty",
	    EFFECT|PX,//"returnvoid",
	    EFFECT|PX,//"returnvalue",
	    EFFECT|PX,//"constructsuper",
	    STKVAL|EFFECT|PX,//"constructprop",
	    0,//"0x4b
	    STKVAL|EFFECT|PX,//"callproplex",
	    0,//"0x4d
	    EFFECT|PX,// "callsupervoid",
	    EFFECT|PX,// "callpropvoid",
	    0,//"OP_0x50",
	    0,//"OP_0x51",
	    0,//"OP_0x52",
	    STKVAL|EFFECT|PX,//"applytype",
	    0,//"OP_0x54",
	    STKVAL,//"newobject",
	    STKVAL,// "newarray",
	    STKVAL,// "newactivation",
	    STKVAL|EFFECT|PX,//  "newclass",
	    STKVAL|PX,//  "getdescendants",
	    STKVAL,//   "newcatch",
	    0,//   "OP_0x5B",
	    0,//   "OP_0x5C",
	    /*EFFECT|*/STKVAL|PX,//   "findpropstrict",
	    STKVAL|EFFECT|PX,//   "findproperty",
	    STKVAL,//   "finddef",  add EFFECT|PX if we care about script loading side effects.
	    STKVAL|EFFECT|PX,//   "getlex",
	    EFFECT|PX,//   "setproperty",
	    STKVAL|EFFECT,//   "getlocal",
	    EFFECT,//   "setlocal",
	    STKVAL,//   "getglobalscope",
	    STKVAL,//   "getscopeobject",
	    STKVAL|EFFECT|PX,//   "getproperty",
	    0,//   "OP_0x67",
	    EFFECT|PX,//   "initproperty",
	    0,//   "OP_0x69",
	    STKVAL|EFFECT|PX,//    "deleteproperty",
	    0,//    "OP_0x6B",
	    STKVAL|PX,//    "getslot"
	    EFFECT|PX,//    "setslot",
	    STKVAL|PX,//   "getglobalslot",
	    EFFECT|PX,//   "setglobalslot",
	    OPER|STKVAL|EFFECT|PX,//   "convert_s",
	    OPER|STKVAL|EFFECT|PX,//   "esc_xelem",
	    OPER|STKVAL|EFFECT|PX,//    "esc_xattr",
	    OPER|STKVAL|EFFECT|PX,//    "convert_i",
	    OPER|STKVAL|EFFECT|PX,//    "convert_u",
	    OPER|STKVAL|EFFECT|PX,//    "convert_d",
	    OPER|STKVAL,//    "convert_b",
	    OPER|STKVAL|PX,//    "convert_o", aka null check
	    PX,//    "checkfilter",
	    0,//    "OP_0x79",
	    0,//    "OP_0x7A",
	    0,//    "OP_0x7B",
	    0,//    "OP_0x7C",
	    0,//    "OP_0x7D",
	    0,//    "OP_0x7E",
	    0,//    "OP_0x7F",
	    OPER|STKVAL|EFFECT|PX|COERCE,//    "coerce",
	    OPER|STKVAL|COERCE,//    "coerce_b",
	    OPER|STKVAL|COERCE,//    "coerce_a",
	    OPER|STKVAL|EFFECT|PX|COERCE,//    "coerce_i",
	    OPER|STKVAL|EFFECT|PX|COERCE,//    "coerce_d",
	    OPER|STKVAL|EFFECT|PX|COERCE,//    "coerce_s",
	    OPER|STKVAL|EFFECT|PX,//    "astype",
	    OPER|STKVAL|EFFECT|PX,//    "astypelate",
	    OPER|STKVAL|EFFECT|PX|COERCE,//    "coerce_u",
	    OPER|STKVAL|PX|COERCE,//    "coerce_o",
	    0,//    "OP_0x8A",
	    0,//    "OP_0x8B",
	    0,//    "OP_0x8C",
	    0,//    "OP_0x8D",
	    0,//    "OP_0x8E",
	    0,//    "OP_0x8F",
	    OPER|STKVAL|EFFECT|PX,//    "negate",
	    OPER|STKVAL|EFFECT|PX,//  "increment",
	    OPER|LOCVAL|EFFECT|PX,//  "inclocal",
	    OPER|STKVAL|EFFECT|PX,//  "decrement",
	    OPER|LOCVAL|EFFECT|PX,//   "declocal",
	    OPER|STKVAL,//   "typeof",
	    OPER|STKVAL,//   "not",
	    OPER|STKVAL|EFFECT|PX,//   "bitnot",
	    0,//    "OP_0x98",
	    0,//    "OP_0x99",
	    0,//    "OP_0x9A",
	    0,//    "OP_0x9B",
	    0,//    "OP_0x9C",
	    0,//    "OP_0x9D",
	    0,//    "OP_0x9E",
	    0,//    "OP_0x9F",
	    OPER|STKVAL|EFFECT|PX,//    "add",
	    OPER|STKVAL|EFFECT|PX,//    "subtract",
	    OPER|STKVAL|EFFECT|PX,//    "multiply",
	    OPER|STKVAL|EFFECT|PX,//    "divide",
	    OPER|STKVAL|EFFECT|PX,//   "modulo",
	    OPER|STKVAL|EFFECT|PX,//   "lshift",
	    OPER|STKVAL|EFFECT|PX,//   "rshift",
	    OPER|STKVAL|EFFECT|PX,//   "urshift",
	    OPER|STKVAL|EFFECT|PX,//   "bitand",
	    OPER|STKVAL|EFFECT|PX,//    "bitor",
	    OPER|STKVAL|EFFECT|PX,//    "bitxor",
	    OPER|STKVAL|EFFECT|PX,//    "equals",
	    OPER|STKVAL,//    "strictequals",
	    OPER|STKVAL|EFFECT|PX,//    "lessthan",
	    OPER|STKVAL|EFFECT|PX,//    "lessequals",
	    OPER|STKVAL|EFFECT|PX,//    "greaterthan",
	    OPER|STKVAL|EFFECT|PX,//    "greaterequals",
	    OPER|STKVAL|EFFECT|PX,//   "instanceof",
	    OPER|STKVAL|EFFECT|PX,//   "istype", (pure if type is known)
	    OPER|STKVAL|PX,//   "istypelate", (pure if rhs is Class)
	    OPER|STKVAL|PX,//    "in",
	    0,//    "OP_0xB5",
	    0,//    "OP_0xB6",
	    0,//    "OP_0xB7",
	    0,//    "OP_0xB8",
	    0,//    "OP_0xB9",
	    0,//    "OP_0xBA",
	    0,//    "OP_0xBB",
	    0,//    "OP_0xBC",
	    0,//    "OP_0xBD",
	    0,//    "OP_0xBE",
	    0,//    "OP_0xBF",
	    OPER|STKVAL|EFFECT|PX,//    "increment_i",
	    OPER|STKVAL|EFFECT|PX,//    "decrement_i",
	    OPER|LOCVAL|EFFECT|PX,//    "inclocal_i",
	    OPER|LOCVAL|EFFECT|PX,//    "declocal_i",
	    OPER|STKVAL|EFFECT|PX,//    "negate_i",
	    OPER|STKVAL|EFFECT|PX,//    "add_i",
	    OPER|STKVAL|EFFECT|PX,//    "subtract_i",
	    OPER|STKVAL|EFFECT|PX,//    "multiply_i",
	    0,//    "OP_0xC8",
	    0,//    "OP_0xC9",
	    0,//    "OP_0xCA",
	    0,//    "OP_0xCB",
	    0,//    "OP_0xCC",
	    0,//    "OP_0xCD",
	    0,//    "OP_0xCE",
	    0,//    "OP_0xCF",
	    STKVAL|EFFECT,//    "getlocal0",
	    STKVAL|EFFECT,//    "getlocal1",
	    STKVAL|EFFECT,//    "getlocal2",
	    STKVAL|EFFECT,//    "getlocal3",
	    EFFECT,//    "setlocal0",
	    EFFECT,//    "setlocal1",
	    EFFECT,//    "setlocal2",
	    EFFECT,//    "setlocal3",
	    0,//    "OP_0xD8",
	    0,//    "OP_0xD9",
	    0,//   "OP_0xDA",
	    0,//   "OP_0xDB",
	    0,//   "OP_0xDC",
	    0,//   "OP_0xDD",
	    0,//   "OP_0xDE",
	    0,//  "OP_0xDF",
	    0,//   "OP_0xE0",
	    0,//  "OP_0xE1",
	    0,//   "OP_0xE2",
	    0,//  "OP_0xE3",
	    0,//    "OP_0xE4",
	    0,//    "OP_0xE5",
	    0,//    "OP_0xE6",
	    0,//    "OP_0xE7",
	    0,//    "OP_0xE8",
	    0,//    "OP_0xE9",
	    0,//    "OP_0xEA",
	    0,//    "OP_0xEB",
	    0,//    "OP_0xEC",
	    0,//    "OP_0xED",
	    SYNTH,//    "abs_jump",
	    EFFECT,//    "debug",
	    EFFECT,//    "debugline",
	    EFFECT,//    "debugfile",
	    EFFECT,//    "bkptline",
	    SYNTH,//    "timestamp",
	    0,//    "OP_0xF4",
	    SYNTH,//    "verifypass",
	    SYNTH,//    "alloc",
	    SYNTH,//    "mark",
	    SYNTH,//    "wb",
	    SYNTH,//    "prologue",
	    SYNTH,//    "sendenter",
	    SYNTH,//   "doubletoatom",
	    SYNTH,//   "sweep",
	    SYNTH,//   "codegenop",
	    SYNTH,//   "verifyop",
	    SYNTH,//   "decode"
	};
	static String[] opNames =
	{
    "arg",		// synthetic
    "bkpt",
    "nop",
    "throw",
    "getsuper",
    "setsuper",
    "dxns",
    "dxnslate",
    "kill",
    "label",
    "phi",//"\u0278",//"\u03d5",//"\u03c6",//"&Phi;",		// synthetic
    //"\u0278",//"\u03d5",//"\u03c6",//"&Phi;",		// synthetic
    "xarg",		// synthetic
    "ifnlt",
    "ifnle",
    "ifngt",
    "ifnge",
    "jump",
    "iftrue",
    "iffalse",
    "ifeq",
    "ifne",
    "iflt",
    "ifle",
    "ifgt",
    "ifge",
    "ifstricteq",
    "ifstrictne",
    "lookupswitch",
    "pushwith",
    "popscope",
    "nextname",
    "hasnext",
    "pushnull",
    "pushundefined",
    "OP_0x22",
    "nextvalue",
    "pushbyte",
    "pushshort",
    "pushtrue",
    "pushfalse",
    "pushnan",
    "pop",
    "dup",
    "swap",
    "pushstring",
    "pushint",
    "pushuint",
    "pushdouble",
    "pushscope",
    "pushnamespace",
    "hasnext2",
    "hasnext2_i",
    "hasnext2_o",
    "OP_0x35",
    "OP_0x36",
    "OP_0x37",
    "OP_0x38",
    "OP_0x39",
    "OP_0x3A",
    "OP_0x3B",
    "OP_0x3C",
    "OP_0x3D",
    "OP_0x3E",
    "OP_0x3F",
    "newfunction",
    "call",
    "construct",
    "callmethod",
    "callstatic",
    "callsuper",
    "callproperty",
    "returnvoid",
    "returnvalue",
    "constructsuper",
    "constructprop",
    "OP_0x4B",
    "callproplex",
    "OP_0x4D",
    "callsupervoid",
    "callpropvoid",
    "OP_0x50",
    "OP_0x51",
    "OP_0x52",
    "applytype",
    "OP_0x54",
    "newobject",
    "newarray",
    "newactivation",
    "newclass",
    "getdescendants",
    "newcatch",
    "OP_0x5B",
    "OP_0x5C",
    "findpropstrict",
    "findproperty",
    "finddef",
    "getlex",
    "setproperty",
    "getlocal",
    "setlocal",
    "getglobalscope",
    "getscopeobject",
    "getproperty",
    "OP_0x67",
    "initproperty",
    "OP_0x69",
    "deleteproperty",
    "OP_0x6B",
    "getslot",
    "setslot",
    "getglobalslot",
    "setglobalslot",
    "convert_s",
    "esc_xelem",
    "esc_xattr",
    "convert_i",
    "convert_u",
    "convert_d",
    "convert_b",
    "convert_o",
    "checkfilter",
    "OP_0x79",
    "OP_0x7A",
    "OP_0x7B",
    "OP_0x7C",
    "OP_0x7D",
    "OP_0x7E",
    "OP_0x7F",
    "coerce",
    "coerce_b",
    "coerce_a",
    "coerce_i",
    "coerce_d",
    "coerce_s",
    "astype",
    "astypelate",
    "coerce_u",
    "coerce_o",
    "OP_0x8A",
    "OP_0x8B",
    "OP_0x8C",
    "OP_0x8D",
    "OP_0x8E",
    "OP_0x8F",
    "negate",
    "increment",
    "inclocal",
    "decrement",
    "declocal",
    "typeof",
    "not",
    "bitnot",
    "OP_0x98",
    "OP_0x99",
    "OP_0x9A",
    "OP_0x9B",
    "OP_0x9C",
    "OP_0x9D",
    "OP_0x9E",
    "OP_0x9F",
    "add",
    "subtract",
    "multiply",
    "divide",
    "modulo",
    "lshift",
    "rshift",
    "urshift",
    "bitand",
    "bitor",
    "bitxor",
    "equals",
    "strictequals",
    "lessthan",
    "lessequals",
    "greaterthan",
    "greaterequals",
    "instanceof",
    "istype",
    "istypelate",
    "in",
    "OP_0xB5",
    "OP_0xB6",
    "OP_0xB7",
    "OP_0xB8",
    "OP_0xB9",
    "OP_0xBA",
    "OP_0xBB",
    "OP_0xBC",
    "OP_0xBD",
    "OP_0xBE",
    "OP_0xBF",
    "increment_i",
    "decrement_i",
    "inclocal_i",
    "declocal_i",
    "negate_i",
    "add_i",
    "subtract_i",
    "multiply_i",
    "OP_0xC8",
    "OP_0xC9",
    "OP_0xCA",
    "OP_0xCB",
    "OP_0xCC",
    "OP_0xCD",
    "OP_0xCE",
    "OP_0xCF",
    "getlocal0",
    "getlocal1",
    "getlocal2",
    "getlocal3",
    "setlocal0",
    "setlocal1",
    "setlocal2",
    "setlocal3",
    "OP_0xD8",
    "OP_0xD9",
    "OP_0xDA",
    "OP_0xDB",
    "OP_0xDC",
    "OP_0xDD",
    "OP_0xDE",
    "OP_0xDF",
    "OP_0xE0",
    "OP_0xE1",
    "OP_0xE2",
    "OP_0xE3",
    "OP_0xE4",
    "OP_0xE5",
    "OP_0xE6",
    "OP_0xE7",
    "OP_0xE8",
    "OP_0xE9",
    "OP_0xEA",
    "OP_0xEB",
    "OP_0xEC",
    "OP_0xED",
    "OP_0xEE",
    "debug",
    "debugline",
    "debugfile",
    "bkptline",
    "timestamp",
    "OP_0xF4",
    "OP_0xF5",
    "OP_0xF6",
    "OP_0xF7",
    "OP_0xF8",
    "OP_0xF9",
    "OP_0xFA",
    "OP_0xFB",
    "OP_0xFC",
    "OP_0xFD",
    "OP_0xFE",
    "OP_0xFF"
	};
}
