/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.junit4osgi.command;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import junit.framework.AssertionFailedError;
import junit.framework.Test;

public class ResultTableModel
extends AbstractTableModel {
    public static final String SUCCESS = "success";
    public static final String FAILURE = "failure";
    public static final String ERROR = "error";
    private static final long serialVersionUID = 1L;
    private List<TestRecord> m_results = new ArrayList<TestRecord>();

    public int getRowCount() {
        return this.m_results.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public void addTest(Test t, AssertionFailedError e) {
        TestRecord rec = new TestRecord(t, e);
        this.m_results.add(rec);
        this.fireTableDataChanged();
    }

    public void addTest(Test t, Throwable e) {
        TestRecord rec = new TestRecord(t, e);
        this.m_results.add(rec);
        this.fireTableDataChanged();
    }

    public void addTest(Test t) {
        if (!this.contains(t)) {
            TestRecord rec = new TestRecord(t);
            this.m_results.add(rec);
            this.fireTableDataChanged();
        }
    }

    public int getTestCount() {
        return this.m_results.size();
    }

    public int getSucess() {
        int count = 0;
        for (TestRecord test : this.m_results) {
            if (!test.m_wasSucessFull) continue;
            ++count;
        }
        return count;
    }

    public int getErrors() {
        int count = 0;
        for (TestRecord test : this.m_results) {
            if (test.m_error == null) continue;
            ++count;
        }
        return count;
    }

    public int getFailures() {
        int count = 0;
        for (TestRecord test : this.m_results) {
            if (test.m_failure == null) continue;
            ++count;
        }
        return count;
    }

    private boolean contains(Test t) {
        for (TestRecord test : this.m_results) {
            if (!test.m_test.equals(t)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.m_results.clear();
        this.fireTableDataChanged();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.m_results.get(rowIndex).m_test;
        }
        if (columnIndex == 1) {
            TestRecord tr = this.m_results.get(rowIndex);
            if (tr.m_wasSucessFull) {
                return SUCCESS;
            }
            if (tr.m_failure != null) {
                return FAILURE;
            }
            if (tr.m_error != null) {
                return ERROR;
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Test";
        }
        if (column == 1) {
            return "Status";
        }
        return null;
    }

    public String getMessage(int row, int column) {
        if (row == -1) {
            return null;
        }
        TestRecord rec = this.m_results.get(row);
        if (rec.m_wasSucessFull) {
            return "The test " + rec.m_test + " was executed sucessfully.";
        }
        if (rec.m_failure != null) {
            return "The test " + rec.m_test + " has failed : \n" + rec.m_failure.getMessage();
        }
        if (rec.m_error != null) {
            String message = "The test " + rec.m_test + " has thrown an error : \n" + rec.m_error.getMessage();
            StringWriter sw = new StringWriter();
            rec.m_error.printStackTrace(new PrintWriter(sw));
            message = message + "\n" + sw.toString();
            return message;
        }
        return "";
    }

    private class TestRecord {
        private boolean m_wasSucessFull;
        private Test m_test;
        private AssertionFailedError m_failure;
        private Throwable m_error;

        public TestRecord(Test t, AssertionFailedError e) {
            this.m_test = t;
            this.m_wasSucessFull = false;
            this.m_failure = e;
        }

        public TestRecord(Test t, Throwable e) {
            this.m_test = t;
            this.m_wasSucessFull = false;
            this.m_error = e;
        }

        public TestRecord(Test t) {
            this.m_test = t;
            this.m_wasSucessFull = true;
        }
    }
}

