/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.ConstructorInjector;
import org.apache.felix.ipojo.FieldInterceptor;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.HandlerManager;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.InstanceStateListener;
import org.apache.felix.ipojo.MethodInterceptor;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.PrimitiveInstanceDescription;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.architecture.InstanceDescription;
import org.apache.felix.ipojo.extender.internal.linker.InstanceBundleContextAware;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.FieldMetadata;
import org.apache.felix.ipojo.parser.MethodMetadata;
import org.apache.felix.ipojo.util.Logger;
import org.apache.felix.ipojo.util.Property;
import org.osgi.framework.BundleContext;

public class InstanceManager
implements ComponentInstance,
InstanceStateListener,
InstanceBundleContextAware {
    protected String m_name;
    protected String m_className;
    protected final HandlerManager[] m_handlers;
    protected int m_state = 0;
    protected List m_listeners = null;
    protected List m_pojoObjects;
    private final ComponentFactory m_factory;
    private final Logger m_logger;
    private final PrimitiveInstanceDescription m_description;
    private final BundleContext m_context;
    private Map m_fieldRegistration;
    private Map m_methodRegistration;
    private Map m_constructorRegistration;
    private Class m_clazz;
    private String m_factoryMethod = null;
    private boolean m_inTransition = false;
    private List m_stateQueue = new ArrayList();
    private Map m_fields = new HashMap();
    private Map m_methods = Collections.synchronizedMap(new HashMap());
    private BundleContext m_instanceContext;

    public InstanceManager(ComponentFactory factory, BundleContext context, HandlerManager[] handlers) {
        this.m_factory = factory;
        this.m_context = context;
        this.m_handlers = handlers;
        this.m_description = new PrimitiveInstanceDescription(this.m_factory.getComponentDescription(), this);
        this.m_logger = new Logger(this.m_context, this);
    }

    public void setInstanceBundleContext(BundleContext context) {
        this.m_instanceContext = context;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public void configure(Element metadata, Dictionary configuration) throws ConfigurationException {
        this.m_className = metadata.getAttribute("classname");
        this.m_name = (String)configuration.get("instance.name");
        Object obj = configuration.get("instance.object");
        if (obj != null) {
            this.m_pojoObjects = new ArrayList(1);
            this.m_pojoObjects.add(obj);
        }
        this.m_factoryMethod = metadata.getAttribute("factory-method");
        if (this.m_instanceContext == null) {
            this.m_instanceContext = (BundleContext)configuration.get("instance.bundle.context");
        }
        for (HandlerManager handler : this.m_handlers) {
            handler.init(this, metadata, configuration);
        }
        this.handleBCInjections();
        if (this.m_constructorRegistration != null) {
            for (int i = 0; i < this.m_constructorRegistration.size(); ++i) {
                if (this.m_constructorRegistration.containsKey(i)) continue;
                throw new ConfigurationException("The constructor parameter " + i + " is not managed");
            }
        }
    }

    private void handleBCInjections() throws ConfigurationException {
        MethodMetadata[] constructors;
        block0: for (MethodMetadata constructor : constructors = this.getFactory().getPojoMetadata().getConstructors()) {
            String[] ctorArguments = constructor.getMethodArguments();
            for (int index = 0; index < ctorArguments.length; ++index) {
                if (!ctorArguments[index].equals(BundleContext.class.getName()) || this.m_constructorRegistration != null && this.m_constructorRegistration.containsKey(index)) continue;
                boolean injectionsConsistent = true;
                for (int siblingIndex = 0; siblingIndex < ctorArguments.length; ++siblingIndex) {
                    if (siblingIndex == index) continue;
                    String injectionType = ctorArguments[siblingIndex];
                    if (this.m_constructorRegistration != null && this.m_constructorRegistration.containsKey(siblingIndex)) {
                        ConstructorInjector siblingInjector = (ConstructorInjector)this.m_constructorRegistration.get(siblingIndex);
                        Class injectorClass = siblingInjector.getConstructorParameterType(siblingIndex);
                        if (injectorClass == null || injectorClass.getName().equals(injectionType)) continue;
                        injectionsConsistent = false;
                        break;
                    }
                    injectionsConsistent = false;
                    break;
                }
                if (!injectionsConsistent) continue;
                Property contextInjection = new Property("__context", null, null, index, null, BundleContext.class.getName(), this, null);
                contextInjection.setValue(this.getContext());
                this.register(index, contextInjection);
                continue block0;
            }
        }
    }

    public InstanceDescription getInstanceDescription() {
        return this.m_description;
    }

    public Handler[] getRegisteredHandlers() {
        Handler[] handler = new Handler[this.m_handlers.length];
        for (int i = 0; i < this.m_handlers.length; ++i) {
            handler[i] = this.m_handlers[i].getHandler();
        }
        return handler;
    }

    public Handler getHandler(String name) {
        for (int i = 0; i < this.m_handlers.length; ++i) {
            HandlerFactory fact = (HandlerFactory)((Object)this.m_handlers[i].getHandler().getHandlerManager().getFactory());
            if (!fact.getHandlerName().equals(name)) continue;
            return this.m_handlers[i].getHandler();
        }
        return null;
    }

    public synchronized Object getFieldValue(String fieldName) {
        if (this.m_pojoObjects == null) {
            return this.getFieldValue(fieldName, null);
        }
        return this.getFieldValue(fieldName, this.m_pojoObjects.get(0));
    }

    public synchronized Object getFieldValue(String fieldName, Object pojo) {
        Object setByContainer = null;
        if (this.m_fields != null) {
            setByContainer = this.m_fields.get(fieldName);
        }
        if (setByContainer == null && pojo != null) {
            try {
                Field field = pojo.getClass().getDeclaredField(fieldName);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                return field.get(pojo);
            }
            catch (SecurityException e) {
                this.m_logger.log(1, "Cannot reflect on field " + fieldName + " to obtain the value : " + e.getMessage());
            }
            catch (NoSuchFieldException e) {
                this.m_logger.log(1, "Cannot reflect on field " + fieldName + " to obtain the value : " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                this.m_logger.log(1, "Cannot reflect on field " + fieldName + " to obtain the value : " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                this.m_logger.log(1, "Cannot reflect on field " + fieldName + " to obtain the value : " + e.getMessage());
            }
            return null;
        }
        return setByContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        int i;
        InstanceManager instanceManager = this;
        synchronized (instanceManager) {
            if (this.m_state != 0) {
                return;
            }
            this.m_state = -2;
        }
        Handler[] handlers = this.getRegisteredHandlers();
        for (i = 0; i < handlers.length; ++i) {
            this.m_description.addHandler(handlers[i].getDescription());
        }
        for (i = 0; i < this.m_handlers.length; ++i) {
            this.m_handlers[i].addInstanceStateListener(this);
            try {
                this.m_handlers[i].start();
                continue;
            }
            catch (IllegalStateException e) {
                this.m_logger.log(1, e.getMessage());
                this.stop();
                throw e;
            }
        }
        if (this.m_pojoObjects != null && !this.m_pojoObjects.isEmpty()) {
            this.managedInjectedObject();
        }
        for (i = 0; i < this.m_handlers.length; ++i) {
            if (this.m_handlers[i].getState() == 2) continue;
            this.setState(1);
            return;
        }
        this.setState(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ArrayList listeners = null;
        InstanceManager instanceManager = this;
        synchronized (instanceManager) {
            if (this.m_state == 0) {
                return;
            }
            this.m_stateQueue.clear();
            this.m_inTransition = false;
        }
        this.setState(1);
        for (int i = this.m_handlers.length - 1; i > -1; --i) {
            this.m_handlers[i].removeInstanceStateListener(this);
            this.m_handlers[i].stop();
        }
        InstanceManager i = this;
        synchronized (i) {
            this.m_state = 0;
            if (this.m_listeners != null) {
                listeners = new ArrayList(this.m_listeners);
            }
            this.m_pojoObjects = null;
        }
        if (listeners != null) {
            for (int i2 = 0; i2 < listeners.size(); ++i2) {
                ((InstanceStateListener)listeners.get(i2)).stateChanged(this, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        int i;
        int state;
        ArrayList listeners = null;
        InstanceManager instanceManager = this;
        synchronized (instanceManager) {
            state = this.m_state;
            if (this.m_listeners != null) {
                listeners = new ArrayList(this.m_listeners);
            }
            this.m_listeners = null;
        }
        if (state > 0) {
            this.stop();
        }
        instanceManager = this;
        synchronized (instanceManager) {
            this.m_state = -1;
        }
        for (i = 0; listeners != null && i < listeners.size(); ++i) {
            ((InstanceStateListener)listeners.get(i)).stateChanged(this, -1);
        }
        for (i = this.m_handlers.length - 1; i > -1; --i) {
            this.m_handlers[i].dispose();
        }
        InstanceManager instanceManager2 = this;
        synchronized (instanceManager2) {
            this.m_factory.disposed(this);
            this.m_clazz = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(int state) {
        int originalState = -2;
        ArrayList listeners = null;
        InstanceManager instanceManager = this;
        synchronized (instanceManager) {
            if (this.m_inTransition) {
                this.m_stateQueue.add(new Integer(state));
                return;
            }
            if (this.m_state != state) {
                this.m_inTransition = true;
                originalState = this.m_state;
                this.m_state = state;
                if (this.m_listeners != null) {
                    listeners = new ArrayList(this.m_listeners);
                }
            }
        }
        if (this.m_inTransition) {
            if (state > originalState) {
                try {
                    for (int i = 0; i < this.m_handlers.length; ++i) {
                        this.m_handlers[i].getHandler().stateChanged(state);
                    }
                }
                catch (IllegalStateException e) {
                    this.stop();
                    this.m_logger.log(1, e.getMessage(), e);
                    return;
                }
            }
            try {
                for (int i = this.m_handlers.length - 1; i > -1; --i) {
                    this.m_handlers[i].getHandler().stateChanged(state);
                }
            }
            catch (IllegalStateException e) {
                this.stop();
                this.m_logger.log(1, e.getMessage());
                return;
            }
        }
        if (listeners != null) {
            for (int i = 0; i < listeners.size(); ++i) {
                ((InstanceStateListener)listeners.get(i)).stateChanged(this, state);
            }
        }
        InstanceManager instanceManager2 = this;
        synchronized (instanceManager2) {
            this.m_inTransition = false;
            if (!this.m_stateQueue.isEmpty()) {
                int newState = (Integer)this.m_stateQueue.remove(0);
                this.setState(newState);
            }
        }
    }

    public synchronized int getState() {
        return this.m_state;
    }

    public synchronized boolean isStarted() {
        return this.m_state > 0;
    }

    public synchronized void addInstanceStateListener(InstanceStateListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList();
        }
        this.m_listeners.add(listener);
    }

    public synchronized void removeInstanceStateListener(InstanceStateListener listener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(listener);
            if (this.m_listeners.isEmpty()) {
                this.m_listeners = null;
            }
        }
    }

    public ComponentFactory getFactory() {
        return this.m_factory;
    }

    protected void load() {
        try {
            this.m_clazz = this.m_factory.loadClass(this.m_className);
        }
        catch (ClassNotFoundException e) {
            this.m_logger.log(1, "[" + this.m_name + "] Class not found during the loading phase : " + e.getMessage(), e);
            this.stop();
            return;
        }
    }

    public synchronized Object[] getPojoObjects() {
        if (this.m_pojoObjects == null) {
            return null;
        }
        return this.m_pojoObjects.toArray(new Object[this.m_pojoObjects.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object createObject() {
        if (this.m_clazz == null) {
            this.load();
        }
        Object instance = null;
        if (this.m_factoryMethod == null) {
            try {
                if (this.m_constructorRegistration != null) {
                    Object[] values = new Object[this.m_constructorRegistration.size() + 1];
                    Class[] types = new Class[this.m_constructorRegistration.size() + 1];
                    values[0] = this;
                    types[0] = InstanceManager.class;
                    for (int i = 0; i < this.m_constructorRegistration.size(); ++i) {
                        ConstructorInjector injector = (ConstructorInjector)this.m_constructorRegistration.get(new Integer(i));
                        Object v = injector.getConstructorParameter(i);
                        if (v == null) continue;
                        values[i + 1] = v;
                        Class<?> t = injector.getConstructorParameterType(i);
                        if (t == null) {
                            t = v.getClass();
                        }
                        types[i + 1] = t;
                    }
                    Constructor cst = this.m_clazz.getDeclaredConstructor(types);
                    if (!cst.isAccessible()) {
                        cst.setAccessible(true);
                    }
                    String methodId = MethodMetadata.computeMethodId(cst);
                    this.onEntry(null, methodId, values);
                    instance = cst.newInstance(values);
                    this.onExit(instance, methodId, instance);
                    return instance;
                }
                try {
                    Constructor cst = this.m_clazz.getDeclaredConstructor(InstanceManager.class, BundleContext.class);
                    if (!cst.isAccessible()) {
                        cst.setAccessible(true);
                    }
                    Object[] args = new Object[]{this, this.m_context};
                    this.onEntry(null, "$init$org_osgi_framework_BundleContext", new Object[]{this.m_context});
                    instance = cst.newInstance(args);
                    this.onExit(instance, "$init$org_osgi_framework_BundleContext", instance);
                    return instance;
                }
                catch (NoSuchMethodException e) {
                    if (instance != null) return instance;
                    Constructor cst = this.m_clazz.getDeclaredConstructor(InstanceManager.class);
                    if (!cst.isAccessible()) {
                        cst.setAccessible(true);
                    }
                    Object[] args = new Object[]{this};
                    this.onEntry(null, "$init", new Object[0]);
                    instance = cst.newInstance(args);
                    this.onExit(instance, "$init", instance);
                }
                return instance;
            }
            catch (IllegalAccessException e) {
                this.m_logger.log(1, "[" + this.m_name + "] createInstance -> The POJO constructor is not accessible : " + e.getMessage(), e);
                this.stop();
                throw new RuntimeException("Cannot create a POJO instance, the POJO constructor is not accessible", e);
            }
            catch (SecurityException e) {
                this.m_logger.log(1, "[" + this.m_name + "] createInstance -> The POJO constructor is not accessible (security reason) : " + e.getMessage(), e);
                this.stop();
                throw new RuntimeException("Cannot create a POJO instance, the POJO constructor is not accessible", e);
            }
            catch (InvocationTargetException e) {
                this.m_logger.log(1, "[" + this.m_name + "] createInstance -> Cannot invoke the constructor method - the constructor throws an exception : " + e.getTargetException().getMessage(), e.getTargetException());
                this.onError(null, this.m_className, e.getTargetException());
                this.stop();
                throw new RuntimeException("Cannot create a POJO instance, the POJO constructor has thrown an exception", e.getTargetException());
            }
            catch (NoSuchMethodException e) {
                this.m_logger.log(1, "[" + this.m_name + "] iPOJO did not find a suitable constructor to create the " + "object: " + e.getMessage(), e);
                this.stop();
                throw new RuntimeException("Cannot create a POJO instance, the POJO constructor cannot be found", e);
            }
            catch (Throwable e) {
                this.m_logger.log(1, "[" + this.m_name + "] createInstance -> The POJO constructor invocation failed : " + e.getMessage(), e);
                this.stop();
                throw new RuntimeException("Cannot create a POJO instance, the POJO constructor invocation has thrown an exception", e);
            }
        }
        try {
            Method factory = null;
            try {
                factory = this.m_clazz.getDeclaredMethod(this.m_factoryMethod, BundleContext.class);
                if (!factory.isAccessible()) {
                    factory.setAccessible(true);
                }
                Object[] args = new Object[]{this.m_context};
                this.onEntry(null, this.m_className, args);
                instance = factory.invoke(null, this.m_context);
            }
            catch (NoSuchMethodException e1) {
                try {
                    factory = this.m_clazz.getDeclaredMethod(this.m_factoryMethod, new Class[0]);
                    if (!factory.isAccessible()) {
                        factory.setAccessible(true);
                    }
                    Object[] args = new Object[]{};
                    this.onEntry(null, this.m_className, args);
                    instance = factory.invoke(null, args);
                }
                catch (NoSuchMethodException e2) {
                    this.m_logger.log(1, "[" + this.m_name + "] createInstance -> Cannot invoke the factory-method (method not found) : " + e2.getMessage(), e2);
                    this.stop();
                    throw new RuntimeException("Cannot create a POJO instance, the factory-method cannot be found", e2);
                }
            }
            AccessibleObject method = null;
            for (Class<?> declaringClass = instance.getClass(); declaringClass != null && method == null; declaringClass = declaringClass.getSuperclass()) {
                try {
                    method = declaringClass.getDeclaredMethod("_setInstanceManager", InstanceManager.class);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (method == null) {
                this.m_logger.log(1, "[" + this.m_name + "] createInstance -> Cannot invoke the factory-method (the _setInstanceManager method does not exist");
                this.stop();
                throw new RuntimeException("Cannot create a POJO instance, the factory-method cannot be found");
            }
            if (!method.isAccessible()) {
                ((Method)method).setAccessible(true);
            }
            ((Method)method).invoke(instance, this);
            this.onExit(null, this.m_className, instance);
            return instance;
        }
        catch (InvocationTargetException e) {
            this.m_logger.log(1, "[" + this.m_name + "] createInstance -> The factory-method throws an exception : " + e.getTargetException(), e.getTargetException());
            this.onError(null, this.m_className, e.getTargetException());
            this.stop();
            throw new RuntimeException("Cannot create a POJO instance, the factory-method has thrown an exception", e.getTargetException());
        }
        catch (Throwable e) {
            this.m_logger.log(1, "[" + this.m_name + "] createInstance -> The factory-method invocation failed : " + e.getMessage(), e);
            this.stop();
            throw new RuntimeException("Cannot create a POJO instance, the factory-method invocation has thrown an exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createPojoObject() {
        Object instance = this.createObject();
        InstanceManager instanceManager = this;
        synchronized (instanceManager) {
            if (this.m_pojoObjects == null) {
                this.m_pojoObjects = new ArrayList(1);
            }
            this.m_pojoObjects.add(instance);
        }
        for (int i = 0; i < this.m_handlers.length; ++i) {
            ((PrimitiveHandler)this.m_handlers[i].getHandler()).onCreation(instance);
        }
        return instance;
    }

    public synchronized void deletePojoObject(Object pojo) {
        if (this.m_pojoObjects != null) {
            this.m_pojoObjects.remove(pojo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPojoObject() {
        Object pojo = null;
        boolean newPOJO = false;
        InstanceManager instanceManager = this;
        synchronized (instanceManager) {
            if (this.m_pojoObjects != null) {
                pojo = this.m_pojoObjects.get(0);
            } else {
                pojo = this.createObject();
                if (this.m_pojoObjects == null) {
                    this.m_pojoObjects = new ArrayList(1);
                }
                this.m_pojoObjects.add(pojo);
                newPOJO = true;
            }
        }
        for (int i = 0; newPOJO && i < this.m_handlers.length; ++i) {
            ((PrimitiveHandler)this.m_handlers[i].getHandler()).onCreation(pojo);
        }
        return pojo;
    }

    public Class getClazz() {
        if (this.m_clazz == null) {
            this.load();
        }
        return this.m_clazz;
    }

    private void managedInjectedObject() {
        Object obj = this.m_pojoObjects.get(0);
        if (!(obj instanceof Pojo)) {
            throw new RuntimeException("The injected object in " + this.m_name + " is not a POJO");
        }
        this.load();
        if (!this.m_clazz.isInstance(obj)) {
            throw new RuntimeException("The injected object in " + this.m_name + " is not an instance of " + this.m_className);
        }
        try {
            Method setIM = this.m_clazz.getDeclaredMethod("_setInstanceManager", this.getClass());
            setIM.setAccessible(true);
            setIM.invoke(obj, this);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot attach the injected object with the container of " + this.m_name, e);
        }
        for (int i = 0; i < this.m_handlers.length; ++i) {
            ((PrimitiveHandler)this.m_handlers[i].getHandler()).onCreation(obj);
        }
    }

    public void register(PrimitiveHandler handler, FieldMetadata[] fields, MethodMetadata[] methods) {
        int i;
        for (i = 0; fields != null && i < fields.length; ++i) {
            this.register(fields[i], handler);
        }
        for (i = 0; methods != null && i < methods.length; ++i) {
            this.register(methods[i], handler);
        }
    }

    public void register(FieldMetadata field, FieldInterceptor interceptor) {
        if (this.m_fieldRegistration == null) {
            this.m_fieldRegistration = new HashMap();
            this.m_fieldRegistration.put(field.getFieldName(), new FieldInterceptor[]{interceptor});
        } else {
            FieldInterceptor[] list = (FieldInterceptor[])this.m_fieldRegistration.get(field.getFieldName());
            if (list == null) {
                this.m_fieldRegistration.put(field.getFieldName(), new FieldInterceptor[]{interceptor});
            } else {
                for (int j = 0; j < list.length; ++j) {
                    if (list[j] != interceptor) continue;
                    return;
                }
                FieldInterceptor[] newList = new FieldInterceptor[list.length + 1];
                System.arraycopy(list, 0, newList, 0, list.length);
                newList[list.length] = interceptor;
                this.m_fieldRegistration.put(field.getFieldName(), newList);
            }
        }
    }

    public void register(MethodMetadata method, MethodInterceptor interceptor) {
        if (this.m_methodRegistration == null) {
            this.m_methodRegistration = new HashMap();
            this.m_methodRegistration.put(method.getMethodIdentifier(), new MethodInterceptor[]{interceptor});
        } else {
            MethodInterceptor[] list = (MethodInterceptor[])this.m_methodRegistration.get(method.getMethodIdentifier());
            if (list == null) {
                this.m_methodRegistration.put(method.getMethodIdentifier(), new MethodInterceptor[]{interceptor});
            } else {
                for (int j = 0; j < list.length; ++j) {
                    if (list[j] != interceptor) continue;
                    return;
                }
                MethodInterceptor[] newList = new MethodInterceptor[list.length + 1];
                System.arraycopy(list, 0, newList, 0, list.length);
                newList[list.length] = interceptor;
                this.m_methodRegistration.put(method.getMethodIdentifier(), newList);
            }
        }
    }

    public void register(MethodMetadata method, String innerClass, MethodInterceptor interceptor) {
        if (this.m_methodRegistration == null) {
            this.m_methodRegistration = new HashMap();
            this.m_methodRegistration.put(innerClass + "___" + method.getMethodIdentifier(), new MethodInterceptor[]{interceptor});
        } else {
            MethodInterceptor[] list = (MethodInterceptor[])this.m_methodRegistration.get(method.getMethodIdentifier());
            if (list == null) {
                this.m_methodRegistration.put(innerClass + "___" + method.getMethodIdentifier(), new MethodInterceptor[]{interceptor});
            } else {
                for (int j = 0; j < list.length; ++j) {
                    if (list[j] != interceptor) continue;
                    return;
                }
                MethodInterceptor[] newList = new MethodInterceptor[list.length + 1];
                System.arraycopy(list, 0, newList, 0, list.length);
                newList[list.length] = interceptor;
                this.m_methodRegistration.put(innerClass + "___" + method.getMethodIdentifier(), newList);
            }
        }
    }

    public void register(int index, ConstructorInjector injector) throws ConfigurationException {
        if (this.m_constructorRegistration == null) {
            this.m_constructorRegistration = new HashMap();
        }
        if (this.m_constructorRegistration.containsKey(index)) {
            throw new ConfigurationException("Another constructor injector manages the parameter " + index + " : " + this.m_constructorRegistration.get(index) + ", so cannot " + "register " + injector);
        }
        this.m_constructorRegistration.put(index, injector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object onGet(Object pojo, String fieldName) {
        Object initialValue = null;
        InstanceManager instanceManager = this;
        synchronized (instanceManager) {
            initialValue = this.m_fields.get(fieldName);
        }
        Object result = initialValue;
        boolean hasChanged = false;
        FieldInterceptor[] list = (FieldInterceptor[])this.m_fieldRegistration.get(fieldName);
        for (int i = 0; list != null && i < list.length; ++i) {
            Object handlerResult = list[i].onGet(pojo, fieldName, initialValue);
            if (handlerResult == initialValue) continue;
            if (result != initialValue && (handlerResult != null && !handlerResult.equals(result) || result != null && handlerResult == null)) {
                this.m_logger.log(2, "A conflict was detected on the injection of " + fieldName);
            }
            result = handlerResult;
            hasChanged = true;
        }
        if (hasChanged) {
            InstanceManager i = this;
            synchronized (i) {
                this.m_fields.put(fieldName, result);
            }
            for (int i2 = 0; list != null && i2 < list.length; ++i2) {
                list[i2].onSet(pojo, fieldName, result);
            }
        }
        return result;
    }

    public void onEntry(Object pojo, String methodId, Object[] args) {
        if (this.m_methodRegistration == null) {
            return;
        }
        MethodInterceptor[] list = (MethodInterceptor[])this.m_methodRegistration.get(methodId);
        Member method = this.getMethodById(methodId);
        for (int i = 0; list != null && i < list.length; ++i) {
            list[i].onEntry(pojo, method, args);
        }
    }

    public void onExit(Object pojo, String methodId, Object result) {
        int i;
        if (this.m_methodRegistration == null) {
            return;
        }
        MethodInterceptor[] list = (MethodInterceptor[])this.m_methodRegistration.get(methodId);
        Member method = this.getMethodById(methodId);
        for (i = 0; list != null && i < list.length; ++i) {
            list[i].onExit(pojo, method, result);
        }
        for (i = 0; list != null && i < list.length; ++i) {
            list[i].onFinally(pojo, method);
        }
    }

    public void onError(Object pojo, String methodId, Throwable error) {
        int i;
        if (this.m_methodRegistration == null) {
            return;
        }
        MethodInterceptor[] list = (MethodInterceptor[])this.m_methodRegistration.get(methodId);
        Member method = this.getMethodById(methodId);
        for (i = 0; list != null && i < list.length; ++i) {
            list[i].onError(pojo, method, error);
        }
        for (i = 0; list != null && i < list.length; ++i) {
            list[i].onFinally(pojo, method);
        }
    }

    private Member getMethodById(String methodId) {
        Member member = (Member)this.m_methods.get(methodId);
        if (!this.m_methods.containsKey(methodId) && this.m_clazz != null) {
            if (methodId.contains("___")) {
                String[] split = methodId.split("___");
                if (split.length != 2) {
                    this.m_logger.log(3, "A methodID cannot be associated with a method from the POJO class: " + methodId);
                    return null;
                }
                String innerClassName = split[0];
                methodId = split[1];
                if (innerClassName.matches("-?\\d+")) {
                    this.m_methods.put(methodId, null);
                    return null;
                }
                for (Class<?> c : this.m_clazz.getDeclaredClasses()) {
                    if (innerClassName.equals(c.getSimpleName())) {
                        Method[] mets;
                        for (Method met : mets = c.getDeclaredMethods()) {
                            if (!MethodMetadata.computeMethodId(met).equals(methodId)) continue;
                            this.m_methods.put(methodId, met);
                            return met;
                        }
                    }
                    this.m_logger.log(3, "Cannot find the member associated to " + methodId + " - reason: " + "cannot find the class " + innerClassName + " declared in " + this.m_clazz.getName());
                }
            }
            Method[] mets = this.m_clazz.getDeclaredMethods();
            for (int i = 0; i < mets.length; ++i) {
                if (!MethodMetadata.computeMethodId(mets[i]).equals(methodId)) continue;
                this.m_methods.put(methodId, mets[i]);
                return mets[i];
            }
            if (methodId.startsWith("$init")) {
                Constructor<?>[] constructors = this.m_clazz.getDeclaredConstructors();
                for (int i = 0; i < constructors.length; ++i) {
                    if (!MethodMetadata.computeMethodId(constructors[i]).equals(methodId)) continue;
                    this.m_methods.put(methodId, constructors[i]);
                    return constructors[i];
                }
            }
            this.m_logger.log(3, "A methodID cannot be associated with a method from the POJO class: " + methodId);
            return null;
        }
        return member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSet(Object pojo, String fieldName, Object objectValue) {
        InstanceManager instanceManager = this;
        synchronized (instanceManager) {
            this.m_fields.put(fieldName, objectValue);
        }
        FieldInterceptor[] list = (FieldInterceptor[])this.m_fieldRegistration.get(fieldName);
        for (int i = 0; list != null && i < list.length; ++i) {
            list[i].onSet(pojo, fieldName, objectValue);
        }
    }

    public BundleContext getContext() {
        return this.m_context;
    }

    public BundleContext getGlobalContext() {
        return ((IPojoContext)this.m_context).getGlobalContext();
    }

    public ServiceContext getLocalServiceContext() {
        return ((IPojoContext)this.m_context).getServiceContext();
    }

    public String getInstanceName() {
        return this.m_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigure(Dictionary configuration) {
        this.m_logger.log(3, "Reconfiguring " + this.getInstanceName());
        for (int i = 0; i < this.m_handlers.length; ++i) {
            this.m_handlers[i].getHandler().reconfigure(configuration);
        }
        InstanceManager instanceManager = this;
        synchronized (instanceManager) {
            if (this.m_state == 0) {
                this.m_logger.log(3, "Instance stopped during reconfiguration - Try to restart");
                this.start();
            } else if (this.m_state == 1) {
                this.m_logger.log(3, "Instance invalid during reconfiguration - Recompute state");
                for (int i = 0; i < this.m_handlers.length; ++i) {
                    if (this.m_handlers[i].getState() == 2) continue;
                    return;
                }
                this.setState(2);
            }
        }
    }

    public String getClassName() {
        return this.m_className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(ComponentInstance instance, int newState) {
        int state;
        InstanceManager instanceManager = this;
        synchronized (instanceManager) {
            if (this.m_state <= 0) {
                return;
            }
            state = this.m_state;
        }
        if (newState == 1 && state == 2) {
            this.setState(1);
            return;
        }
        if (newState == 2 && state == 1) {
            for (int i = 0; i < this.m_handlers.length; ++i) {
                if (this.m_handlers[i].getState() == 2) continue;
                return;
            }
            this.setState(2);
            return;
        }
    }

    public Set getRegistredFields() {
        if (this.m_fieldRegistration == null) {
            return null;
        }
        return this.m_fieldRegistration.keySet();
    }

    public Set getRegistredMethods() {
        if (this.m_methodRegistration == null) {
            return null;
        }
        return this.m_methodRegistration.keySet();
    }

    public BundleContext getInstanceContext() {
        return this.m_instanceContext;
    }
}

