/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util.manifestparser;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.apache.felix.framework.util.manifestparser.R4Attribute;
import org.apache.felix.framework.util.manifestparser.R4Directive;
import org.apache.felix.moduleloader.ICapability;
import org.apache.felix.moduleloader.IModule;
import org.osgi.framework.Version;

public class Capability
implements ICapability,
Comparable {
    private final IModule m_module;
    private final String m_namespace;
    private final R4Directive[] m_directives;
    private final R4Attribute[] m_attributes;
    private final String[] m_uses;
    private final String[][] m_includeFilter;
    private final String[][] m_excludeFilter;
    private volatile Map m_attrMap;
    private final String m_pkgName;
    private final Version m_pkgVersion;

    public Capability(IModule module, String namespace, R4Directive[] dirs, R4Attribute[] attrs) {
        int i;
        this.m_module = module;
        this.m_namespace = namespace;
        this.m_directives = dirs;
        this.m_attributes = attrs;
        String mandatory = "";
        String[] uses = new String[]{};
        String[][] includeFilter = null;
        String[][] excludeFilter = null;
        for (int dirIdx = 0; this.m_directives != null && dirIdx < this.m_directives.length; ++dirIdx) {
            int filterIdx;
            String[] ss;
            if (this.m_directives[dirIdx].getName().equals("uses")) {
                StringTokenizer tok = new StringTokenizer(this.m_directives[dirIdx].getValue(), ",");
                uses = new String[tok.countTokens()];
                for (int i2 = 0; i2 < uses.length; ++i2) {
                    uses[i2] = tok.nextToken().trim();
                }
                continue;
            }
            if (this.m_directives[dirIdx].getName().equals("mandatory")) {
                mandatory = this.m_directives[dirIdx].getValue();
                continue;
            }
            if (this.m_directives[dirIdx].getName().equals("include")) {
                ss = ManifestParser.parseDelimitedString(this.m_directives[dirIdx].getValue(), ",");
                includeFilter = new String[ss.length][];
                for (filterIdx = 0; filterIdx < ss.length; ++filterIdx) {
                    includeFilter[filterIdx] = Util.parseSubstring(ss[filterIdx]);
                }
                continue;
            }
            if (!this.m_directives[dirIdx].getName().equals("exclude")) continue;
            ss = ManifestParser.parseDelimitedString(this.m_directives[dirIdx].getValue(), ",");
            excludeFilter = new String[ss.length][];
            for (filterIdx = 0; filterIdx < ss.length; ++filterIdx) {
                excludeFilter[filterIdx] = Util.parseSubstring(ss[filterIdx]);
            }
        }
        this.m_uses = uses;
        this.m_includeFilter = includeFilter;
        this.m_excludeFilter = excludeFilter;
        StringTokenizer tok = new StringTokenizer(mandatory, ", ");
        while (tok.hasMoreTokens()) {
            String attrName = tok.nextToken().trim();
            boolean found = false;
            for (i = 0; !found && i < this.m_attributes.length; ++i) {
                if (!this.m_attributes[i].getName().equals(attrName)) continue;
                this.m_attributes[i] = new R4Attribute(this.m_attributes[i].getName(), this.m_attributes[i].getValue(), true);
                found = true;
            }
            if (found) continue;
            throw new IllegalArgumentException("Mandatory attribute '" + attrName + "' does not exist.");
        }
        String pkgName = null;
        Version pkgVersion = Version.emptyVersion;
        for (i = 0; i < this.m_attributes.length; ++i) {
            if (this.m_attributes[i].getName().equals("package")) {
                pkgName = (String)this.m_attributes[i].getValue();
                continue;
            }
            if (!this.m_attributes[i].getName().equals("version")) continue;
            pkgVersion = (Version)this.m_attributes[i].getValue();
        }
        this.m_pkgName = pkgName;
        this.m_pkgVersion = pkgVersion;
    }

    public IModule getModule() {
        return this.m_module;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getPackageName() {
        return this.m_pkgName;
    }

    public Version getPackageVersion() {
        return this.m_pkgVersion;
    }

    public R4Directive[] getDirectives() {
        return this.m_directives;
    }

    public R4Attribute[] getAttributes() {
        return this.m_attributes;
    }

    public String[] getUses() {
        return this.m_uses;
    }

    public boolean isIncluded(String name) {
        if (this.m_includeFilter == null && this.m_excludeFilter == null) {
            return true;
        }
        String className = Util.getClassName(name);
        boolean included = this.m_includeFilter == null;
        for (int i = 0; !included && this.m_includeFilter != null && i < this.m_includeFilter.length; ++i) {
            included = Util.checkSubstring(this.m_includeFilter[i], className);
        }
        boolean excluded = false;
        for (int i = 0; !excluded && this.m_excludeFilter != null && i < this.m_excludeFilter.length; ++i) {
            excluded = Util.checkSubstring(this.m_excludeFilter[i], className);
        }
        return included && !excluded;
    }

    public Map getProperties() {
        if (this.m_attrMap == null) {
            this.m_attrMap = new Map(){

                public int size() {
                    return Capability.this.m_attributes.length + 2;
                }

                public boolean isEmpty() {
                    return false;
                }

                public boolean containsKey(Object key) {
                    return this.get(key) != null;
                }

                public boolean containsValue(Object value) {
                    if (Capability.this.m_pkgName.equals(value)) {
                        return true;
                    }
                    if (Capability.this.m_pkgVersion.equals(value)) {
                        return true;
                    }
                    for (int i = 0; i < Capability.this.m_attributes.length; ++i) {
                        if (!Capability.this.m_attributes[i].getValue().equals(value)) continue;
                        return true;
                    }
                    return false;
                }

                public Object get(Object key) {
                    if ("package".equals(key)) {
                        return Capability.this.m_pkgName;
                    }
                    if ("version".equals(key)) {
                        return Capability.this.m_pkgVersion;
                    }
                    for (int i = 0; i < Capability.this.m_attributes.length; ++i) {
                        if (!Capability.this.m_attributes[i].getName().equals(key)) continue;
                        return Capability.this.m_attributes[i].getValue();
                    }
                    return null;
                }

                public Object put(Object key, Object value) {
                    throw new UnsupportedOperationException("Map.put() not implemented.");
                }

                public Object remove(Object key) {
                    throw new UnsupportedOperationException("Map.remove() not implemented.");
                }

                public void putAll(Map t) {
                    throw new UnsupportedOperationException("Map.putAll() not implemented.");
                }

                public void clear() {
                    throw new UnsupportedOperationException("Map.clear() not implemented.");
                }

                public Set keySet() {
                    HashSet<String> set = new HashSet<String>();
                    set.add("package");
                    set.add("version");
                    for (int i = 0; i < Capability.this.m_attributes.length; ++i) {
                        set.add(Capability.this.m_attributes[i].getName());
                    }
                    return set;
                }

                public Collection values() {
                    throw new UnsupportedOperationException("Map.values() not implemented.");
                }

                public Set entrySet() {
                    throw new UnsupportedOperationException("Map.entrySet() not implemented.");
                }
            };
        }
        return this.m_attrMap;
    }

    public int compareTo(Object o) {
        Capability cap = (Capability)o;
        Version thisVersion = null;
        Version version = null;
        if (this.getNamespace().equals("package")) {
            thisVersion = this.getPackageVersion();
            version = cap.getPackageVersion();
        } else if (this.getNamespace().equals("module")) {
            thisVersion = (Version)this.getProperties().get("bundle-version");
            version = (Version)cap.getProperties().get("bundle-version");
        }
        if (thisVersion != null && version != null) {
            long id;
            int cmp = thisVersion.compareTo(version);
            if (cmp < 0) {
                return 1;
            }
            if (cmp > 0) {
                return -1;
            }
            long thisId = this.m_module.getBundle().getBundleId();
            if (thisId < (id = cap.getModule().getBundle().getBundleId())) {
                return -1;
            }
            if (thisId > id) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(this.getNamespace());
        for (i = 0; this.m_directives != null && i < this.m_directives.length; ++i) {
            sb.append(";");
            sb.append(this.m_directives[i].getName());
            sb.append(":=\"");
            sb.append(this.m_directives[i].getValue());
            sb.append("\"");
        }
        for (i = 0; this.m_attributes != null && i < this.m_attributes.length; ++i) {
            sb.append(";");
            sb.append(this.m_attributes[i].getName());
            sb.append("=\"");
            sb.append(this.m_attributes[i].getValue());
            sb.append("\"");
        }
        return sb.toString();
    }
}

