/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AggregatorHandle<T> {
    private final AtomicLong refCountMapped = new AtomicLong(2L);
    private volatile boolean hasRecordings = false;

    protected AggregatorHandle() {
    }

    public final boolean acquire() {
        return (this.refCountMapped.addAndGet(2L) & 1L) == 0L;
    }

    public final void release() {
        this.refCountMapped.getAndAdd(-2L);
    }

    public final boolean tryUnmap() {
        if (this.refCountMapped.get() != 0L) {
            return false;
        }
        return this.refCountMapped.compareAndSet(0L, 1L);
    }

    @Nullable
    public final T accumulateThenReset() {
        if (!this.hasRecordings) {
            return null;
        }
        this.hasRecordings = false;
        return this.doAccumulateThenReset();
    }

    protected abstract T doAccumulateThenReset();

    public final void recordLong(long value) {
        this.doRecordLong(value);
        this.hasRecordings = true;
    }

    protected void doRecordLong(long value) {
        throw new UnsupportedOperationException("This aggregator does not support recording long values.");
    }

    public final void recordDouble(double value) {
        this.doRecordDouble(value);
        this.hasRecordings = true;
    }

    protected void doRecordDouble(double value) {
        throw new UnsupportedOperationException("This aggregator does not support recording double values.");
    }
}

