/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.metrics.BoundDoubleCounter;
import io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.api.metrics.DoubleCounterBuilder;
import io.opentelemetry.api.metrics.common.Labels;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrumentBuilder;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.SynchronousInstrumentAccumulator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class DoubleCounterSdk
extends AbstractSynchronousInstrument
implements DoubleCounter {
    private DoubleCounterSdk(InstrumentDescriptor descriptor, SynchronousInstrumentAccumulator<?> accumulator) {
        super(descriptor, accumulator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(double increment, Labels labels) {
        AggregatorHandle<?> aggregatorHandle = this.acquireHandle(labels);
        try {
            if (increment < 0.0) {
                throw new IllegalArgumentException("Counters can only increase");
            }
            aggregatorHandle.recordDouble(increment);
        }
        finally {
            aggregatorHandle.release();
        }
    }

    public void add(double increment) {
        this.add(increment, Labels.empty());
    }

    public BoundDoubleCounter bind(Labels labels) {
        return new BoundInstrument(this.acquireHandle(labels));
    }

    static final class Builder
    extends AbstractSynchronousInstrumentBuilder<Builder>
    implements DoubleCounterBuilder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, InstrumentType.COUNTER, InstrumentValueType.DOUBLE, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public DoubleCounterSdk build() {
            return this.buildInstrument((x$0, x$1) -> new DoubleCounterSdk((InstrumentDescriptor)x$0, (SynchronousInstrumentAccumulator)x$1));
        }
    }

    static final class BoundInstrument
    implements BoundDoubleCounter {
        private final AggregatorHandle<?> aggregatorHandle;

        BoundInstrument(AggregatorHandle<?> aggregatorHandle) {
            this.aggregatorHandle = aggregatorHandle;
        }

        public void add(double increment) {
            if (increment < 0.0) {
                throw new IllegalArgumentException("Counters can only increase");
            }
            this.aggregatorHandle.recordDouble(increment);
        }

        public void unbind() {
            this.aggregatorHandle.release();
        }
    }
}

