/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.java.lang.system;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.junit.contrib.java.lang.system.internal.RestoreSpecificSystemProperties;
import org.junit.rules.ExternalResource;

public class ProvideSystemProperty
extends ExternalResource {
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private final RestoreSpecificSystemProperties restoreSystemProperty = new RestoreSpecificSystemProperties();

    public static ProvideSystemProperty fromFile(String name) throws IOException {
        FileInputStream fis = new FileInputStream(name);
        return ProvideSystemProperty.fromInputStream(fis);
    }

    public static ProvideSystemProperty fromResource(String name) throws IOException {
        InputStream is = ProvideSystemProperty.class.getResourceAsStream(name);
        return ProvideSystemProperty.fromInputStream(is);
    }

    private static ProvideSystemProperty fromInputStream(InputStream is) throws IOException {
        Properties p = new Properties();
        p.load(is);
        ProvideSystemProperty rule = new ProvideSystemProperty();
        for (Map.Entry<Object, Object> property : p.entrySet()) {
            rule.addProperty((String)property.getKey(), (String)property.getValue());
        }
        return rule;
    }

    @Deprecated
    public ProvideSystemProperty() {
    }

    @Deprecated
    public void setProperty(String name, String value) {
        this.restoreSystemProperty.add(name);
        if (value == null) {
            System.clearProperty(name);
        } else {
            System.setProperty(name, value);
        }
    }

    public ProvideSystemProperty(String name, String value) {
        this.addProperty(name, value);
    }

    public ProvideSystemProperty and(String name, String value) {
        this.addProperty(name, value);
        return this;
    }

    private void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    protected void before() throws Throwable {
        this.setProperties();
    }

    private void setProperties() {
        for (Map.Entry<String, String> property : this.properties.entrySet()) {
            String name = property.getKey();
            String value = property.getValue();
            this.setProperty(name, value);
        }
    }

    protected void after() {
        this.restoreSystemProperty.restore();
    }
}

