/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.security;

import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.grpc.security.SecurityConstants;
import com.navercorp.pinpoint.grpc.security.SslClientConfig;
import com.navercorp.pinpoint.grpc.security.SslServerConfig;
import com.navercorp.pinpoint.grpc.util.Resource;
import io.grpc.netty.GrpcSslContexts;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SslContextFactory {
    private static final Logger LOGGER = LogManager.getLogger(SslContextFactory.class);

    public static SslContext create(SslServerConfig serverConfig) throws SSLException {
        Objects.requireNonNull(serverConfig, "serverConfig");
        SslProvider sslProvider = SslContextFactory.getSslProvider(serverConfig.getSslProviderType());
        try {
            Resource keyCertChainFileResource = serverConfig.getKeyCertChainResource();
            Resource keyResource = serverConfig.getKeyResource();
            SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((InputStream)keyCertChainFileResource.getInputStream(), (InputStream)keyResource.getInputStream());
            SslContext sslContext = SslContextFactory.createSslContext(sslContextBuilder, sslProvider);
            SslContextFactory.assertValidCipherSuite(sslContext);
            return sslContext;
        }
        catch (SSLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SSLException(e);
        }
    }

    public static SslContext create(SslClientConfig clientConfig) throws SSLException {
        Objects.requireNonNull(clientConfig, "clientConfig");
        if (!clientConfig.isEnable()) {
            throw new IllegalArgumentException("sslConfig is disabled.");
        }
        SslProvider sslProvider = SslContextFactory.getSslProvider(clientConfig.getSslProviderType());
        SslContextBuilder sslContextBuilder = null;
        try {
            sslContextBuilder = SslContextBuilder.forClient();
            Resource trustCertResource = clientConfig.getTrustCertResource();
            if (trustCertResource != null) {
                sslContextBuilder.trustManager(trustCertResource.getInputStream());
            } else {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                sslContextBuilder.trustManager(trustManagerFactory);
            }
            SslContext sslContext = SslContextFactory.createSslContext(sslContextBuilder, sslProvider);
            SslContextFactory.assertValidCipherSuite(sslContext);
            return sslContext;
        }
        catch (SSLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SSLException(e);
        }
    }

    private static SslContext createSslContext(SslContextBuilder sslContextBuilder, SslProvider sslProvider) throws SSLException {
        sslContextBuilder.sslProvider(sslProvider);
        sslContextBuilder.protocols(SecurityConstants.DEFAULT_SUPPORT_PROTOCOLS.toArray(new String[0]));
        sslContextBuilder.ciphers(SecurityConstants.DEFAULT_SUPPORT_CIPHER_SUITE, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
        SslContextBuilder configure = GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder, (SslProvider)sslProvider);
        return configure.build();
    }

    private static void assertValidCipherSuite(SslContext sslContext) throws SSLException {
        Objects.requireNonNull(sslContext, "sslContext must not be null");
        List supportedCipherSuiteList = sslContext.cipherSuites();
        if (CollectionUtils.isEmpty((Collection)supportedCipherSuiteList)) {
            throw new SSLException("cipherSuites must not be empty");
        }
        for (String cipherSuite : supportedCipherSuiteList) {
            if (!SecurityConstants.BAD_CIPHER_SUITE_LIST.contains(cipherSuite)) continue;
            throw new SSLException(cipherSuite + " is not safe. Please check this url.(https://httpwg.org/specs/rfc7540.html#BadCipherSuites)");
        }
        LOGGER.info("Support cipher list : {} {}", (Object)sslContext, (Object)supportedCipherSuiteList);
    }

    static SslProvider getSslProvider(String providerType) throws SSLException {
        if (StringUtils.isEmpty((String)providerType)) {
            return SslProvider.OPENSSL;
        }
        if (SslProvider.OPENSSL.name().equalsIgnoreCase(providerType)) {
            return SslProvider.OPENSSL;
        }
        if (SslProvider.JDK.name().equalsIgnoreCase(providerType)) {
            return SslProvider.JDK;
        }
        throw new SSLException("can't find SslProvider. value:" + providerType);
    }
}

