/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.client.config;

import com.navercorp.pinpoint.bootstrap.config.Value;
import com.navercorp.pinpoint.common.util.ByteSizeUnit;
import com.navercorp.pinpoint.grpc.ChannelTypeEnum;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class ClientOption {
    public static final long DEFAULT_KEEPALIVE_TIME = TimeUnit.SECONDS.toMillis(30L);
    public static final long DEFAULT_KEEPALIVE_TIMEOUT = TimeUnit.SECONDS.toMillis(60L);
    public static final long IDLE_TIMEOUT_MILLIS_DISABLE = TimeUnit.DAYS.toMillis(30L);
    public static final boolean KEEPALIVE_WITHOUT_CALLS_DISABLE = Boolean.FALSE;
    public static final int DEFAULT_MAX_HEADER_LIST_SIZE = 8192;
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 0x400000;
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 0x100000;
    public static final int INITIAL_FLOW_CONTROL_WINDOW = 65535;
    public static final int DEFAULT_CONNECT_TIMEOUT = 3000;
    public static final int DEFAULT_WRITE_BUFFER_HIGH_WATER_MARK = 0x2000000;
    public static final int DEFAULT_WRITE_BUFFER_LOW_WATER_MARK = 0x1000000;
    public static final String DEFAULT_CHANNEL_TYPE = ChannelTypeEnum.AUTO.name();
    public static final int DEFAULT_MAX_TRACE_EVENT = 0;
    public static final int DEFAULT_LIMIT_COUNT = 100;
    public static final int DEFAULT_LIMIT_TIME = 60000;
    @Value(value="${keepalive.time.millis}")
    private long keepAliveTime = DEFAULT_KEEPALIVE_TIME;
    @Value(value="${keepalive.timeout.millis}")
    private long keepAliveTimeout = DEFAULT_KEEPALIVE_TIMEOUT;
    private boolean keepAliveWithoutCalls = KEEPALIVE_WITHOUT_CALLS_DISABLE;
    private long idleTimeoutMillis = IDLE_TIMEOUT_MILLIS_DISABLE;
    private int maxHeaderListSize = 8192;
    private int maxInboundMessageSize = 0x400000;
    private int flowControlWindow = 0x100000;
    @Value(value="${connect.timeout.millis}")
    private int connectTimeout = 3000;
    private int writeBufferHighWaterMark = 0x2000000;
    private int writeBufferLowWaterMark = 0x1000000;
    private ChannelTypeEnum channelTypeEnum = ChannelTypeEnum.AUTO;
    @Value(value="${maxtraceevent}")
    private int maxTraceEvent;
    @Value(value="${limitcount}")
    private int limitCount;
    @Value(value="${limittime}")
    private long limitTime;

    public ClientOption() {
    }

    public ClientOption(long keepAliveTime, long keepAliveTimeout, int maxHeaderListSize, int maxInboundMessageSize, int flowControlWindow, int connectTimeout, int writeBufferHighWaterMark, int writeBufferLowWaterMark, ChannelTypeEnum channelTypeEnum, int maxTraceEvent, int limitCount, long limitTime) {
        this.keepAliveTime = keepAliveTime;
        this.keepAliveTimeout = keepAliveTimeout;
        this.flowControlWindow = flowControlWindow;
        this.maxHeaderListSize = maxHeaderListSize;
        this.maxInboundMessageSize = maxInboundMessageSize;
        this.connectTimeout = connectTimeout;
        this.writeBufferHighWaterMark = writeBufferHighWaterMark;
        this.writeBufferLowWaterMark = writeBufferLowWaterMark;
        this.channelTypeEnum = Objects.requireNonNull(channelTypeEnum, "channelTypeEnum");
        this.maxTraceEvent = maxTraceEvent;
        this.limitCount = limitCount;
        this.limitTime = limitTime;
    }

    public int getFlowControlWindow() {
        return this.flowControlWindow;
    }

    public int getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public boolean isKeepAliveWithoutCalls() {
        return this.keepAliveWithoutCalls;
    }

    public long getIdleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    public int getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getWriteBufferHighWaterMark() {
        return this.writeBufferHighWaterMark;
    }

    public int getWriteBufferLowWaterMark() {
        return this.writeBufferLowWaterMark;
    }

    public ChannelTypeEnum getChannelTypeEnum() {
        return this.channelTypeEnum;
    }

    @Value(value="${channel-type}")
    void setChannelType(String channelType) {
        this.channelTypeEnum = ChannelTypeEnum.valueOf(channelType);
    }

    public int getMaxTraceEvent() {
        return this.maxTraceEvent;
    }

    public int getLimitCount() {
        return this.limitCount;
    }

    public long getLimitTime() {
        return this.limitTime;
    }

    @Value(value="${headers.size.max}")
    void setMaxHeaderListSize(String maxHeaderListSize) {
        this.maxHeaderListSize = (int)ByteSizeUnit.getByteSize((String)maxHeaderListSize, (long)8192L);
    }

    @Value(value="${message.inbound.size.max}")
    void setMaxInboundMessageSize(String maxInboundMessageSize) {
        this.maxInboundMessageSize = (int)ByteSizeUnit.getByteSize((String)maxInboundMessageSize, (long)0x400000L);
    }

    @Value(value="${flow-control.window.size}")
    void setFlowControlWindow(String flowControlWindow) {
        this.flowControlWindow = (int)ByteSizeUnit.getByteSize((String)flowControlWindow, (long)0x100000L);
    }

    @Value(value="${write.buffer.highwatermark}")
    void setWriteBufferHighWaterMark(String writeBufferHighWaterMark) {
        this.writeBufferHighWaterMark = (int)ByteSizeUnit.getByteSize((String)writeBufferHighWaterMark, (long)0x2000000L);
    }

    @Value(value="${write.buffer.lowwatermark}")
    void setWriteBufferLowWaterMark(String writeBufferLowWaterMark) {
        this.writeBufferLowWaterMark = (int)ByteSizeUnit.getByteSize((String)writeBufferLowWaterMark, (long)0x1000000L);
    }

    public String toString() {
        return "ClientOption{keepAliveTime=" + this.keepAliveTime + ", keepAliveTimeout=" + this.keepAliveTimeout + ", keepAliveWithoutCalls=" + this.keepAliveWithoutCalls + ", idleTimeoutMillis=" + this.idleTimeoutMillis + ", maxHeaderListSize=" + this.maxHeaderListSize + ", maxInboundMessageSize=" + this.maxInboundMessageSize + ", flowControlWindow=" + this.flowControlWindow + ", connectTimeout=" + this.connectTimeout + ", writeBufferHighWaterMark=" + this.writeBufferHighWaterMark + ", writeBufferLowWaterMark=" + this.writeBufferLowWaterMark + ", channelTypeEnum=" + (Object)((Object)this.channelTypeEnum) + ", maxTraceEvent=" + this.maxTraceEvent + ", limitCount=" + this.limitCount + ", limitTime=" + this.limitTime + '}';
    }
}

