/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.meshmessage.resolver.http;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageRequestBody;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageRequestHeader;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;

public class SendMessageRequestProtocolResolver {
    public static CloudEvent buildEvent(Header header, Body body) throws ProtocolHandleException {
        try {
            SendMessageRequestHeader sendMessageRequestHeader = (SendMessageRequestHeader)header;
            SendMessageRequestBody sendMessageRequestBody = (SendMessageRequestBody)body;
            String protocolType = sendMessageRequestHeader.getProtocolType();
            String protocolDesc = sendMessageRequestHeader.getProtocolDesc();
            String protocolVersion = sendMessageRequestHeader.getProtocolVersion();
            String code = sendMessageRequestHeader.getCode();
            String env = sendMessageRequestHeader.getEnv();
            String idc = sendMessageRequestHeader.getIdc();
            String ip = sendMessageRequestHeader.getIp();
            String pid = sendMessageRequestHeader.getPid();
            String sys = sendMessageRequestHeader.getSys();
            String username = sendMessageRequestHeader.getUsername();
            String passwd = sendMessageRequestHeader.getPasswd();
            ProtocolVersion version = sendMessageRequestHeader.getVersion();
            String language = sendMessageRequestHeader.getLanguage();
            String content = sendMessageRequestBody.getContent();
            CloudEvent event = null;
            if (StringUtils.equalsAny((CharSequence)protocolVersion, (CharSequence[])new CharSequence[]{SpecVersion.V1.toString(), SpecVersion.V03.toString()})) {
                CloudEventBuilder cloudEventBuilder = CloudEventBuilder.fromSpecVersion((SpecVersion)SpecVersion.parse((String)protocolVersion));
                cloudEventBuilder = cloudEventBuilder.withId(sendMessageRequestBody.getBizSeqNo()).withSubject(sendMessageRequestBody.getTopic()).withType("eventmeshmessage").withSource(URI.create("/")).withData(content.getBytes(Constants.DEFAULT_CHARSET)).withExtension("code", code).withExtension("env", env).withExtension("idc", idc).withExtension("ip", ip).withExtension("pid", pid).withExtension("sys", sys).withExtension("username", username).withExtension("passwd", passwd).withExtension("version", version.getVersion()).withExtension("language", language).withExtension("protocoltype", protocolType).withExtension("protocoldesc", protocolDesc).withExtension("protocolversion", protocolVersion).withExtension("bizseqno", sendMessageRequestBody.getBizSeqNo()).withExtension("uniqueid", sendMessageRequestBody.getUniqueId()).withExtension("producergroup", sendMessageRequestBody.getProducerGroup()).withExtension("ttl", sendMessageRequestBody.getTtl());
                if (StringUtils.isNotEmpty((CharSequence)sendMessageRequestBody.getTag())) {
                    cloudEventBuilder = cloudEventBuilder.withExtension("tag", sendMessageRequestBody.getTag());
                }
                if (sendMessageRequestBody.getExtFields() != null && sendMessageRequestBody.getExtFields().size() > 0) {
                    for (Map.Entry entry : sendMessageRequestBody.getExtFields().entrySet()) {
                        cloudEventBuilder = cloudEventBuilder.withExtension((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                event = cloudEventBuilder.build();
            }
            return event;
        }
        catch (Exception e) {
            throw new ProtocolHandleException(e.getMessage(), e.getCause());
        }
    }
}

