/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.mongodb.consumer;

import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.MongoChangeStreamCursor;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.Properties;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.AsyncConsumeContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.api.consumer.Consumer;
import org.apache.eventmesh.storage.mongodb.client.MongodbClientManager;
import org.apache.eventmesh.storage.mongodb.config.ConfigurationHolder;
import org.apache.eventmesh.storage.mongodb.utils.MongodbCloudEventUtil;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbReplicaSetConsumer
implements Consumer {
    private static final Logger log = LoggerFactory.getLogger(MongodbReplicaSetConsumer.class);
    private final ConfigurationHolder configurationHolder;
    private MongoClient mongoClient;
    private MongoChangeStreamCursor<ChangeStreamDocument<Document>> cursor;
    private volatile boolean started = false;
    private EventListener eventListener;

    public MongodbReplicaSetConsumer(ConfigurationHolder configurationHolder) {
        this.configurationHolder = configurationHolder;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public void start() {
        if (!this.started) {
            this.started = true;
        }
    }

    public void shutdown() {
        if (this.started) {
            try {
                if (this.mongoClient != null) {
                    MongodbClientManager.closeMongodbClient(this.mongoClient);
                }
                if (this.cursor != null) {
                    this.cursor.close();
                }
            }
            finally {
                this.started = false;
            }
        }
    }

    public void init(Properties keyValue) {
        this.mongoClient = MongodbClientManager.createMongodbClient(this.configurationHolder.getUrl());
    }

    public void updateOffset(List<CloudEvent> cloudEvents, AbstractContext context) {
    }

    public void subscribe(String topic) {
        MongoCollection collection = this.mongoClient.getDatabase(this.configurationHolder.getDatabase()).getCollection(this.configurationHolder.getCollection());
        ChangeStreamIterable changeStreamDocuments = collection.watch();
        this.cursor = changeStreamDocuments.cursor();
        this.handle();
    }

    public void unsubscribe(String topic) {
        this.cursor.close();
    }

    public void registerEventListener(EventListener listener) {
        this.eventListener = listener;
    }

    private void handle() {
        while (this.cursor.hasNext()) {
            ChangeStreamDocument next = (ChangeStreamDocument)this.cursor.next();
            Document fullDocument = (Document)next.getFullDocument();
            if (fullDocument == null) continue;
            CloudEvent cloudEvent = MongodbCloudEventUtil.convertToCloudEvent(fullDocument);
            EventMeshAsyncConsumeContext consumeContext = new EventMeshAsyncConsumeContext(){

                public void commit(EventMeshAction action) {
                    log.info("[MongodbReplicaSetConsumer] Mongodb consumer context commit.");
                }
            };
            if (this.eventListener == null) continue;
            this.eventListener.consume(cloudEvent, (AsyncConsumeContext)consumeContext);
        }
    }
}

