/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.rpc.client.WriteFailFutureListener;
import com.navercorp.pinpoint.rpc.cluster.ClusterOption;
import com.navercorp.pinpoint.rpc.control.ProtocolException;
import com.navercorp.pinpoint.rpc.packet.ControlHandshakePacket;
import com.navercorp.pinpoint.rpc.packet.ControlHandshakeResponsePacket;
import com.navercorp.pinpoint.rpc.packet.HandshakeResponseCode;
import com.navercorp.pinpoint.rpc.util.ClassUtils;
import com.navercorp.pinpoint.rpc.util.ControlMessageEncodingUtils;
import com.navercorp.pinpoint.rpc.util.MapUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

public class PinpointClientHandshaker {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ChannelFutureListener handShakeFailFutureListener = new WriteFailFutureListener(this.logger, "HandShakePacket write fail.", "HandShakePacket write success.");
    private static final int STATE_INIT = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_FINISHED = 2;
    private final AtomicInteger state;
    private final AtomicInteger handshakeCount;
    private final Timer handshakerTimer;
    private final long retryInterval;
    private final int maxHandshakeCount;
    private final Object lock = new Object();
    private final AtomicReference<HandshakeResponseCode> handshakeResult = new AtomicReference<Object>(null);
    private final AtomicReference<ClusterOption> clusterOption = new AtomicReference<Object>(null);
    private final String id = ClassUtils.simpleClassNameAndHashCodeString(this);
    private final Map<String, Object> handshakeData;

    public PinpointClientHandshaker(Map<String, Object> handshakeData, Timer handshakerTimer, long retryInterval, int maxHandshakeCount) {
        Assert.isTrue((retryInterval > 0L ? 1 : 0) != 0, (String)"retryInterval must greater than zero.");
        Assert.isTrue((maxHandshakeCount > 0 ? 1 : 0) != 0, (String)"maxHandshakeCount must greater than zero.");
        this.state = new AtomicInteger(0);
        this.handshakerTimer = Objects.requireNonNull(handshakerTimer, "handshakerTimer");
        this.handshakeData = Objects.requireNonNull(handshakeData, "handshakeData");
        this.retryInterval = retryInterval;
        this.maxHandshakeCount = maxHandshakeCount;
        this.handshakeCount = new AtomicInteger(0);
    }

    public void handshakeStart(Channel channel) {
        this.logger.info("{} handshakeStart() started. channel:{}", (Object)this.id, (Object)channel);
        if (channel == null) {
            this.logger.warn("{} handshakeStart() failed. caused:channel must not be null.", (Object)this.id);
            return;
        }
        if (!channel.isConnected()) {
            this.logger.warn("{} handshakeStart() failed. caused:channel is not connected.", (Object)this.id);
            return;
        }
        if (!this.state.compareAndSet(0, 1)) {
            this.logger.warn("{} handshakeStart() failed. caused:unexpected state.", (Object)this.id);
            return;
        }
        HandshakeJob handshakeJob = null;
        try {
            handshakeJob = this.createHandshakeJob(channel);
        }
        catch (Exception e) {
            this.logger.warn("{} create HandshakeJob failed. caused:{}", (Object)this.id, (Object)e.getMessage(), (Object)e);
        }
        if (handshakeJob == null) {
            this.logger.warn("{} handshakeStart() failed. caused:handshakeJob must not be null.", (Object)this.id);
            this.handshakeAbort();
            return;
        }
        this.handshake(handshakeJob);
        this.reserveHandshake(handshakeJob);
        this.logger.info("{} handshakeStart() completed. channel:{}, data:{}", (Object)this.id, (Object)channel, this.handshakeData);
    }

    private HandshakeJob createHandshakeJob(Channel channel) throws ProtocolException {
        byte[] payload = ControlMessageEncodingUtils.encode(this.handshakeData);
        ControlHandshakePacket handshakePacket = new ControlHandshakePacket(0, payload);
        HandshakeJob handshakeJob = new HandshakeJob(channel, handshakePacket);
        return handshakeJob;
    }

    private void handshake(HandshakeJob handshakeJob) {
        this.handshakeCount.incrementAndGet();
        Channel channel = handshakeJob.getChannel();
        ControlHandshakePacket packet = handshakeJob.getHandshakePacket();
        this.logger.info("{} do handshake({}/{}). channel:{}.", (Object)this.id, (Object)this.handshakeCount.get(), (Object)this.maxHandshakeCount, (Object)channel);
        ChannelFuture future = channel.write((Object)packet);
        future.addListener(this.handShakeFailFutureListener);
    }

    private void reserveHandshake(HandshakeJob handshake) {
        if (this.handshakeCount.get() >= this.maxHandshakeCount) {
            this.logger.warn("{} reserveHandshake() failed. caused:Retry count is over({}/{}).", (Object)this.id, (Object)this.handshakeCount.get(), (Object)this.maxHandshakeCount);
            this.handshakeAbort();
            return;
        }
        this.logger.debug("{} reserveHandshake() started.", (Object)this.id);
        this.handshakerTimer.newTimeout((TimerTask)handshake, this.retryInterval, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handshakeComplete(ControlHandshakeResponsePacket responsePacket) {
        this.logger.info("{} handshakeComplete() started. responsePacket:{}", (Object)this.id, (Object)responsePacket);
        Object object = this.lock;
        synchronized (object) {
            if (!this.state.compareAndSet(1, 2)) {
                this.logger.info("{} handshakeComplete() failed. caused:unexpected state.", (Object)this.id);
                this.state.set(2);
                return false;
            }
            Map handshakeResponse = this.decode(responsePacket);
            HandshakeResponseCode code = this.getResponseCode(handshakeResponse);
            this.handshakeResult.compareAndSet(null, code);
            ClusterOption clusterOption = ClusterOption.getClusterOption(handshakeResponse);
            this.clusterOption.compareAndSet(null, clusterOption);
            this.logger.info("{} handshakeComplete() completed. handshake-response:{}.", (Object)this.id, (Object)handshakeResponse);
            return true;
        }
    }

    private Map decode(ControlHandshakeResponsePacket message) {
        byte[] payload = message.getPayload();
        if (payload == null) {
            return Collections.emptyMap();
        }
        try {
            Map result = (Map)ControlMessageEncodingUtils.decode(payload);
            return result;
        }
        catch (ProtocolException protocolException) {
            return Collections.emptyMap();
        }
    }

    private HandshakeResponseCode getResponseCode(Map handshakeResponse) {
        if (MapUtils.isEmpty(handshakeResponse)) {
            return HandshakeResponseCode.PROTOCOL_ERROR;
        }
        int code = MapUtils.getInteger(handshakeResponse, "code", -1);
        int subCode = MapUtils.getInteger(handshakeResponse, "subCode", -1);
        return HandshakeResponseCode.getValue(code, subCode);
    }

    public HandshakeResponseCode getHandshakeResult() {
        return this.handshakeResult.get();
    }

    public ClusterOption getClusterOption() {
        return this.clusterOption.get();
    }

    public void handshakeAbort() {
        this.logger.info("{} handshakeAbort() started.", (Object)this.id);
        if (!this.state.compareAndSet(1, 2)) {
            this.logger.info("{} unexpected state", (Object)this.id);
            this.state.set(2);
            return;
        }
        this.logger.info("{} handshakeAbort() completed.", (Object)this.id);
    }

    public boolean isRun() {
        int currentState = this.currentState();
        return this.isRun(currentState);
    }

    private boolean isRun(int currentState) {
        return currentState == 1;
    }

    public boolean isFinished() {
        int currentState = this.currentState();
        return this.isFinished(currentState);
    }

    private boolean isFinished(int currentState) {
        return currentState == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int currentState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state.get();
        }
    }

    private class HandshakeJob
    implements TimerTask {
        private final Channel channel;
        private final ControlHandshakePacket handshakePacket;

        public HandshakeJob(Channel channel, ControlHandshakePacket handshakePacket) {
            this.channel = channel;
            this.handshakePacket = handshakePacket;
        }

        public void run(Timeout timeout) throws Exception {
            PinpointClientHandshaker.this.logger.debug("{} HandshakeJob started.", (Object)PinpointClientHandshaker.this.id);
            if (timeout.isCancelled()) {
                PinpointClientHandshaker.this.reserveHandshake(this);
                return;
            }
            int currentState = PinpointClientHandshaker.this.currentState();
            if (PinpointClientHandshaker.this.isRun(currentState)) {
                PinpointClientHandshaker.this.handshake(this);
                PinpointClientHandshaker.this.reserveHandshake(this);
            } else if (PinpointClientHandshaker.this.isFinished(currentState)) {
                PinpointClientHandshaker.this.logger.info("{} HandshakeJob completed.", (Object)PinpointClientHandshaker.this.id);
            } else {
                PinpointClientHandshaker.this.logger.warn("{} HandshakeJob will be stop. caused:unexpected state.", (Object)PinpointClientHandshaker.this.id);
            }
        }

        public Channel getChannel() {
            return this.channel;
        }

        public ControlHandshakePacket getHandshakePacket() {
            return this.handshakePacket;
        }
    }
}

