/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.rpc.packet.stream.StreamPacket;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannel;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannelEventHandler;
import com.navercorp.pinpoint.rpc.stream.StreamChannelManager;
import com.navercorp.pinpoint.rpc.stream.StreamException;
import java.util.Objects;
import org.jboss.netty.channel.Channel;

public class PinpointClientHandlerContext {
    private final Channel channel;
    private final StreamChannelManager streamChannelManager;

    public PinpointClientHandlerContext(Channel channel, StreamChannelManager streamChannelManager) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.streamChannelManager = Objects.requireNonNull(streamChannelManager, "streamChannelManager");
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ClientStreamChannel openStream(byte[] payload, ClientStreamChannelEventHandler streamChannelEventHandler) throws StreamException {
        return this.streamChannelManager.openStream(payload, streamChannelEventHandler);
    }

    public ClientStreamChannel openStreamAndAwait(byte[] payload, ClientStreamChannelEventHandler streamChannelEventHandler, long timeout) throws StreamException {
        return this.streamChannelManager.openStreamAndAwait(payload, streamChannelEventHandler, timeout);
    }

    public void handleStreamEvent(StreamPacket message) {
        this.streamChannelManager.messageReceived(message);
    }

    public void closeAllStreamChannel() {
        this.streamChannelManager.close();
    }
}

