/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.api.RLexSortedSet;
import org.redisson.client.RedisClient;
import org.redisson.reactive.PublisherAdder;
import org.redisson.reactive.SetReactiveIterator;
import reactor.core.publisher.Flux;

public class RedissonLexSortedSetReactive {
    private final RLexSortedSet instance;

    public RedissonLexSortedSetReactive(RLexSortedSet instance) {
        this.instance = instance;
    }

    public Publisher<Boolean> addAll(Publisher<? extends String> c) {
        return new PublisherAdder<String>(){

            @Override
            public RFuture<Boolean> add(Object e) {
                return RedissonLexSortedSetReactive.this.instance.addAsync((String)e);
            }
        }.addAll(c);
    }

    private Publisher<String> scanIteratorReactive(final String pattern, final int count) {
        return Flux.create((Consumer)new SetReactiveIterator<String>(){

            @Override
            protected RFuture<ScanResult<Object>> scanIterator(RedisClient client, long nextIterPos) {
                return ((RedissonScoredSortedSet)((Object)RedissonLexSortedSetReactive.this.instance)).scanIteratorAsync(client, nextIterPos, pattern, count);
            }
        });
    }

    public Publisher<String> iterator() {
        return this.scanIteratorReactive(null, 10);
    }

    public Publisher<String> iterator(String pattern) {
        return this.scanIteratorReactive(pattern, 10);
    }

    public Publisher<String> iterator(int count) {
        return this.scanIteratorReactive(null, count);
    }

    public Publisher<String> iterator(String pattern, int count) {
        return this.scanIteratorReactive(pattern, count);
    }
}

