/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.rebalance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.registry.dto.EventMeshDataInfo;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.rebalance.EventMeshRebalanceStrategy;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.recommend.EventMeshRecommendImpl;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshRebalanceImpl
implements EventMeshRebalanceStrategy {
    private static final Logger log = LoggerFactory.getLogger(EventMeshRebalanceImpl.class);
    private final EventMeshTCPServer eventMeshTCPServer;

    public EventMeshRebalanceImpl(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    public void doRebalance() throws Exception {
        long startTime = System.currentTimeMillis();
        log.info("doRebalance start===========startTime:{}", (Object)startTime);
        Set groupSet = this.eventMeshTCPServer.getClientSessionGroupMapping().getClientGroupMap().keySet();
        if (CollectionUtils.isEmpty((Collection)groupSet)) {
            log.warn("doRebalance failed,eventmesh has no group, please check eventmeshData");
            return;
        }
        String cluster = this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshCluster();
        Map<String, String> localEventMeshMap = this.queryLocalEventMeshMap(cluster);
        if (MapUtils.isEmpty(localEventMeshMap)) {
            return;
        }
        for (String group : groupSet) {
            this.doRebalanceByGroup(cluster, group, "sub", localEventMeshMap);
            this.doRebalanceByGroup(cluster, group, "pub", localEventMeshMap);
        }
        log.info("doRebalance end===========startTime:{}, cost:{}", (Object)startTime, (Object)(System.currentTimeMillis() - startTime));
    }

    private Map<String, String> queryLocalEventMeshMap(String cluster) {
        HashMap<String, String> localEventMeshMap = null;
        List<EventMeshDataInfo> eventMeshDataInfoList = null;
        try {
            eventMeshDataInfoList = this.eventMeshTCPServer.getRegistry().findEventMeshInfoByCluster(cluster);
            if (eventMeshDataInfoList == null || CollectionUtils.isEmpty(eventMeshDataInfoList)) {
                log.warn("doRebalance failed,query eventmesh instances is null from registry,cluster:{}", (Object)cluster);
                return Collections.emptyMap();
            }
            localEventMeshMap = new HashMap<String, String>();
            String localIdc = this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshIDC();
            for (EventMeshDataInfo eventMeshDataInfo : eventMeshDataInfoList) {
                String idc = eventMeshDataInfo.getEventMeshName().split("-")[0];
                if (!StringUtils.isNotBlank((CharSequence)idc) || !StringUtils.equals((CharSequence)idc, (CharSequence)localIdc)) continue;
                localEventMeshMap.put(eventMeshDataInfo.getEventMeshName(), eventMeshDataInfo.getEndpoint());
            }
            if (0 == localEventMeshMap.size()) {
                log.warn("doRebalance failed,query eventmesh instances of localIDC is null from registry,localIDC:{},cluster:{}", (Object)localIdc, (Object)cluster);
                return Collections.emptyMap();
            }
        }
        catch (Exception e) {
            log.warn("doRebalance failed,findEventMeshInfoByCluster failed,cluster:{},errMsg:{}", (Object)cluster, (Object)e);
            return Collections.emptyMap();
        }
        return localEventMeshMap;
    }

    private void doRebalanceByGroup(String cluster, String group, String purpose, Map<String, String> eventMeshMap) throws Exception {
        log.info("doRebalanceByGroup start, cluster:{}, group:{}, purpose:{}", new Object[]{cluster, group, purpose});
        Map<String, Integer> clientDistributionMap = this.queryLocalEventMeshDistributeData(cluster, group, purpose, eventMeshMap);
        if (MapUtils.isEmpty(clientDistributionMap)) {
            return;
        }
        this.doRebalanceRedirect(this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshName(), group, purpose, eventMeshMap, clientDistributionMap);
        log.info("doRebalanceByGroup end, cluster:{}, group:{}, purpose:{}", new Object[]{cluster, group, purpose});
    }

    private void doRebalanceRedirect(String currEventMeshName, String group, String purpose, Map<String, String> eventMeshMap, Map<String, Integer> clientDistributionMap) throws Exception {
        if (MapUtils.isEmpty(clientDistributionMap)) {
            return;
        }
        int judge = this.calculateRedirectNum(currEventMeshName, group, purpose, clientDistributionMap);
        if (judge > 0) {
            List<String> eventMeshRecommendResult = this.selectRedirectEventMesh(group, eventMeshMap, clientDistributionMap, judge, currEventMeshName);
            if (eventMeshRecommendResult == null || eventMeshRecommendResult.size() != judge) {
                log.warn("doRebalance failed,recommendEventMeshNum is not consistent,recommendResult:{},judge:{}", eventMeshRecommendResult, (Object)judge);
                return;
            }
            this.doRedirect(group, purpose, judge, eventMeshRecommendResult);
        } else {
            log.info("rebalance condition not satisfy,group:{}, purpose:{},judge:{}", new Object[]{group, purpose, judge});
        }
    }

    private void doRedirect(String group, String purpose, int judge, List<String> eventMeshRecommendResult) throws Exception {
        log.info("doRebalance redirect start---------------------group:{},judge:{}", (Object)group, (Object)judge);
        Set<Session> sessionSet = null;
        if ("sub".equals(purpose)) {
            sessionSet = this.eventMeshTCPServer.getClientSessionGroupMapping().getClientGroupMap().get(group).getGroupConsumerSessions();
        } else if ("pub".equals(purpose)) {
            sessionSet = this.eventMeshTCPServer.getClientSessionGroupMapping().getClientGroupMap().get(group).getGroupProducerSessions();
        } else {
            log.warn("doRebalance failed,param is illegal, group:{}, purpose:{}", (Object)group, (Object)purpose);
            return;
        }
        ArrayList<Session> sessionList = new ArrayList<Session>(sessionSet);
        Collections.shuffle(new ArrayList<Session>(sessionList));
        for (int i = 0; i < judge; ++i) {
            String newProxyIp = eventMeshRecommendResult.get(i).split(":")[0];
            String newProxyPort = eventMeshRecommendResult.get(i).split(":")[1];
            String redirectSessionAddr = EventMeshTcp2Client.redirectClient2NewEventMesh(this.eventMeshTCPServer, newProxyIp, Integer.parseInt(newProxyPort), (Session)sessionList.get(i), this.eventMeshTCPServer.getClientSessionGroupMapping());
            log.info("doRebalance,redirect sessionAddr:{}", (Object)redirectSessionAddr);
            ThreadUtils.sleep((long)this.eventMeshTCPServer.getEventMeshTCPConfiguration().getSleepIntervalInRebalanceRedirectMills(), (TimeUnit)TimeUnit.MILLISECONDS);
        }
        log.info("doRebalance redirect end---------------------group:{}", (Object)group);
    }

    private List<String> selectRedirectEventMesh(String group, Map<String, String> eventMeshMap, Map<String, Integer> clientDistributionMap, int judge, String eventMeshName) throws Exception {
        EventMeshRecommendImpl eventMeshRecommendStrategy = new EventMeshRecommendImpl(this.eventMeshTCPServer);
        return eventMeshRecommendStrategy.calculateRedirectRecommendEventMesh(eventMeshMap, clientDistributionMap, group, judge, eventMeshName);
    }

    public int calculateRedirectNum(String eventMeshName, String group, String purpose, Map<String, Integer> clientDistributionMap) throws Exception {
        int sum = 0;
        for (Integer item : clientDistributionMap.values()) {
            sum += item.intValue();
        }
        int currentNum = 0;
        if (clientDistributionMap.get(eventMeshName) != null) {
            currentNum = clientDistributionMap.get(eventMeshName);
        }
        int avgNum = sum / clientDistributionMap.size();
        int modNum = sum % clientDistributionMap.size();
        ArrayList<String> eventMeshList = new ArrayList<String>(clientDistributionMap.keySet());
        Collections.sort(eventMeshList);
        int index = -1;
        for (int i = 0; i < Math.min(modNum, eventMeshList.size()); ++i) {
            if (!StringUtils.equals((CharSequence)eventMeshName, (CharSequence)((CharSequence)eventMeshList.get(i)))) continue;
            index = i;
            break;
        }
        int rebalanceResult = 0;
        rebalanceResult = avgNum == 0 ? 1 : (modNum != 0 && index < modNum && index >= 0 ? avgNum + 1 : avgNum);
        log.info("rebalance caculateRedirectNum,group:{}, purpose:{},sum:{},avgNum:{},modNum:{}, index:{}, currentNum:{}, rebalanceResult:{}", new Object[]{group, purpose, sum, avgNum, modNum, index, currentNum, rebalanceResult});
        return currentNum - rebalanceResult;
    }

    private Map<String, Integer> queryLocalEventMeshDistributeData(String cluster, String group, String purpose, Map<String, String> eventMeshMap) {
        HashMap<String, Integer> localEventMeshDistributeData = null;
        Map<String, Map<String, Integer>> eventMeshClientDistributionDataMap = null;
        try {
            eventMeshClientDistributionDataMap = this.eventMeshTCPServer.getRegistry().findEventMeshClientDistributionData(cluster, group, purpose);
            if (MapUtils.isEmpty(eventMeshClientDistributionDataMap)) {
                log.warn("doRebalance failed,found no distribute data in regitry, cluster:{}, group:{}, purpose:{}", new Object[]{cluster, group, purpose});
                return Collections.emptyMap();
            }
            localEventMeshDistributeData = new HashMap<String, Integer>();
            String localIdc = this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshIDC();
            for (Map.Entry<String, Map<String, Integer>> entry : eventMeshClientDistributionDataMap.entrySet()) {
                String idc = entry.getKey().split("-")[0];
                if (!StringUtils.isNotBlank((CharSequence)idc) || !StringUtils.equals((CharSequence)idc, (CharSequence)localIdc)) continue;
                localEventMeshDistributeData.put(entry.getKey(), entry.getValue().get(purpose));
            }
            if (0 == localEventMeshDistributeData.size()) {
                log.warn("doRebalance failed,found no distribute data of localIDC in regitry,cluster:{},group:{}, purpose:{},localIDC:{}", new Object[]{cluster, group, purpose, localIdc});
                return Collections.emptyMap();
            }
            log.info("before revert clientDistributionMap:{}, group:{}, purpose:{}", new Object[]{localEventMeshDistributeData, group, purpose});
            for (String eventMeshName : localEventMeshDistributeData.keySet()) {
                if (eventMeshMap.containsKey(eventMeshName)) continue;
                log.warn("doRebalance failed,exist eventMesh not register but exist in distributionMap,cluster:{},grpup:{},purpose:{},eventMeshName:{}", new Object[]{cluster, group, purpose, eventMeshName});
                return Collections.emptyMap();
            }
            for (String eventMesh : eventMeshMap.keySet()) {
                if (localEventMeshDistributeData.containsKey(eventMesh)) continue;
                localEventMeshDistributeData.put(eventMesh, 0);
            }
            log.info("after revert clientDistributionMap:{}, group:{}, purpose:{}", new Object[]{localEventMeshDistributeData, group, purpose});
        }
        catch (Exception e) {
            log.warn("doRebalance failed,cluster:{},group:{},purpose:{},findProxyClientDistributionData failed, errMsg:{}", new Object[]{cluster, group, purpose, e});
            return Collections.emptyMap();
        }
        return localEventMeshDistributeData;
    }
}

