/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.consumer;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicConf;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.EventMeshConsumer;

public class ConsumerGroupManager {
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final EventMeshHTTPServer eventMeshHTTPServer;
    private final EventMeshConsumer eventMeshConsumer;
    private ConsumerGroupConf consumerGroupConfig;

    public ConsumerGroupManager(EventMeshHTTPServer eventMeshHTTPServer, ConsumerGroupConf consumerGroupConfig) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
        this.consumerGroupConfig = consumerGroupConfig;
        this.eventMeshConsumer = new EventMeshConsumer(this.eventMeshHTTPServer, this.consumerGroupConfig);
    }

    public void init() throws Exception {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        this.eventMeshConsumer.init();
    }

    public void start() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.setupEventMeshConsumer(this.consumerGroupConfig);
        this.eventMeshConsumer.start();
    }

    private synchronized void setupEventMeshConsumer(ConsumerGroupConf consumerGroupConfig) throws Exception {
        for (Map.Entry<String, ConsumerGroupTopicConf> conf : consumerGroupConfig.getConsumerGroupTopicConf().entrySet()) {
            this.eventMeshConsumer.subscribe(conf.getKey(), conf.getValue().getSubscriptionItem());
        }
    }

    public void shutdown() throws Exception {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        this.eventMeshConsumer.shutdown();
    }

    public synchronized void refresh(ConsumerGroupConf consumerGroupConfig) throws Exception {
        if (consumerGroupConfig == null || this.consumerGroupConfig.equals(consumerGroupConfig)) {
            return;
        }
        if (this.started.get()) {
            this.shutdown();
        }
        this.consumerGroupConfig = consumerGroupConfig;
        this.eventMeshConsumer.setConsumerGroupConf(consumerGroupConfig);
        this.init();
        this.start();
    }

    public ConsumerGroupConf getConsumerGroupConfig() {
        return this.consumerGroupConfig;
    }

    public void unsubscribe(String consumerGroup) throws Exception {
        if (StringUtils.equals((CharSequence)this.consumerGroupConfig.getConsumerGroup(), (CharSequence)consumerGroup)) {
            Set<String> topics = this.consumerGroupConfig.getConsumerGroupTopicConf().keySet();
            for (String topic : topics) {
                ConsumerGroupTopicConf consumerGroupTopicConf = this.consumerGroupConfig.getConsumerGroupTopicConf().get(topic);
                this.eventMeshConsumer.unsubscribe(topic, consumerGroupTopicConf.getSubscriptionItem().getMode());
            }
        }
    }
}

