/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import com.google.common.util.concurrent.RateLimiter;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.RandomUtils;
import org.apache.eventmesh.api.registry.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.metrics.api.MetricsPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshServer;
import org.apache.eventmesh.runtime.configuration.EventMeshGrpcConfiguration;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.ConsumerManager;
import org.apache.eventmesh.runtime.core.protocol.grpc.producer.ProducerManager;
import org.apache.eventmesh.runtime.core.protocol.grpc.retry.GrpcRetryer;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ConsumerService;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.HeartbeatService;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.PublisherService;
import org.apache.eventmesh.runtime.metrics.grpc.EventMeshGrpcMonitor;
import org.apache.eventmesh.runtime.registry.Registry;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshGrpcServer {
    private static final Logger log = LoggerFactory.getLogger(EventMeshGrpcServer.class);
    private final EventMeshGrpcConfiguration eventMeshGrpcConfiguration;
    private static final int MIN_LIMIT = 5;
    private static final int MAX_LIMIT = 10;
    private Server server;
    private ProducerManager producerManager;
    private ConsumerManager consumerManager;
    private GrpcRetryer grpcRetryer;
    private ThreadPoolExecutor sendMsgExecutor;
    private ThreadPoolExecutor replyMsgExecutor;
    private ThreadPoolExecutor clientMgmtExecutor;
    private ThreadPoolExecutor pushMsgExecutor;
    private List<CloseableHttpClient> httpClientPool;
    private RateLimiter msgRateLimiter;
    private final Registry registry;
    private final Acl acl;
    private final EventMeshServer eventMeshServer;
    private EventMeshGrpcMonitor eventMeshGrpcMonitor;

    public EventMeshGrpcServer(EventMeshServer eventMeshServer, EventMeshGrpcConfiguration eventMeshGrpcConfiguration) {
        this.eventMeshServer = eventMeshServer;
        this.eventMeshGrpcConfiguration = eventMeshGrpcConfiguration;
        this.registry = eventMeshServer.getRegistry();
        this.acl = eventMeshServer.getAcl();
    }

    public void init() throws Exception {
        log.info("==================EventMeshGRPCServer Initializing==================");
        this.initThreadPool();
        this.initHttpClientPool();
        this.msgRateLimiter = RateLimiter.create((double)this.eventMeshGrpcConfiguration.getEventMeshMsgReqNumPerSecond());
        this.producerManager = new ProducerManager(this);
        this.producerManager.init();
        this.consumerManager = new ConsumerManager(this);
        this.consumerManager.init();
        this.grpcRetryer = new GrpcRetryer(this);
        this.grpcRetryer.init();
        int serverPort = this.eventMeshGrpcConfiguration.getGrpcServerPort();
        this.server = ServerBuilder.forPort((int)serverPort).addService((BindableService)new ConsumerService(this, this.sendMsgExecutor, this.replyMsgExecutor)).addService((BindableService)new HeartbeatService(this, this.sendMsgExecutor)).addService((BindableService)new PublisherService(this, this.sendMsgExecutor)).build();
        this.initMetricsMonitor();
        log.info("GRPCServer[port={}] started", (Object)serverPort);
        log.info("-----------------EventMeshGRPCServer initialized");
    }

    public void start() throws Exception {
        log.info("---------------EventMeshGRPCServer starting-------------------");
        this.producerManager.start();
        this.consumerManager.start();
        this.grpcRetryer.start();
        this.server.start();
        if (this.eventMeshGrpcConfiguration.isEventMeshServerRegistryEnable()) {
            this.register();
        }
        this.eventMeshGrpcMonitor.start();
        log.info("---------------EventMeshGRPCServer running-------------------");
    }

    public void shutdown() throws Exception {
        log.info("---------------EventMeshGRPCServer stopping-------------------");
        this.producerManager.shutdown();
        this.consumerManager.shutdown();
        this.grpcRetryer.shutdown();
        this.shutdownThreadPools();
        this.shutdownHttpClientPool();
        this.server.shutdown();
        if (this.eventMeshGrpcConfiguration.isEventMeshServerRegistryEnable()) {
            this.unRegister();
        }
        this.eventMeshGrpcMonitor.shutdown();
        log.info("---------------EventMeshGRPCServer stopped-------------------");
    }

    public boolean register() {
        boolean registerResult = false;
        try {
            String endPoints = IPUtils.getLocalAddress() + ":" + this.eventMeshGrpcConfiguration.getGrpcServerPort();
            EventMeshRegisterInfo eventMeshRegisterInfo = new EventMeshRegisterInfo();
            eventMeshRegisterInfo.setEventMeshClusterName(this.eventMeshGrpcConfiguration.getEventMeshCluster());
            eventMeshRegisterInfo.setEventMeshName(this.eventMeshGrpcConfiguration.getEventMeshName() + "-" + "GRPC");
            eventMeshRegisterInfo.setEndPoint(endPoints);
            eventMeshRegisterInfo.setProtocolType("GRPC");
            registerResult = this.registry.register(eventMeshRegisterInfo);
        }
        catch (Exception e) {
            log.warn("eventMesh register to registry failed", (Throwable)e);
        }
        return registerResult;
    }

    private void unRegister() throws Exception {
        String endPoints = IPUtils.getLocalAddress() + ":" + this.eventMeshGrpcConfiguration.getGrpcServerPort();
        EventMeshUnRegisterInfo eventMeshUnRegisterInfo = new EventMeshUnRegisterInfo();
        eventMeshUnRegisterInfo.setEventMeshClusterName(this.eventMeshGrpcConfiguration.getEventMeshCluster());
        eventMeshUnRegisterInfo.setEventMeshName(this.eventMeshGrpcConfiguration.getEventMeshName());
        eventMeshUnRegisterInfo.setEndPoint(endPoints);
        eventMeshUnRegisterInfo.setProtocolType("GRPC");
        boolean registerResult = this.registry.unRegister(eventMeshUnRegisterInfo);
        if (!registerResult) {
            throw new EventMeshException("eventMesh fail to unRegister");
        }
    }

    public EventMeshGrpcConfiguration getEventMeshGrpcConfiguration() {
        return this.eventMeshGrpcConfiguration;
    }

    public ProducerManager getProducerManager() {
        return this.producerManager;
    }

    public ConsumerManager getConsumerManager() {
        return this.consumerManager;
    }

    public GrpcRetryer getGrpcRetryer() {
        return this.grpcRetryer;
    }

    public ThreadPoolExecutor getSendMsgExecutor() {
        return this.sendMsgExecutor;
    }

    public ThreadPoolExecutor getClientMgmtExecutor() {
        return this.clientMgmtExecutor;
    }

    public ThreadPoolExecutor getPushMsgExecutor() {
        return this.pushMsgExecutor;
    }

    public RateLimiter getMsgRateLimiter() {
        return this.msgRateLimiter;
    }

    public CloseableHttpClient getHttpClient() {
        int size = this.httpClientPool.size();
        return this.httpClientPool.get(RandomUtils.nextInt((int)size, (int)(2 * size)) % size);
    }

    public EventMeshGrpcMonitor getMetricsMonitor() {
        return this.eventMeshGrpcMonitor;
    }

    private void initThreadPool() {
        LinkedBlockingQueue sendMsgThreadPoolQueue = new LinkedBlockingQueue(this.eventMeshGrpcConfiguration.getEventMeshServerSendMsgBlockQueueSize());
        this.sendMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshGrpcConfiguration.getEventMeshServerSendMsgThreadNum(), (int)this.eventMeshGrpcConfiguration.getEventMeshServerSendMsgThreadNum(), sendMsgThreadPoolQueue, (String)"eventMesh-grpc-sendMsg", (boolean)true);
        LinkedBlockingQueue subscribeMsgThreadPoolQueue = new LinkedBlockingQueue(this.eventMeshGrpcConfiguration.getEventMeshServerSubscribeMsgBlockQueueSize());
        this.clientMgmtExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshGrpcConfiguration.getEventMeshServerSubscribeMsgThreadNum(), (int)this.eventMeshGrpcConfiguration.getEventMeshServerSubscribeMsgThreadNum(), subscribeMsgThreadPoolQueue, (String)"eventMesh-grpc-clientMgmt", (boolean)true);
        LinkedBlockingQueue pushMsgThreadPoolQueue = new LinkedBlockingQueue(this.eventMeshGrpcConfiguration.getEventMeshServerPushMsgBlockQueueSize());
        this.pushMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshGrpcConfiguration.getEventMeshServerPushMsgThreadNum(), (int)this.eventMeshGrpcConfiguration.getEventMeshServerPushMsgThreadNum(), pushMsgThreadPoolQueue, (String)"eventMesh-grpc-pushMsg", (boolean)true);
        this.replyMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshGrpcConfiguration.getEventMeshServerReplyMsgThreadNum(), (int)this.eventMeshGrpcConfiguration.getEventMeshServerReplyMsgThreadNum(), sendMsgThreadPoolQueue, (String)"eventMesh-grpc-replyMsg", (boolean)true);
    }

    private void initHttpClientPool() {
        this.httpClientPool = new LinkedList<CloseableHttpClient>();
        int clientPool = RandomUtils.nextInt((int)5, (int)10);
        for (int i = 0; i < clientPool; ++i) {
            CloseableHttpClient client = HttpClients.createDefault();
            this.httpClientPool.add(client);
        }
    }

    private void initMetricsMonitor() throws Exception {
        ArrayList metricsRegistries = Lists.newArrayList();
        Optional.ofNullable(this.eventMeshGrpcConfiguration.getEventMeshMetricsPluginType()).ifPresent(metricsPlugins -> metricsPlugins.forEach(pluginType -> metricsRegistries.add(MetricsPluginFactory.getMetricsRegistry((String)pluginType))));
        this.eventMeshGrpcMonitor = new EventMeshGrpcMonitor(this, metricsRegistries);
        this.eventMeshGrpcMonitor.init();
    }

    private void shutdownThreadPools() {
        this.sendMsgExecutor.shutdown();
        this.clientMgmtExecutor.shutdown();
        this.pushMsgExecutor.shutdown();
        this.replyMsgExecutor.shutdown();
    }

    private void shutdownHttpClientPool() {
        Iterator<CloseableHttpClient> itr = this.httpClientPool.iterator();
        while (itr.hasNext()) {
            CloseableHttpClient client = itr.next();
            try {
                client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            itr.remove();
        }
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Acl getAcl() {
        return this.acl;
    }
}

