/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.util;

import com.navercorp.pinpoint.profiler.util.ObjectPoolFactory;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ObjectPool<T> {
    private final Queue<T> queue = new ConcurrentLinkedQueue<T>();
    private final ObjectPoolFactory<T> factory;

    public ObjectPool(ObjectPoolFactory<T> factory, int size) {
        this.factory = Objects.requireNonNull(factory, "factory");
        this.fill(size);
    }

    private void fill(int size) {
        for (int i = 0; i < size; ++i) {
            T t = this.factory.create();
            this.queue.offer(t);
        }
    }

    public T getObject() {
        T object = this.queue.poll();
        if (object == null) {
            return this.factory.create();
        }
        return object;
    }

    public void returnObject(T t) {
        if (t == null) {
            return;
        }
        this.factory.beforeReturn(t);
        this.queue.offer(t);
    }
}

