/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.metric.uri;

import com.navercorp.pinpoint.profiler.monitor.metric.uri.UriStatHistogram;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.UriStatInfo;

public class EachUriStatData {
    private final String uri;
    private final UriStatHistogram totalHistogram = new UriStatHistogram();
    private final UriStatHistogram failedHistogram = new UriStatHistogram();

    public EachUriStatData(String uri) {
        this.uri = uri;
    }

    public void add(UriStatInfo uriStatInfo) {
        boolean status = uriStatInfo.isStatus();
        this.totalHistogram.add(uriStatInfo.getElapsed());
        if (!status) {
            this.failedHistogram.add(uriStatInfo.getElapsed());
        }
    }

    public String getUri() {
        return this.uri;
    }

    public UriStatHistogram getTotalHistogram() {
        return this.totalHistogram;
    }

    public UriStatHistogram getFailedHistogram() {
        return this.failedHistogram;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EachUriStatData{");
        sb.append("uri='").append(this.uri).append('\'');
        sb.append(", totalHistogram=").append(this.totalHistogram);
        sb.append(", failedHistogram=").append(this.failedHistogram);
        sb.append('}');
        return sb.toString();
    }
}

