/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.scope;

import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import java.util.Objects;

public class DefaultTraceScope
implements TraceScope {
    private final String name;
    private int depth = 0;

    public DefaultTraceScope(String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    public String getName() {
        return this.name;
    }

    public boolean tryEnter() {
        ++this.depth;
        return true;
    }

    public boolean canLeave() {
        return this.isActive();
    }

    public void leave() {
        if (!this.isActive()) {
            throw new IllegalStateException("Cannot leave with scope. depth: " + this.depth);
        }
        --this.depth;
    }

    public boolean isActive() {
        return this.depth > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultTraceScope{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", depth=").append(this.depth);
        sb.append('}');
        return sb.toString();
    }
}

